/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable;

import com.appframework.utils.BlankIcon;
import com.appframework.utils.DoubleImageIcon;
import com.novell.gw.jclient.api.enums.FolderCalSubscribe;
import com.novell.gw.jclient.api.enums.FolderType;
import com.novell.gw.jclient.api.enums.MessageSentItemStatus;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IGroupContact;
import com.novell.gw.jclient.api.interfaces.ab.IOrganizationContact;
import com.novell.gw.jclient.api.interfaces.ab.IResourceContact;
import com.novell.gw.jclient.api.interfaces.ab.IUserContact;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IAppointment;
import com.novell.gw.jclient.api.interfaces.message.IDocumentReference;
import com.novell.gw.jclient.api.interfaces.message.IMail;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.api.interfaces.message.INote;
import com.novell.gw.jclient.api.interfaces.message.IPhoneMessage;
import com.novell.gw.jclient.api.interfaces.message.ISharedAddressBookNotification;
import com.novell.gw.jclient.api.interfaces.message.ISharedFolderNotification;
import com.novell.gw.jclient.api.interfaces.message.ITask;
import com.novell.gw.jclient.application.controls.LookAndFeelManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class IconsFactory {
    private static final Logger logger = Logger.getLogger(IconsFactory.class);
    private static final Icon BLANK_ICON = new BlankIcon();

    public static Icon getReplyForwardDelegateDraftIcon(IMessage message) {
        ImageIcon icon = null;
        boolean isDelegated = message instanceof INote && ((INote)message).isDelegated();
        boolean isReplied = message.isRepliedTo();
        boolean isForwarded = message.isForwarded();
        if (isDelegated && isReplied && isForwarded) {
            icon = ImageResources.ICON_ITEM_DELEGATED_FORWARDED_REPLIED;
        } else if (isDelegated && isForwarded) {
            icon = ImageResources.ICON_ITEM_DELEGATED_FORWARDED;
        } else if (isDelegated && isReplied) {
            icon = ImageResources.ICON_ITEM_DELEGATED_REPLIED;
        } else if (isForwarded && isReplied) {
            icon = ImageResources.ICON_ITEM_FORWARDED_REPLIED;
        } else if (isReplied) {
            icon = ImageResources.ICON_ITEM_REPLIED;
        } else if (isForwarded) {
            icon = ImageResources.ICON_ITEM_FORWARDED;
        } else if (isDelegated) {
            icon = ImageResources.ICON_ITEM_DELEGATED;
        } else if (message.isDraft()) {
            icon = ImageResources.ICON_ITEM_DRAFT;
        }
        return icon;
    }

    public static Icon[] getAdditionalFolderIcons(IFolder folder) {
        ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>();
        if (folder.hasUnreadItems()) {
            if (folder.getType() == FolderType.OUTBOX) {
                icons.add(ImageResources.ICON_UNSENT_ITEMS);
            } else if (folder.getType() == FolderType.CALENDAR) {
                icons.add(ImageResources.ICON_CLOCK_CAL_ITEMS);
            } else if (folder.getType() != FolderType.TRASH || folder.getType() != FolderType.USER) {
                icons.add(ImageResources.ICON_UNOPENED_ITEMS);
            }
        }
        return icons.toArray(new Icon[icons.size()]);
    }

    public static Icon[] getAdditionalMessageIcons(IMessage message) {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        Icon icon = IconsFactory.getReplyForwardDelegateDraftIcon(message);
        if (icon != null) {
            icons.add(icon);
        }
        if (message.getBoxType() == 2) {
            icons.add(ImageResources.ITM_SENT);
        }
        if (message.isPersonal()) {
            icons.add(ImageResources.ICON_POSTED);
        }
        if (message.hasPaperclipAttachments() && !message.isDigitallyClearSigned() && !message.isDigitallySigned()) {
            icons.add(ImageResources.ICON_ATTACHMENT_SMALL);
        }
        if (message.isEncrypted() && (message.isDigitallyClearSigned() || message.isDigitallySigned())) {
            icons.add(ImageResources.SECURITY_SIGNED_AND_ENCRYPTED);
        } else if (message.isEncrypted()) {
            icons.add(ImageResources.SECURITY_ENCRYPTED);
        } else if ((message.isDigitallyClearSigned() || message.isDigitallySigned()) && message.hasPaperclipAttachments()) {
            icons.add(ImageResources.SECURITY_SIGNED_CLIP);
        } else if (message.isDigitallyClearSigned() || message.isDigitallySigned()) {
            icons.add(ImageResources.SECURITY_SIGNED);
        }
        if (message.isStubbedOr3rdPartyOnlyItem()) {
            icons.add(ImageResources.STUBBED_ITEM_ICON);
        }
        return icons.toArray(new Icon[icons.size()]);
    }

    private static Icon getIconForMail(IMail mail) {
        Icon result = mail instanceof ISharedAddressBookNotification ? ImageResources.ICON_SHARED_TO_ME_ADDRESS_BOOK : (mail instanceof ISharedFolderNotification ? ImageResources.ICON_ITM_SHARED_FOLDER : (mail instanceof IPhoneMessage ? IconsFactory.getIconForPhoneMessage((IPhoneMessage)mail) : (mail.getBoxType() != 2 && mail.isRead() || mail.getBoxType() == 2 && mail.getOpenTotals() > 0 ? (mail.getPriority() == 4 ? ImageResources.ITM_MAIL_READ_HIGH : (mail.getPriority() == 1 ? ImageResources.ITM_MAIL_READ_LOW : ImageResources.ITM_MAIL_READ)) : (mail.getPriority() == 4 ? ImageResources.ITM_MAIL_UNREAD_HIGH : (mail.getPriority() == 1 ? ImageResources.ITM_MAIL_UNREAD_LOW : ImageResources.ITM_MAIL_UNREAD)))));
        return result;
    }

    private static Icon getIconForNote(INote note) {
        Icon icon = note instanceof ITask ? IconsFactory.getIconForTask((ITask)note) : (note instanceof IAppointment ? IconsFactory.getIconForAppointment((IAppointment)note) : (note.getBoxType() != 2 && note.isRead() || note.getBoxType() == 2 && note.getOpenTotals() > 0 ? (note.getPriority() == 4 ? ImageResources.ITM_NOTE_READ_HIGH : (note.getPriority() == 1 ? ImageResources.ITM_NOTE_READ_LOW : ImageResources.ITM_NOTE_READ)) : (note.getPriority() == 4 ? ImageResources.ITM_NOTE_UNREAD_HIGH : (note.getPriority() == 1 ? ImageResources.ITM_NOTE_UNREAD_LOW : ImageResources.ITM_NOTE_UNREAD))));
        return icon;
    }

    private static Icon getIconForAppointment(IAppointment appointment) {
        ImageIcon icon = appointment.getBoxType() != 2 && appointment.isRead() || appointment.getBoxType() == 2 && appointment.getOpenTotals() > 0 ? (appointment.getPriority() == 4 ? ImageResources.ITM_APPOINTMENT_READ_HIGH : (appointment.getPriority() == 1 ? ImageResources.ITM_APPOINTMENT_READ_LOW : ImageResources.ITM_APPOINTMENT_READ)) : (appointment.getPriority() == 4 ? ImageResources.ITM_APPOINTMENT_UNREAD_HIGH : (appointment.getPriority() == 1 ? ImageResources.ITM_APPOINTMENT_UNREAD_LOW : ImageResources.ITM_APPOINTMENT_UNREAD));
        return icon;
    }

    public static Icon getSentItemStatusIcon(IMessage message) {
        if (message.getBoxType() == 2) {
            MessageSentItemStatus sentItemStatus = message.getSentItemStatus();
            if (sentItemStatus == MessageSentItemStatus.PENDING) {
                return ImageResources.ICON_ITEM_PENDING;
            }
            if (sentItemStatus == MessageSentItemStatus.REJECTED) {
                return ImageResources.ICON_ITEM_REJECTED;
            }
            if (sentItemStatus == MessageSentItemStatus.STATUS) {
                return ImageResources.ICON_ITEM_STATUS;
            }
            if (sentItemStatus == MessageSentItemStatus.UNDELIVERABLE) {
                return ImageResources.ICON_ITEM_UNDELIVERABLE;
            }
        }
        return null;
    }

    private static Icon getIconForTask(ITask task) {
        ImageIcon icon = task.getBoxType() != 2 && task.isRead() || task.getBoxType() == 2 && task.getOpenTotals() > 0 ? (task.getPriority() == 4 ? ImageResources.ITM_TASK_READ_HIGH : (task.getPriority() == 1 ? ImageResources.ITM_TASK_READ_LOW : ImageResources.ITM_TASK_READ)) : (task.getPriority() == 4 ? ImageResources.ITM_TASK_UNREAD_HIGH : (task.getPriority() == 1 ? ImageResources.ITM_TASK_UNREAD_LOW : ImageResources.ITM_TASK_UNREAD));
        return icon;
    }

    private static Icon getIconForPhoneMessage(IPhoneMessage phoneMessage) {
        ImageIcon result = phoneMessage.getBoxType() != 2 && phoneMessage.isRead() || phoneMessage.getBoxType() == 2 && phoneMessage.getOpenTotals() > 0 ? (phoneMessage.getPriority() == 4 ? ImageResources.ITM_PHONE_READ_HIGH : (phoneMessage.getPriority() == 1 ? ImageResources.ITM_PHONE_READ_LOW : ImageResources.ITM_PHONE_READ)) : (phoneMessage.getPriority() == 4 ? ImageResources.ITM_PHONE_UNREAD_HIGH : (phoneMessage.getPriority() == 1 ? ImageResources.ITM_PHONE_UNREAD_LOW : ImageResources.ITM_PHONE_UNREAD));
        return result;
    }

    public static Icon getIconForItem(IItem item) {
        Icon icon = null;
        if (item instanceof IFolder) {
            icon = IconsFactory.getIconForFolder((IFolder)item);
        } else if (item instanceof IMessage) {
            icon = IconsFactory.getIconForMessage((IMessage)item);
        } else if (item instanceof IContact) {
            icon = IconsFactory.getIconForContact((IContact)item);
        }
        return icon;
    }

    public static Icon getIconForContact(IContact contact) {
        if (contact instanceof IGroupContact) {
            return ImageResources.GROUP_TABLE_ITEM;
        }
        if (contact instanceof IOrganizationContact) {
            return ImageResources.ORGANIZATION_TABLE_ITEM;
        }
        if (contact instanceof IResourceContact) {
            return ImageResources.RESOURCE_TABLE_ITEM;
        }
        if (contact instanceof IUserContact) {
            return ImageResources.CONTACT_TABLE_ITEM;
        }
        return ImageResources.CONTACT_TABLE_ITEM;
    }

    public static Icon getIconForFolder(IFolder folder) {
        return IconsFactory.getIconForFolder(folder, false);
    }

    public static Icon getIconForFolder(IFolder folder, boolean isOpenIcon) {
        ImageIcon icon = null;
        FolderType type = folder.getType();
        if (type == FolderType.UNIVERSAL) {
            icon = isOpenIcon ? ImageResources.FLD_MAILBOX_OPEN : ImageResources.FLD_MAILBOX;
        } else if (type == FolderType.USER) {
            icon = ImageResources.FLD_FOLDER_HOME;
        } else if (type == FolderType.CABINET) {
            icon = isOpenIcon ? ImageResources.FLD_CABINET_OPEN : ImageResources.FLD_CABINET;
        } else if (type == FolderType.CALENDAR) {
            icon = isOpenIcon ? ImageResources.FLD_CALENDAR_OPEN : ImageResources.FLD_CALENDAR;
        } else if (type == FolderType.CALENDAR_SUBSCRIBE) {
            logger.debug((Object)"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1");
        } else if (type == FolderType.TRASH) {
            icon = folder.getDisplayCount() > 0 ? ImageResources.FLD_TRASH_FILLED : ImageResources.FLD_TRASH_EMPTY;
        } else if (type == FolderType.QUERY) {
            icon = isOpenIcon ? ImageResources.FLD_QUERY_OPEN : ImageResources.FLD_QUERY;
        } else if (type == FolderType.OUTBOX) {
            icon = isOpenIcon ? ImageResources.FLD_SENTITEMS_OPEN : ImageResources.FLD_SENTITEMS;
        } else if (type == FolderType.CHECKLIST) {
            icon = ImageResources.FLD_CHEKLIST;
        } else if (type == FolderType.DOCUMENTS) {
            icon = isOpenIcon ? ImageResources.FLD_DOCUMENTS_OPEN : ImageResources.FLD_DOCUMENTS;
        } else if (type == FolderType.JUNKMAIL) {
            icon = isOpenIcon ? ImageResources.FLD_FOLDER_JUNKMAIL_OPEN : ImageResources.FLD_FOLDER_JUNKMAIL;
        } else if (type == FolderType.WORK_IN_PROGRESS) {
            icon = isOpenIcon ? ImageResources.FLD_WORKINPROGRESS_OPEN : ImageResources.FLD_WORKINPROGRESS;
        } else if (type == FolderType.CONTACTS || type == FolderType.USER_CONTACTS) {
            icon = isOpenIcon ? ImageResources.FLD_CONTACTS_OPEN : ImageResources.FLD_CONTACTS;
        } else if (type == FolderType.NNTP_NEWSGROUP) {
            icon = isOpenIcon ? ImageResources.FLD_NNTP_NEWSGROUPS_OPEN : ImageResources.FLD_NNTP_NEWSGROUPS_OPEN;
        } else if (type == FolderType.NNTP_SERVER) {
            icon = isOpenIcon ? ImageResources.FLD_NNTP_SERVER_OPEN : ImageResources.FLD_NNTP_SERVER;
        } else if (type == FolderType.IMAP) {
            icon = isOpenIcon ? ImageResources.FLD_IMAP_OPEN : ImageResources.FLD_IMAP;
        } else if (folder.isRssRootFolder() || folder.isRssAggregatorFolder() || folder.isRssSubscribeFolder()) {
            icon = ImageResources.FLD_RSS;
        } else if (folder.isCalendarFolder()) {
            icon = ImageResources.FOLDER_SUBCALENDAR;
        } else {
            ImageIcon imageIcon = icon = isOpenIcon ? ImageResources.FLD_FOLDER_OPEN : ImageResources.FLD_FOLDER;
        }
        if (icon instanceof ImageIcon) {
            ImageIcon imageIcon = icon;
            if (folder.isCalendarSubscribe()) {
                FolderCalSubscribe subscribeState = folder.getCalendarSubscribeState();
                if (subscribeState == FolderCalSubscribe.COMPLETE) {
                    return new DoubleImageIcon(imageIcon, ImageResources.FOLDER_CALENDAR_SUBSCRIBE);
                }
                if (subscribeState == FolderCalSubscribe.DORMANT) {
                    return new DoubleImageIcon(imageIcon, ImageResources.FOLDER_CALENDAR_SUBSCRIBE_UNSELECTED);
                }
                if (subscribeState == FolderCalSubscribe.ERROR) {
                    return new DoubleImageIcon(imageIcon, ImageResources.FOLDER_CALENDAR_SUBSCRIBE_ERROR);
                }
                if (subscribeState == FolderCalSubscribe.INPROGRESS) {
                    return new DoubleImageIcon(imageIcon, ImageResources.FOLDER_CALENDAR_SUBSCRIBE);
                }
            } else {
                if (folder.isPublishedCalendar()) {
                    if (folder.isSharedFolder()) {
                        return new DoubleImageIcon(imageIcon, ImageResources.FOLDER_CALENDAR_USER_PUBLISHED);
                    }
                    return new DoubleImageIcon(imageIcon, ImageResources.FOLDER_CALENDAR_PUBLISHED);
                }
                if (folder.isSharedFolder()) {
                    return new DoubleImageIcon(imageIcon, ImageResources.FOLDER_SHARED_TO_OVERLAY);
                }
                if (folder.isSharedFolderReference()) {
                    return new DoubleImageIcon(imageIcon, ImageResources.FOLDER_SHARED_FROM_OVERLAY);
                }
            }
        }
        return icon;
    }

    public static Icon getIconForMessage(IMessage message) {
        Icon icon = null;
        if (message.isRSSMessage()) {
            icon = ImageResources.FLD_RSS;
        } else if (message.isNNTPHeader()) {
            icon = ImageResources.ITM_NNTP_HEADER;
        } else if (message.isNNTPMessage()) {
            icon = ImageResources.ITM_NNTP_MESSAGE;
        } else if (message.isReplyRequested()) {
            icon = message.getPriority() == 4 ? ImageResources.ITM_REPLY_REQUESTED_HIGHT : (message.getPriority() == 1 ? ImageResources.ITM_REPLY_REQUESTED_LOW : ImageResources.ITM_REPLY_REQUESTED);
        } else if (message instanceof IMail) {
            icon = IconsFactory.getIconForMail((IMail)message);
        } else if (message instanceof INote) {
            icon = IconsFactory.getIconForNote((INote)message);
        } else if (message instanceof IDocumentReference) {
            icon = IconsFactory.getIconForDocument((IDocumentReference)message);
        }
        return icon;
    }

    private static Icon getIconForDocument(IDocumentReference documentReference) {
        ImageIcon icon = documentReference.getBoxType() != 2 && documentReference.isRead() || documentReference.getBoxType() == 2 && documentReference.getOpenTotals() > 0 ? ImageResources.ITM_DOCUMENT_READ : ImageResources.ITM_DOCUMENT_UNREAD;
        return icon;
    }

    public static Icon getExpandedIcon() {
        if (LookAndFeelManager.isGtkLookAndFeel()) {
            return ImageResources.GTK_EXPAND_ICON;
        }
        return (Icon)UIManager.get("Tree.expandedIcon");
    }

    public static Icon getCollapsedIcon() {
        if (LookAndFeelManager.isGtkLookAndFeel()) {
            return ImageResources.GTK_COLLAPSE_ICON;
        }
        return (Icon)UIManager.get("Tree.collapsedIcon");
    }

    public static Icon getAscendingSortIcon() {
        Icon icon = UIManager.getIcon("Table.ascendingSortIcon");
        if (icon == null) {
            icon = ImageResources.ASCENDING_SORT_ICON;
        }
        return icon;
    }

    public static Icon getDescendingSortIcon() {
        Icon icon = UIManager.getIcon("Table.descendingSortIcon");
        if (icon == null) {
            icon = ImageResources.DESCENDING_SORT_ICON;
        }
        return icon;
    }

    public static Icon getBlankSortIcon() {
        Icon icon = UIManager.getIcon("Table.naturalSortIcon");
        if (icon == null) {
            icon = BLANK_ICON;
        }
        return icon;
    }
}

