/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.level03;

import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.IColumnAndSortInfo;
import com.novell.gw.jclient.api.interfaces.IColumnFieldInfo;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.itemlisttable.TableColumnsUtils;
import com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTableHeader;
import com.novell.gw.jclient.application.controls.itemlisttable.level02.ItemListTable_Level02;
import com.novell.gw.jclient.application.controls.itemlisttable.level03.ItemListTableColumnModel_Level03;
import com.novell.gw.jclient.application.controls.itemlisttable.level03.ItemListTableModel_Level03;
import com.novell.gw.jclient.application.controls.itemlisttable.level03.SortableTableHeader;
import java.awt.Container;
import java.util.ArrayList;
import javax.swing.JViewport;
import org.apache.log4j.Logger;

public class ItemListTable_Level03
extends ItemListTable_Level02 {
    private static final Logger logger = Logger.getLogger(ItemListTable_Level03.class);

    public ItemListTable_Level03(IFolder folder, IViewDisplaySettings displaySettings, IItemList itemList) {
        super(folder, displaySettings, itemList);
    }

    protected ItemListTableHeader createDefaultTableHeader() {
        return new SortableTableHeader<ItemListTable_Level03>(this);
    }

    protected ItemListTableColumnModel_Level03 createDefaultColumnModel() {
        return new ItemListTableColumnModel_Level03<ItemListTable_Level03>(this);
    }

    protected ItemListTableModel_Level03 createDefaultDataModel(IFolder folder, IItemList itemList) {
        return new ItemListTableModel_Level03<ItemListTable_Level03>(this, folder, itemList);
    }

    protected ItemListTableModel_Level03 createDefaultDataModel() {
        return new ItemListTableModel_Level03<ItemListTable_Level03>(this);
    }

    public ItemListTableColumnModel_Level03 getColumnModel() {
        return (ItemListTableColumnModel_Level03)super.getColumnModel();
    }

    public ItemListTableModel_Level03 getModel() {
        return (ItemListTableModel_Level03)super.getModel();
    }

    public void sort(int columnIndex) {
        IColumnFieldInfo fieldInfo = this.getColumnModel().getColumnFieldInfoForColumn(columnIndex);
        if (fieldInfo != null) {
            IColumnFieldInfo sorteFieldInfo = this.getColumnModel().getSortedColumnFieldInfo();
            if (fieldInfo.isSorted() && sorteFieldInfo != null) {
                int oldSortOption = fieldInfo.getSortOption();
                this.sort(columnIndex, oldSortOption != 16);
            } else {
                this.sort(columnIndex, true);
            }
        }
    }

    public void saveSortOrder() {
        IColumnFieldInfo[] visibleFieldInfos = this.getColumnModel().getColumnsFieldInfos();
        IColumnFieldInfo sortedFieldInfo = null;
        for (IColumnFieldInfo fieldInfo : visibleFieldInfos) {
            if (!fieldInfo.isSorted()) continue;
            sortedFieldInfo = fieldInfo;
            break;
        }
        this.saveColumnAndSortFieldInfo(visibleFieldInfos, sortedFieldInfo);
    }

    private void saveColumnAndSortFieldInfo(IColumnFieldInfo[] fieldInfos, IColumnFieldInfo sortedFieldInfo) {
        IViewDisplaySettings viewDisplaySettings = this.getViewDisplaySettings();
        viewDisplaySettings.setColumnAndSortInfo(fieldInfos, sortedFieldInfo);
    }

    public void refreshColumnsPositions(IViewDisplaySettings displaySettings) {
        IColumnAndSortInfo columnAndSortInfo = displaySettings.getColumnAndSortInfo();
        this.getColumnModel().setColumnAndSortInfo(columnAndSortInfo);
        this.getColumnModel().refreshColumns();
        Container container = this.getParent();
        if (container instanceof JViewport) {
            container.validate();
        }
        this.validate();
    }

    public void refreshSortOrder(IViewDisplaySettings displaySettings) {
        IColumnFieldInfo sortedFieldInfo = displaySettings.getColumnAndSortInfo().getSortField();
        if (sortedFieldInfo != null) {
            int fieldID = TableColumnsUtils.getColumnFieldID(sortedFieldInfo, this.isContacts());
            this.getModel().sort(fieldID, sortedFieldInfo.getSortOption() == 16, false);
            this.repaint();
        }
    }

    public void saveColumnsPositions() {
        ItemListTableColumnModel_Level03 columnModel = this.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        ArrayList<IColumnFieldInfo> columnFieldInfos = new ArrayList<IColumnFieldInfo>();
        IColumnFieldInfo sortedFieldInfo = columnModel.getSortedColumnFieldInfo();
        for (int i = 0; i < columnCount; ++i) {
            IColumnFieldInfo fieldInfo = columnModel.getColumnFieldInfoForColumn(i);
            if (fieldInfo == null) continue;
            columnFieldInfos.add(APIWrapperManager.createColumnFieldInfo(fieldInfo.getName(), fieldInfo.getFieldID(), fieldInfo.getWidth(), fieldInfo.getSortOption()));
            if (!fieldInfo.isSorted()) continue;
            sortedFieldInfo = fieldInfo;
        }
        this.saveColumnAndSortFieldInfo(columnFieldInfos.toArray(new IColumnFieldInfo[columnFieldInfos.size()]), sortedFieldInfo);
    }

    public void sort(int column, boolean ascending) {
        this.sort(column, ascending, false);
    }

    public void refreshColumns() {
        this.refreshColumns(this.getViewDisplaySettings());
    }

    public void refreshColumns(IViewDisplaySettings displaySettings) {
        this.refreshColumnsPositions(displaySettings);
        this.refreshSortOrder(displaySettings);
    }

    public void sort(int columnIndex, boolean ascending, boolean isTasklist) {
        IColumnFieldInfo fieldInfo = this.getColumnModel().getColumnFieldInfoForColumn(columnIndex);
        if (fieldInfo != null) {
            for (IColumnFieldInfo tmpFieldInfo : this.getColumnModel().getColumnsFieldInfos()) {
                tmpFieldInfo.setSortOption(28);
            }
            fieldInfo.setSortOption(ascending ? 16 : 17);
            this.getColumnModel().setSortedColumnFieldInfo(fieldInfo);
            this.saveSortOrder();
            this.refreshSortOrder(this.getViewDisplaySettings());
        }
    }
}

