/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.level07;

import com.novell.gw.engine.ItemList;
import com.novell.gw.engine.ItemListEvent;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IItemListListener;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.itemlisttable.level07.EmptyTask;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.ListSelectionModel;
import org.apache.log4j.Logger;

public class TypingTaskItemListImpl
implements IItemList,
IItemListListener {
    private static final Logger logger = Logger.getLogger(TypingTaskItemListImpl.class);
    private final IItemList itemList;
    private IItem emptyTask;
    private int emptyTaskPosition = -1;
    private int threadDeapth = -1;
    private boolean hadTasklistDummyItem = false;
    private boolean deleteEmptyTaskWithNextRefresh = false;
    private final ListSelectionModel selectionModel;

    public TypingTaskItemListImpl(IItemList itemList, ListSelectionModel selectionModel) {
        this.itemList = itemList;
        this.selectionModel = selectionModel;
        this.addItemListListener(this);
    }

    public IItem getEmptyTask() {
        return this.emptyTask;
    }

    public boolean hasEmptyTask() {
        return this.emptyTask != null;
    }

    public void createEmptyTask(int position, int threadDeapth) {
        logger.debug((Object)("createEmptyTask(position: " + position + ", threadDeapth: " + threadDeapth + ")"));
        this.emptyTask = new EmptyTask();
        this.hadTasklistDummyItem = this.hasTasklistDummyItem();
        this.emptyTaskPosition = position;
        this.threadDeapth = threadDeapth;
        this.deleteEmptyTaskWithNextRefresh = false;
    }

    public void deleteEmptyTask() {
        this.emptyTask = null;
        this.emptyTaskPosition = -1;
        this.threadDeapth = -1;
        this.hadTasklistDummyItem = false;
    }

    public void deleteEmptyTaskWithNextRefresh() {
        this.deleteEmptyTaskWithNextRefresh = true;
    }

    private int getCorrectIndex(int index) {
        if (this.emptyTask != null && index > this.emptyTaskPosition && !this.hadTasklistDummyItem) {
            --index;
        }
        return index;
    }

    private boolean hasTasklistDummyItem() {
        int index = this.itemList.findLastUncompletedChecklistItemIndex();
        if (index >= 0) {
            IItem item = this.itemList.getItemAt(index);
            return item instanceof IMessage && ((IMessage)item).isChecklistDummyItem();
        }
        return false;
    }

    public ItemList getNativeItemList() {
        return this.itemList.getNativeItemList();
    }

    public void addItemListListener(IItemListListener l) {
        this.itemList.addItemListListener(l);
    }

    public void removeItemListListener(IItemListListener l) {
        this.itemList.removeItemListListener(l);
    }

    public void sort(int sortField, boolean ascending) {
        this.deleteEmptyTaskWithNextRefresh();
        this.itemList.sort(sortField, ascending);
    }

    public void sort(int sortField, boolean ascending, boolean sortTasklist) {
        this.deleteEmptyTaskWithNextRefresh();
        this.itemList.sort(sortField, ascending, sortTasklist);
    }

    public int getSortField() {
        return this.itemList.getSortField();
    }

    public boolean isSortAscending() {
        return this.itemList.isSortAscending();
    }

    public int getDisplayItemCount() {
        return this.itemList.getDisplayItemCount();
    }

    public int getSize() {
        int size = this.itemList.getSize();
        if (this.emptyTask != null && !this.hadTasklistDummyItem) {
            ++size;
        }
        return size;
    }

    public int getFirstUnreadItemIndex(boolean isQuickViewerOn) {
        return this.itemList.getFirstUnreadItemIndex(isQuickViewerOn);
    }

    public IItem getItemAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return this.emptyTask;
        }
        return this.itemList.getItemAt(this.getCorrectIndex(index));
    }

    public TransferItems getTransferItems(int[] indices) {
        return this.itemList.getTransferItems(indices);
    }

    public boolean setSelection(IItem[] items) {
        return this.itemList.setSelection(items);
    }

    public int getThreadDepth(IItem item) {
        if (this.emptyTask != null && item.equals(this.emptyTask)) {
            return this.threadDeapth;
        }
        return this.itemList.getThreadDepth(item);
    }

    public int getThreadDepthAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return this.threadDeapth;
        }
        return this.itemList.getThreadDepthAt(this.getCorrectIndex(index));
    }

    public boolean hasChildren(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.hasChildren(item);
    }

    public boolean hasChildrenAt(int index) {
        return (this.emptyTask == null || index != this.emptyTaskPosition) && this.itemList.hasChildrenAt(this.getCorrectIndex(index));
    }

    public boolean hasUnreadItemInThread(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.hasUnreadItemInThread(item);
    }

    public boolean hasUnreadItemInThreadAt(int index) {
        return (this.emptyTask == null || index != this.emptyTaskPosition) && this.itemList.hasUnreadItemInThreadAt(this.getCorrectIndex(index));
    }

    public boolean hasTaskListItemsOnly() {
        return this.itemList.hasTaskListItemsOnly();
    }

    public boolean isCollapsed(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.isCollapsed(item);
    }

    public boolean isCollapsedAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.isCollapsedAt(index);
    }

    public boolean isCollapsedAutoDateItem(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.isCollapsedAutoDateItem(item);
    }

    public boolean isCollapsedAutoDateItemAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.isCollapsedAutoDateItemAt(index);
    }

    public boolean isRecurringEntry(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.isRecurringEntry(item);
    }

    public boolean isRecurringEntryAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.isRecurringEntryAt(index);
    }

    public boolean isRecurringEntryRoot(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.isRecurringEntryRoot(item);
    }

    public boolean isRecurringEntryRootAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.isRecurringEntryRootAt(index);
    }

    public boolean isRootMost(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.isRootMost(item);
    }

    public boolean isRootMostAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.isRootMostAt(index);
    }

    public void expand(IItem item) {
        this.itemList.expand(item);
    }

    public void expandAt(int index) {
        this.itemList.expandAt(index);
    }

    public void collapse(IItem item) {
        this.itemList.collapse(item);
    }

    public void collapseAt(int index) {
        this.itemList.collapseAt(index);
    }

    public void expandAll() {
        this.itemList.expandAll();
    }

    public void collapseAll() {
        this.itemList.collapseAll();
    }

    public boolean isThreadIgnored() {
        return this.itemList.isThreadIgnored();
    }

    public boolean isThreadIgnored(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.isThreadIgnored(item);
    }

    public boolean isThreadIgnored(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.isThreadIgnored(index);
    }

    public boolean isThreadWatched() {
        return this.itemList.isThreadWatched();
    }

    public boolean isThreadWatched(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.isThreadWatched(item);
    }

    public boolean isThreadWatched(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.isThreadWatched(index);
    }

    public boolean canMarkThreadIgnore() {
        return this.itemList.canMarkThreadIgnore();
    }

    public boolean canMarkThreadRead() {
        return this.itemList.canMarkThreadRead();
    }

    public boolean canMarkThreadWatch() {
        return this.itemList.canMarkThreadWatch();
    }

    public void markThreadIgnore() {
        this.itemList.markThreadIgnore();
    }

    public void markThreadRead() {
        this.itemList.markThreadRead();
    }

    public void markThreadWatch() {
        this.itemList.markThreadWatch();
    }

    public boolean canDeleteSelectedItems() {
        return this.itemList.canDeleteSelectedItems();
    }

    public boolean canDeleteItem(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.canDeleteItem(item);
    }

    public boolean canDeleteItemAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.canDeleteItemAt(index);
    }

    public boolean deleteItem(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.deleteItem(item);
    }

    public boolean deleteSelectedItems() {
        return this.itemList.deleteSelectedItems();
    }

    public boolean deleteItemAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.deleteItemAt(index);
    }

    public boolean canDeleteAndEmptyItem(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.canDeleteAndEmptyItem(item);
    }

    public boolean canDeleteAndEmptySelectedItems() {
        return this.itemList.canDeleteAndEmptySelectedItems();
    }

    public boolean canDeleteAndEmptyItemAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.canDeleteAndEmptyItemAt(index);
    }

    public boolean deleteAndEmptyItem(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.deleteAndEmptyItem(item);
    }

    public boolean deleteAndEmptySelectedItems() {
        return this.itemList.deleteAndEmptySelectedItems();
    }

    public boolean deleteAndEmptyItemAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.deleteAndEmptyItemAt(index);
    }

    public boolean canUndeleteItem(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.canUndeleteItem(item);
    }

    public boolean canUndeleteSelectedItems() {
        return this.itemList.canUndeleteSelectedItems();
    }

    public boolean canUndeleteItemAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.canUndeleteItemAt(index);
    }

    public boolean undeleteItem(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.undeleteItem(item);
    }

    public boolean undeleteSelectedItems() {
        return this.itemList.undeleteSelectedItems();
    }

    public boolean undeleteItemAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.undeleteItemAt(index);
    }

    public boolean canMarkItemPrivate(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.canMarkItemPrivate(item);
    }

    public boolean canMarkSelectedItemsPrivate() {
        return this.itemList.canMarkSelectedItemsPrivate();
    }

    public boolean canMarkItemPrivateAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.canMarkItemPrivateAt(index);
    }

    public void markAllItemsRead() {
        this.itemList.markAllItemsRead();
    }

    public boolean markItemPrivate(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.markItemPrivate(item);
    }

    public boolean markSelectedItemsPrivate() {
        return this.itemList.markSelectedItemsPrivate();
    }

    public boolean markItemPrivateAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.markItemPrivateAt(index);
    }

    public boolean canMarkItemRead(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.canMarkItemRead(item);
    }

    public boolean canMarkSelectedItemsRead() {
        return this.itemList.canMarkSelectedItemsRead();
    }

    public boolean canMarkItemReadAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.canMarkItemReadAt(index);
    }

    public boolean markItemRead(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.markItemRead(item);
    }

    public boolean markSelectedItemsRead() {
        return this.itemList.markSelectedItemsRead();
    }

    public boolean markItemReadAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.markItemReadAt(index);
    }

    public boolean canPurgeItem(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.canPurgeItem(item);
    }

    public boolean canPurgeSelectedItems() {
        return this.itemList.canPurgeSelectedItems();
    }

    public boolean canPurgeItemAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.canPurgeItemAt(index);
    }

    public boolean purgeItem(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.purgeItem(item);
    }

    public boolean purgeSelectedItems() {
        return this.itemList.purgeSelectedItems();
    }

    public boolean purgeItemAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.purgeItemAt(index);
    }

    public boolean canRestoreItem(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.canRestoreItem(item);
    }

    public boolean canRestoreSelectedItems() {
        return this.itemList.canRestoreSelectedItems();
    }

    public boolean canRestoreItemAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.canRestoreItemAt(index);
    }

    public boolean restoreItem(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.restoreItem(item);
    }

    public boolean restoreSelectedItems() {
        return this.itemList.restoreSelectedItems();
    }

    public boolean restoreItemAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.restoreItemAt(index);
    }

    public boolean canMarkItemReadLater(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.canMarkItemReadLater(item);
    }

    public boolean canMarkSelectedItemsReadLater() {
        return this.itemList.canMarkSelectedItemsReadLater();
    }

    public boolean canMarkItemReadLaterAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.canMarkItemReadLaterAt(index);
    }

    public boolean markItemReadLater(IItem item) {
        return (this.emptyTask == null || !item.equals(this.emptyTask)) && this.itemList.markItemReadLater(item);
    }

    public boolean markSelectedItemsReadLater() {
        return this.itemList.markSelectedItemsReadLater();
    }

    public boolean markItemReadLaterAt(int index) {
        if (this.emptyTask != null && index == this.emptyTaskPosition) {
            return false;
        }
        index = this.getCorrectIndex(index);
        return this.itemList.markItemReadLaterAt(index);
    }

    public boolean canShowSelectionInChecklist() {
        return this.itemList.canShowSelectionInChecklist();
    }

    public boolean isSelectionInChecklist() {
        return this.itemList.isSelectionInChecklist();
    }

    public boolean showSelectionInChecklist(boolean bShow) {
        return this.itemList.showSelectionInChecklist(bShow);
    }

    public boolean moveSelectionToChecklist() {
        return this.itemList.moveSelectionToChecklist();
    }

    public boolean canMoveSelectionToChecklist() {
        return this.itemList.canMoveSelectionToChecklist();
    }

    public int findLastUncompletedChecklistItemIndex() {
        return this.itemList.findLastUncompletedChecklistItemIndex();
    }

    public Enumeration getEnumeration() {
        return this.itemList.getEnumeration();
    }

    public void queryStop() {
        this.itemList.queryStop();
    }

    public int indexOf(IItem item) {
        if (this.emptyTask != null && item.equals(this.emptyTask)) {
            return this.emptyTaskPosition;
        }
        if (item instanceof EmptyTask) {
            return -1;
        }
        return this.itemList.indexOf(item);
    }

    public int indexOf(String searchKey) {
        return this.itemList.indexOf(searchKey);
    }

    public int indexOf(String searchKey, int fromIndex) {
        return this.itemList.indexOf(searchKey, fromIndex);
    }

    public boolean canChecklistMoveDown(int iIndex) {
        if (this.emptyTask != null && iIndex == this.emptyTaskPosition) {
            return false;
        }
        iIndex = this.getCorrectIndex(iIndex);
        return this.itemList.canChecklistMoveDown(iIndex);
    }

    public boolean checklistMoveDown(int iIndex) {
        if (this.emptyTask != null && iIndex == this.emptyTaskPosition) {
            return false;
        }
        iIndex = this.getCorrectIndex(iIndex);
        return this.itemList.checklistMoveDown(iIndex);
    }

    public boolean canChecklistMoveUp(int iIndex) {
        if (this.emptyTask != null && iIndex == this.emptyTaskPosition) {
            return false;
        }
        iIndex = this.getCorrectIndex(iIndex);
        return this.itemList.canChecklistMoveUp(iIndex);
    }

    public boolean checklistMoveUp(int iIndex) {
        if (this.emptyTask != null && iIndex == this.emptyTaskPosition) {
            return false;
        }
        iIndex = this.getCorrectIndex(iIndex);
        return this.itemList.checklistMoveUp(iIndex);
    }

    public boolean canChecklistMoveToBottom(int iIndex) {
        if (this.emptyTask != null && iIndex == this.emptyTaskPosition) {
            return false;
        }
        iIndex = this.getCorrectIndex(iIndex);
        return this.itemList.canChecklistMoveToBottom(iIndex);
    }

    public boolean checklistMoveToBottom(int iIndex) {
        if (this.emptyTask != null && iIndex == this.emptyTaskPosition) {
            return false;
        }
        iIndex = this.getCorrectIndex(iIndex);
        return this.itemList.checklistMoveToBottom(iIndex);
    }

    public boolean canChecklistMoveToTop(int iIndex) {
        if (this.emptyTask != null && iIndex == this.emptyTaskPosition) {
            return false;
        }
        iIndex = this.getCorrectIndex(iIndex);
        return this.itemList.canChecklistMoveToTop(iIndex);
    }

    public boolean checklistMoveToTop(int iIndex) {
        if (this.emptyTask != null && iIndex == this.emptyTaskPosition) {
            return false;
        }
        iIndex = this.getCorrectIndex(iIndex);
        return this.itemList.checklistMoveToTop(iIndex);
    }

    public boolean checklistMoveTo(int iIndex, int iToIndex) {
        if (this.emptyTask != null && iIndex == this.emptyTaskPosition) {
            return false;
        }
        iIndex = this.getCorrectIndex(iIndex);
        return this.itemList.checklistMoveTo(iIndex, iToIndex);
    }

    public boolean checklistMoveTo(int iIndex, int iToIndex, boolean bMoveRecurringSubItems) {
        if (this.emptyTask != null && iIndex == this.emptyTaskPosition) {
            return false;
        }
        iIndex = this.getCorrectIndex(iIndex);
        return this.itemList.checklistMoveTo(iIndex, iToIndex, bMoveRecurringSubItems);
    }

    public boolean transferToTasklist(TransferItems transferItems, int itemIndex, boolean shouldMoveBelow, boolean moveInto) {
        return this.itemList.transferToTasklist(transferItems, itemIndex, shouldMoveBelow, moveInto);
    }

    public int handleJunkMailSelectedItems(int listType) {
        return this.itemList.handleJunkMailSelectedItems(listType);
    }

    public boolean canHandleJunkMailSelectedItems(int listType) {
        return this.itemList.canHandleJunkMailSelectedItems(listType);
    }

    public int canHandleJunkMailSelectedItems() {
        return this.itemList.canHandleJunkMailSelectedItems();
    }

    public IItem[] getCalendarItems(Date date) {
        return this.itemList.getCalendarItems(date);
    }

    public IItem[] getCalendarItems(Date startDate, Date endDate) {
        return this.itemList.getCalendarItems(startDate, endDate);
    }

    public IItem[] getCalendarItems(Date date, ItemType itemType) {
        return this.itemList.getCalendarItems(date, itemType);
    }

    public IItem[] getCalendarItems(Date startDate, Date endDate, ItemType itemType) {
        return this.itemList.getCalendarItems(startDate, endDate, itemType);
    }

    public IItem[] getAllDayEvents(Date date) {
        return this.itemList.getAllDayEvents(date);
    }

    public IItem[] getAllDayEvents(Date startDate, Date endDate) {
        return this.itemList.getAllDayEvents(startDate, endDate);
    }

    public IItem[] getAppointments(Date date) {
        return this.itemList.getAppointments(date);
    }

    public IItem[] getAppointments(Date startDate, Date endDate) {
        return this.itemList.getAppointments(startDate, endDate);
    }

    public IItem[] getNotes(Date date) {
        return this.itemList.getNotes(date);
    }

    public IItem[] getNotes(Date startDate, Date endDate) {
        return this.itemList.getNotes(startDate, endDate);
    }

    public IItem[] getTasks(Date date) {
        return this.itemList.getTasks(date);
    }

    public IItem[] getTasks(Date startDate, Date endDate) {
        return this.itemList.getTasks(startDate, endDate);
    }

    public int getMonthBusyDays(ItemListFilter filter, int year, int month) {
        return this.itemList.getMonthBusyDays(filter, year, month);
    }

    public boolean canSetCategoriesOnSelection() {
        return this.itemList.canSetCategoriesOnSelection();
    }

    public void setCategories(ICategoryList categoryList, IItem[] items) {
        this.itemList.setCategories(categoryList, items);
    }

    public boolean setFilter(ItemListFilter filter) {
        this.deleteEmptyTaskWithNextRefresh();
        return this.itemList.setFilter(filter);
    }

    public void dispose() {
        this.itemList.dispose();
    }

    public void contentsChanged(ItemListEvent e) {
        if (this.deleteEmptyTaskWithNextRefresh) {
            int index = this.emptyTaskPosition;
            this.deleteEmptyTask();
            this.selectionModel.setSelectionInterval(index, index);
        }
        this.deleteEmptyTaskWithNextRefresh = false;
    }

    public boolean canCreateChecklistItem() {
        return this.itemList.canCreateChecklistItem();
    }

    public boolean canCreateChecklistSubItemAt(int index) {
        return this.itemList.canCreateChecklistSubItemAt(index);
    }

    public boolean canCreateChecklistSubItemAtSelection() {
        return this.itemList.canCreateChecklistSubItemAtSelection();
    }

    public boolean createChecklistItem(String newMessageText, int newItemIndex, int newItemParentIndex, ItemListFilter filter) {
        this.deleteEmptyTaskWithNextRefresh();
        return this.itemList.createChecklistItem(newMessageText, newItemIndex, newItemParentIndex, filter);
    }

    public boolean createChecklistItem(String newMessageText, int newItemIndex) {
        this.deleteEmptyTaskWithNextRefresh();
        return this.itemList.createChecklistItem(newMessageText, newItemIndex);
    }

    public boolean createChecklistSubItem(String newMessageText, int newItemIndex, int newItemParentIndex) {
        this.deleteEmptyTaskWithNextRefresh();
        return this.itemList.createChecklistSubItem(newMessageText, newItemIndex, newItemParentIndex);
    }

    public boolean checklistMoveRight(int iIndex) {
        if (this.emptyTask != null && iIndex == this.emptyTaskPosition) {
            return false;
        }
        iIndex = this.getCorrectIndex(iIndex);
        return this.itemList.checklistMoveRight(iIndex);
    }

    public boolean canChecklistMoveRight(int iIndex) {
        if (this.emptyTask != null && iIndex == this.emptyTaskPosition) {
            return false;
        }
        iIndex = this.getCorrectIndex(iIndex);
        return this.itemList.canChecklistMoveRight(iIndex);
    }

    public boolean checklistMoveLeft(int iIndex) {
        if (this.emptyTask != null && iIndex == this.emptyTaskPosition) {
            return false;
        }
        iIndex = this.getCorrectIndex(iIndex);
        return this.itemList.checklistMoveLeft(iIndex);
    }

    public boolean canChecklistMoveLeft(int iIndex) {
        if (this.emptyTask != null && iIndex == this.emptyTaskPosition) {
            return false;
        }
        iIndex = this.getCorrectIndex(iIndex);
        return this.itemList.canChecklistMoveLeft(iIndex);
    }

    public void moreResultsAvailable(ItemListEvent e) {
    }

    public void notifyEmptyList(ItemListEvent e) {
    }

    public void queryResultsDone(ItemListEvent e) {
    }
}

