/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.level09;

import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.itemlisttable.TableColumnType;
import com.novell.gw.jclient.application.controls.itemlisttable.level08.ItemListTable_Level08;
import com.novell.gw.jclient.application.controls.itemlisttable.level09.ItemListTableColumnModel_Level09;
import com.novell.gw.jclient.application.controls.itemlisttable.level09.ItemListTableModel_Level09;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.collapsable.Collapsable;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class ItemListTable_Level09
extends ItemListTable_Level08 {
    private static final Logger logger = Logger.getLogger(ItemListTable_Level09.class);

    public ItemListTable_Level09(IFolder folder, IViewDisplaySettings viewDisplaySettings, IItemList itemList) {
        super(folder, viewDisplaySettings, itemList);
    }

    public boolean isCollapsed() {
        return false;
    }

    public boolean isConversationView() {
        IViewDisplaySettings viewDisplaySettings = this.getViewDisplaySettings();
        return viewDisplaySettings != null && viewDisplaySettings.getViewMode() == 5;
    }

    public boolean isRecurringItem(int row) {
        if (row >= 0 && row < this.getRowCount()) {
            IItemList itemList = this.getItemList();
            return itemList.isRecurringEntryAt(row);
        }
        return false;
    }

    public boolean isCellEditable(int row, int column) {
        TableColumnType columnType = this.getColumnModel().getColumn(column).getColumnType();
        return columnType == TableColumnType.COLUMN_THREAD_CONTROL || super.isCellEditable(row, column);
    }

    public int getThreadShift(int row) {
        IItem item;
        IItemList itemList = this.getItemList();
        if (row >= 0 && row < this.getRowCount() && (item = itemList.getItemAt(row)) instanceof IMessage && (this.isConversationView() || this.isRecurringItem(row) || this.isTasklistView() && ((IMessage)item).isInChecklist())) {
            int depth = itemList.getThreadDepth(item) - 1;
            IViewDisplaySettings viewDisplaySettings = this.getViewDisplaySettings();
            if (viewDisplaySettings.showGroupHeaders() && !this.isConversationView() && !((IMessage)item).isInChecklist()) {
                --depth;
            }
            if (depth > 0) {
                return 8 * depth;
            }
        }
        return 0;
    }

    public int columnAtPoint(Point point) {
        int row = this.rowAtPoint(point);
        if (row >= 0 && row < this.getRowCount()) {
            int shift = this.getThreadShift(row);
            int column = super.columnAtPoint(point);
            if (column <= this.getFirstShiftedColumn()) {
                return column;
            }
            point.x = this.getComponentOrientation().isLeftToRight() ? (point.x -= shift) : (point.x += shift);
        }
        return super.columnAtPoint(point);
    }

    public int columnAtPointNotRelatedToRow(Point point) {
        return super.columnAtPoint(point);
    }

    private int getFirstShiftedColumn() {
        if (this.isTasklistView()) {
            return 1;
        }
        return 0;
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle rect = super.getCellRect(row, column, includeSpacing);
        if (column >= 0 && column < this.getColumnCount()) {
            int shift = this.getThreadShift(row);
            int firstShiftedColumn = this.getFirstShiftedColumn();
            if (this.getComponentOrientation().isLeftToRight()) {
                if (column == firstShiftedColumn) {
                    rect.width += shift;
                } else if (column > firstShiftedColumn) {
                    rect.x += shift;
                }
            } else if (column >= firstShiftedColumn) {
                if (column == firstShiftedColumn) {
                    rect.width += shift;
                }
                rect.x -= shift;
            }
        }
        return rect;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        Object value = this.getModel().getValueAt(row, column);
        TableColumnType columnType = this.getColumnModel().getColumn(column).getColumnType();
        if (columnType == TableColumnType.COLUMN_THREAD_CONTROL && value instanceof Collapsable) {
            return COLLAPSABLE_CELL;
        }
        return super.getCellEditor(row, column);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        Object value = this.getModel().getValueAt(row, column);
        TableColumnType columnType = this.getColumnModel().getColumn(column).getColumnType();
        if (columnType == TableColumnType.COLUMN_THREAD_CONTROL && value instanceof Collapsable) {
            return COLLAPSABLE_CELL;
        }
        return super.getCellRenderer(row, column);
    }

    protected ItemListTableColumnModel_Level09 createDefaultColumnModel() {
        return new ItemListTableColumnModel_Level09<ItemListTable_Level09>(this);
    }

    public ItemListTableColumnModel_Level09 getColumnModel() {
        return (ItemListTableColumnModel_Level09)super.getColumnModel();
    }

    protected ItemListTableModel_Level09 createDefaultDataModel() {
        return new ItemListTableModel_Level09<ItemListTable_Level09>(this);
    }

    protected ItemListTableModel_Level09 createDefaultDataModel(IFolder folder, IItemList itemList) {
        return new ItemListTableModel_Level09<ItemListTable_Level09>(this, folder, itemList);
    }

    public ItemListTableModel_Level09 getModel() {
        return (ItemListTableModel_Level09)super.getModel();
    }

    public void setModel(TableModel dataModel) {
        if (!(dataModel instanceof ItemListTableModel_Level09)) {
            throw new IllegalArgumentException();
        }
        super.setModel(dataModel);
    }
}

