/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.renderers;

import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.itemlisttable.IconsFactory;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.TableRendererUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class AdditionalItemIconsRenderer
extends OrientablePanel
implements TableCellRenderer {
    private static final int ICONS_MAX = 4;
    private JLabel[] labels = new OrientableLabel[4];

    public AdditionalItemIconsRenderer() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 23;
        for (int i = 0; i < this.labels.length; ++i) {
            if (i == this.labels.length - 1) {
                constraints.weightx = 1.0;
            }
            OrientableLabel label = new OrientableLabel();
            label.setVerticalAlignment(1);
            label.setOpaque(false);
            label.setHorizontalAlignment(2);
            this.labels[i] = label;
            this.add((Component)label, constraints);
            ++constraints.gridx;
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int i;
        Icon[] icons;
        for (JLabel label : this.labels) {
            label.setIcon(null);
        }
        if (value instanceof IMessage) {
            icons = IconsFactory.getAdditionalMessageIcons((IMessage)value);
            for (i = 0; i < icons.length; ++i) {
                if (i >= this.labels.length) continue;
                this.labels[i].setIcon(icons[i]);
            }
        } else if (value instanceof IFolder) {
            icons = IconsFactory.getAdditionalFolderIcons((IFolder)value);
            for (i = 0; i < icons.length; ++i) {
                this.labels[i].setIcon(icons[i]);
            }
        }
        this.setBackground(TableRendererUtils.getCellColor((IItem)value, false, false, false, row, table));
        return this;
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    public void repaint() {
    }
}

