/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.renderers;

import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTable_Level01;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.TableRendererUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class SummaryItemCellRenderer
extends OrientablePanel
implements TableCellRenderer {
    private JLabel lblFirst = new OrientableLabel();
    private JLabel lblSecond = new OrientableLabel();

    public SummaryItemCellRenderer() {
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 23;
        this.add((Component)this.lblFirst, constraints);
        ++constraints.gridy;
        this.add((Component)this.lblSecond, constraints);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        IItem item = (IItem)value;
        Color background = TableRendererUtils.getCellColor(item, isSelected, true, false, row, table);
        Color foreground = TableRendererUtils.getCellColor(item, isSelected, true, true, row, table);
        ItemListTable_Level01 itemListTable = (ItemListTable_Level01)table;
        this.lblFirst.setText(TableRendererUtils.getSummaryValue(item, 0, itemListTable.getFolder(), itemListTable.getViewDisplaySettings()));
        this.lblSecond.setText(TableRendererUtils.getSummaryValue(item, 1, itemListTable.getFolder(), itemListTable.getViewDisplaySettings()));
        TableRendererUtils.applyFontAndRenderingHints(this.lblFirst, table, item);
        TableRendererUtils.applyFontAndRenderingHints(this.lblSecond, table, item);
        this.setBorder(TableRendererUtils.getBorder(table, isSelected, true));
        this.setBackground(background);
        this.lblFirst.setForeground(foreground);
        if (isSelected) {
            this.lblSecond.setForeground(foreground);
        } else {
            this.lblSecond.setForeground(Color.GRAY);
        }
        return this;
    }
}

