/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.renderers;

import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextCellEditor
extends DefaultCellEditor {
    private static JTextField textField = new OrientableTextField();

    public TextCellEditor() {
        super(textField);
        textField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!(e.isActionKey() || e.isAltDown() || e.isControlDown() || e.isShiftDown())) {
                    int keyCode = e.getKeyCode();
                    try {
                        if (keyCode == 10) {
                            TextCellEditor.this.fireEditingStopped();
                        } else if (keyCode == 27) {
                            TextCellEditor.this.fireEditingCanceled();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public Object getCellEditorValue() {
        return textField.getText();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return super.getTableCellEditorComponent(table, "", isSelected, row, column);
    }

    static {
        textField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        textField.getDocument().addDocumentListener(new DocumentListener(){

            private void requestFocus() {
                if (!textField.isFocusOwner()) {
                    textField.requestFocusInWindow();
                }
            }

            public void insertUpdate(DocumentEvent e) {
                this.requestFocus();
            }

            public void removeUpdate(DocumentEvent e) {
                this.requestFocus();
            }

            public void changedUpdate(DocumentEvent e) {
                this.requestFocus();
            }
        });
        if (OS.isMacOS()) {
            textField.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    int index = textField.getText().length();
                    textField.select(index, index);
                    textField.setCaretPosition(index);
                }
            });
        }
    }
}

