/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlistview;

import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;

public class ItemListViewCoolModel {
    private IFolder folder;
    private IViewDisplaySettings viewDisplaySettings;
    private ItemListFilter filter;
    private IItemList itemList;

    public ItemListViewCoolModel(IFolder folder, IViewDisplaySettings viewDisplaySettings, ItemListFilter filter) {
        this.setData(folder, viewDisplaySettings, filter);
    }

    public void setData(IFolder folder, IViewDisplaySettings viewDisplaySettings, ItemListFilter filter) {
        this.folder = folder;
        this.viewDisplaySettings = viewDisplaySettings;
        this.filter = filter;
        this.itemList = null;
    }

    public IItemList getItemList() {
        if (this.itemList == null) {
            this.initItemList();
        }
        return this.itemList;
    }

    private void initItemList() {
        this.itemList = this.getFolder().getContents(this.getFilter(), this.getViewDisplaySettings());
    }

    public void clear() {
        this.itemList = null;
    }

    public IFolder getFolder() {
        return this.folder;
    }

    public ItemListFilter getFilter() {
        return this.filter;
    }

    public IViewDisplaySettings getViewDisplaySettings() {
        return this.viewDisplaySettings;
    }

    public void setViewDisplaySettings(IViewDisplaySettings viewDisplaySettings) {
        this.viewDisplaySettings = viewDisplaySettings;
    }

    public void setFilter(ItemListFilter filter) {
        this.filter = filter;
        if (this.itemList != null) {
            this.itemList.setFilter(filter);
        }
    }
}

