/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlistview;

import com.appframework.ApplicationFrame;
import com.appframework.event.DeadObjectMethodAccessException;
import com.appframework.event.ICanDie;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.engine.ItemListEvent;
import com.novell.gw.jclient.api.enums.FolderType;
import com.novell.gw.jclient.api.interfaces.IFolderDisplaySettings;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.commands.AttributeKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.ItemListComponentDataModelImpl;
import com.novell.gw.jclient.application.controls.filter.FilterFeedbackDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarScrollPane;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendar;
import com.novell.gw.jclient.application.controls.itemlisttable.lastlevel.ItemListTable;
import com.novell.gw.jclient.application.controls.itemlistview.IItemListViewModelListener;
import com.novell.gw.jclient.application.controls.itemlistview.ILVPFocusListener;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListComponent;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListSelectionListener;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListView;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListViewModel;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListViewPanelController;
import com.novell.gw.jclient.application.controls.itemlistview.ItemSelectionChangedEvent;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.impl.SelectedContactsInfoImpl;
import com.novell.gw.jclient.application.impl.SelectedItemsInfoImpl;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.filter.Filter;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemListViewPanel
extends OrientablePanel
implements ItemListView,
MVCView<ItemListViewPanelController, ItemListViewModel>,
ItemListSelectionListener,
ICanDie {
    private static final Logger logger = Logger.getLogger(ItemListViewPanel.class);
    private ItemListViewPanelController controller;
    private ItemListViewModel model;
    private ModelListener modelListener = new ModelListener();
    private ItemListComponent itemListComponent;
    private Thread buildThread;
    private GWCalendar calendar;
    private ItemListTable newItemListTable;
    private boolean activated = true;
    private boolean building = false;
    private boolean dead = false;
    private int selectedItemCount = 0;
    private JPanel pnlLoading;

    public ItemListViewPanel(AbstractFolder folder, IViewDisplaySettings viewDisplaySettings, Filter filter, MVCController parentController) {
        this(folder, folder, viewDisplaySettings, filter, parentController);
    }

    public ItemListViewPanel(AbstractFolder folder, AbstractFolder parentFolder, IViewDisplaySettings viewDisplaySettings, Filter filter, MVCController parentController) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.setController(this.createController(parentController));
        this.setMVCModel(new ItemListViewModel(folder, parentFolder, viewDisplaySettings, filter));
    }

    protected ItemListViewPanelController createController(MVCController parentController) {
        return new ItemListViewPanelController(this, parentController);
    }

    public ItemListViewPanel(MVCController controller) {
        this(null, null, null, controller);
    }

    @Override
    public IFolder getFolder() {
        return this.getMVCModel().getFolder();
    }

    @Override
    public IFolder getParentFolder() {
        return this.model.getParentFolder();
    }

    @Override
    public AbstractFolder getAbstractFolder() {
        return this.model.getAbstractFolder();
    }

    @Override
    public IViewDisplaySettings getViewDisplaySettings() {
        return this.model.getViewDisplaySettings();
    }

    @Override
    public void setViewDisplaySettings(IViewDisplaySettings viewDisplaySettings) {
        if (this.isDead()) {
            throw new DeadObjectMethodAccessException();
        }
        this.getMVCModel().setViewDisplaySettings(viewDisplaySettings);
    }

    @Override
    public void setActivated(boolean activated) {
        if (this.isDead()) {
            throw new DeadObjectMethodAccessException();
        }
        if (this.activated != activated) {
            this.activated = activated;
        }
    }

    public int getSelectedItemCount() {
        return this.selectedItemCount;
    }

    private void attachListeners(boolean attach) {
        this.selectedItemCount = 0;
        if (this.itemListComponent == null) {
            return;
        }
        if (attach) {
            this.itemListComponent.addItemListSelectionListener(this);
        } else {
            this.itemListComponent.removeItemListSelectionListener(this);
        }
    }

    public void interrupt() {
        if (this.buildThread != null && this.buildThread.isAlive()) {
            this.buildThread.interrupt();
        }
        this.setBuilding(false);
    }

    public synchronized boolean isBuilding() {
        return this.building;
    }

    public synchronized void setBuilding(boolean building) {
        this.building = building;
    }

    protected synchronized void initItemListComponent() {
        JComponent content;
        logger.debug((Object)"start building item list component...");
        this.itemListComponent = null;
        IViewDisplaySettings displaySettings = this.getViewDisplaySettings();
        int viewMode = displaySettings.getViewMode();
        if (viewMode == 1 || viewMode == 7 || viewMode == 5) {
            content = this.getNewItemListTable();
        } else if (viewMode == 6) {
            content = this.getCalendar();
            ((GWCalendar)content).activate(true);
        } else {
            assert (false) : "unexpected view";
            content = null;
            this.removeAll();
            this.add(new OrientableLabel("OOPS", 0));
            this.revalidate();
        }
        if (!(content instanceof ItemListTable)) {
            content.setData(this.getAbstractFolder(), this.getViewDisplaySettings(), this.getItemList());
        }
        this.itemListComponent = content;
        this.attachListeners(true);
        logger.debug((Object)"... item list component built (and should be shown soon)");
        this.getController().processCommand(new Command(2070, this));
        this.showItemListComponent();
    }

    protected void showItemListComponent() {
        OrientableScrollPane scrollPane = this.itemListComponent instanceof GWCalendar ? new CalendarScrollPane(this.itemListComponent.getComponent()) : new OrientableScrollPane(this.itemListComponent.getComponent());
        this.removeAll();
        this.add((Component)scrollPane, "Center");
        this.validateTree();
        if (!this.getComponentOrientation().isLeftToRight() && this.itemListComponent instanceof ItemListTable) {
            scrollPane.getViewport().setViewSize(scrollPane.getSize());
        }
        if (this.itemListComponent instanceof ItemListTable && ((ItemListTable)this.itemListComponent).getSelectedRow() == -1) {
            IFolder parentFolder = this.getParentFolder();
            if (this.getParentFolder().getSelectFirstUnreadItemState()) {
                IFolderDisplaySettings folderDisplaySettings = parentFolder.getDisplaySettings();
                boolean quickViewerVisible = folderDisplaySettings.isQuickViewerApplyPerFolder() && folderDisplaySettings.isQuickViewerVisible() || EngineCommandManager.getInstance(ControlsUtils.getUserGuid(this)).getAppearanceSettings().isQuickViewerVisible();
                ((ItemListTable)this.itemListComponent).selectFirstUnreadItem(quickViewerVisible);
            } else {
                ((ItemListTable)this.itemListComponent).selectFirstItem();
            }
        }
    }

    @Override
    public void refresh() {
        if (this.isDead()) {
            throw new DeadObjectMethodAccessException();
        }
        if (this.getFolder() == null || this.getViewDisplaySettings() == null) {
            return;
        }
        if (this.isBuilding()) {
            this.interrupt();
        }
        this.attachListeners(false);
        this.getMVCModel().clear();
        if (this.getController().getActionList() instanceof GWMainAppFrameActionList) {
            ((GWMainAppFrame)this.getController().getActionList().getMVCView()).getFoldersTree().hideTipPopup();
        }
        this.removeAll();
        this.add((Component)this.getLoadingPanel(), "Center");
        this.revalidate();
        this.repaint();
        this.buildThread = new Thread("Build Thread"){

            public void run() {
                ItemListViewPanel.this.setBuilding(true);
                try {
                    ItemListViewPanel.this.getItemList();
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            if (ItemListViewPanel.this.isBuilding()) {
                                ItemListViewPanel.this.initItemListComponent();
                                ItemListViewPanel.this.setBuilding(false);
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    logger.error((Object)e);
                }
                catch (Exception e) {
                    if (ItemListViewPanel.this.isDead()) {
                        logger.debug((Object)"exception in a build thread of dead object - OK");
                    }
                    throw new RuntimeException(e);
                }
            }
        };
        this.buildThread.start();
    }

    protected void processFilterChanged(Filter filter) {
        if (this.activated) {
            this.setFilter(filter);
        }
    }

    protected boolean canShowNothingFoundDialog() {
        if (this.model != null && this.model.getFolder() != null && this.model.getFolder().getType() == FolderType.QUERY) {
            return this.model.getFilter() != null;
        }
        return true;
    }

    private JPanel getLoadingPanel() {
        if (this.pnlLoading == null) {
            OrientableLabel lblLoading = new OrientableLabel(StringResources.LOADING_D, 0);
            float fontSize = (float)((double)this.getFont().getSize() * 1.5);
            lblLoading.setFont(this.getFont().deriveFont(fontSize));
            lblLoading.setForeground(Color.GRAY);
            JProgressBar progressBar = new JProgressBar();
            progressBar.setIndeterminate(true);
            this.pnlLoading = new OrientablePanel(new GridBagLayout());
            this.pnlLoading.setBackground(Color.WHITE);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = 10;
            constraints.fill = 0;
            this.pnlLoading.add((Component)lblLoading, constraints);
            ++constraints.gridy;
            this.pnlLoading.add((Component)progressBar, constraints);
        }
        return this.pnlLoading;
    }

    protected void processNothingFound(ItemListEvent e) {
        if (this.canShowNothingFoundDialog()) {
            ApplicationFrame frame = null;
            Window parentWindow = SwingUtilities.getWindowAncestor(this);
            if (parentWindow instanceof ApplicationFrame) {
                frame = (ApplicationFrame)parentWindow;
            }
            FilterFeedbackDialog dialog = new FilterFeedbackDialog(frame, this.getController());
            dialog.setLocationRelativeTo(frame);
            ((Dialog)dialog).setVisible(true);
        }
    }

    protected void processRefreshFolderQueryFinished() {
        this.getController().processCommand(new Command(670));
    }

    @Override
    public void setFilter(Filter filter) {
        if (this.isDead()) {
            throw new DeadObjectMethodAccessException();
        }
        this.getMVCModel().setFilter(filter);
    }

    @Override
    public void setData(AbstractFolder folder, IViewDisplaySettings viewDisplaySettings, Filter filter) {
        if (this.isDead()) {
            throw new DeadObjectMethodAccessException();
        }
        logger.debug((Object)("hashCode(): " + this.hashCode()));
        logger.debug((Object)("folder: " + folder.getName()));
        logger.debug((Object)("viewDisplaySettings: " + viewDisplaySettings));
        this.getMVCModel().setData(folder, viewDisplaySettings, filter);
    }

    @Override
    public void setData(AbstractFolder folder, AbstractFolder parentFolder, IViewDisplaySettings viewDisplaySettings, Filter filter) {
        if (this.isDead()) {
            throw new DeadObjectMethodAccessException();
        }
        logger.debug((Object)("folder: " + folder.getName()));
        logger.debug((Object)("viewDisplaySettings: " + viewDisplaySettings));
        this.getMVCModel().setData(folder, parentFolder, viewDisplaySettings, filter);
    }

    @Override
    public Filter getFilter() {
        if (this.isDead()) {
            throw new DeadObjectMethodAccessException();
        }
        return this.getMVCModel().getFilter();
    }

    @Override
    public IItemList getItemList() {
        if (this.isDead()) {
            throw new DeadObjectMethodAccessException();
        }
        return this.getMVCModel().getItemList();
    }

    @Override
    public JComponent getComponent() {
        if (this.isDead()) {
            throw new DeadObjectMethodAccessException();
        }
        return this;
    }

    @Override
    public void setController(ItemListViewPanelController controller) {
        this.controller = controller;
    }

    @Override
    public ItemListViewPanelController getController() {
        return this.controller;
    }

    @Override
    public void setMVCModel(ItemListViewModel model) {
        if (this.isDead()) {
            throw new DeadObjectMethodAccessException();
        }
        if (this.model != null) {
            this.model.removeItemListViewModelListener(this.modelListener);
        }
        this.model = model;
        if (this.model != null) {
            this.model.addItemListViewModelListener(this.modelListener);
        }
    }

    @Override
    public ItemListViewModel getMVCModel() {
        if (this.isDead()) {
            throw new DeadObjectMethodAccessException();
        }
        return this.model;
    }

    protected ItemListTable createNewItemListTable() {
        return new ItemListTable(this.getFolder(), this.getViewDisplaySettings(), this.getItemList(), this.getController());
    }

    protected GWCalendar createCalendar() {
        ItemListComponentDataModelImpl calendarModel = new ItemListComponentDataModelImpl(this.getAbstractFolder(), this.getViewDisplaySettings(), this.getItemList());
        return new GWCalendar(Calendar.getInstance(), false, this.getController(), calendarModel);
    }

    private ItemListTable getNewItemListTable() {
        if (this.newItemListTable != null && this.newItemListTable.getFolder().equals(this.getFolder()) && this.newItemListTable.getViewDisplaySettings().equals(this.getViewDisplaySettings())) {
            this.newItemListTable.setData(this.getAbstractFolder(), this.getViewDisplaySettings(), this.getItemList());
            return this.newItemListTable;
        }
        if (this.newItemListTable != null) {
            this.newItemListTable.dispose();
        }
        this.newItemListTable = this.createNewItemListTable();
        return this.newItemListTable;
    }

    private GWCalendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = this.createCalendar();
        }
        return this.calendar;
    }

    @Override
    public void dispose() {
        if (this.isBuilding()) {
            this.interrupt();
        }
        this.attachListeners(false);
        this.getMVCModel().clear();
        if (this.itemListComponent != null) {
            this.itemListComponent.dispose();
        }
    }

    @Override
    public void itemSelectionChanged(ItemSelectionChangedEvent event) {
        IItem[] items = event.getItems();
        this.selectedItemCount = 0;
        if (items != null) {
            this.selectedItemCount = items.length;
            this.getController().processCommand(new Command(2090, items));
            ArrayList<AbstractItem> abstractItems = new ArrayList<AbstractItem>();
            ArrayList<AbstractFolder> abstractFolders = new ArrayList<AbstractFolder>();
            ArrayList<IAddressable> contacts = new ArrayList<IAddressable>();
            GWCommandManager commandManager = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController()));
            for (IItem item : items) {
                if (item instanceof IFolder) {
                    abstractFolders.add(commandManager.getGWFolder((IFolder)item));
                    continue;
                }
                if (item instanceof IMessage) {
                    IMessage message = (IMessage)item;
                    try {
                        abstractItems.add(commandManager.getItem(this.getItemList(), message));
                    }
                    catch (GWCommandException e) {
                        logger.error((Object)e);
                    }
                    continue;
                }
                if (!(item instanceof IContact)) continue;
                contacts.add((IContact)item);
            }
            boolean focused = false;
            if (event.getSource() instanceof ItemListTable) {
                focused = ((ItemListTable)event.getSource()).isFocusOwner();
            } else if (this.itemListComponent instanceof GWCalendar) {
                focused = true;
            }
            if (!contacts.isEmpty()) {
                SelectedContactsInfoImpl contactsInfo = new SelectedContactsInfoImpl(this.getItemList(), contacts);
                Command command = new Command(240, contactsInfo);
                command.setAttribute((Object)AttributeKey.FOCUSED, focused);
                this.getController().processCommand(command);
            } else {
                Command command;
                if (abstractItems.isEmpty() && abstractFolders.isEmpty()) {
                    command = new Command(470);
                    this.getController().processCommand(command);
                } else {
                    SelectedItemsInfoImpl itemsInfo = new SelectedItemsInfoImpl(this.getItemList(), abstractItems, abstractFolders);
                    Command command2 = MessageUtils.hasSingleItem(itemsInfo) ? new Command(20, itemsInfo) : new Command(430, itemsInfo);
                    command2.setAttribute((Object)AttributeKey.FOCUSED, focused);
                    this.getController().processCommand(command2);
                }
                if (!abstractFolders.isEmpty() && abstractFolders.size() == 1) {
                    command = new Command(10, abstractFolders.get(0));
                    command.setAttribute((Object)AttributeKey.FOCUSED, Boolean.TRUE);
                    command.setAttribute((Object)AttributeKey.SOURCE, this);
                    this.getController().processCommand(command);
                }
            }
        }
    }

    @Override
    public ItemListComponent getItemListComponent() {
        if (this.isDead()) {
            throw new DeadObjectMethodAccessException();
        }
        return this.itemListComponent;
    }

    @Override
    public boolean isDead() {
        return this.dead;
    }

    @Override
    public void die() {
        this.dispose();
        this.dead = true;
    }

    static {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", new ILVPFocusListener());
    }

    private class ModelListener
    implements IItemListViewModelListener {
        private ModelListener() {
        }

        public void nothingFound(ItemListViewModel eventSource, ItemListEvent e) {
            ItemListViewPanel.this.processNothingFound(e);
        }

        public void itemListChanged(ItemListViewModel eventSource) {
            if (!ItemListViewPanel.this.isBuilding()) {
                ItemListViewPanel.this.getController().processCommand(new Command(2100, ItemListViewPanel.this));
            }
        }

        public void itemListQueryStarted(ItemListViewModel eventSource) {
            ItemListViewPanel.this.getController().processCommand(new Command(660));
        }

        public void itemListQueryFinished(ItemListViewModel eventSource) {
            ItemListViewPanel.this.processRefreshFolderQueryFinished();
        }
    }
}

