/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.components.htmleditor.BrowserType;
import com.appframework.components.htmleditor.GWBrowserFactory;
import com.appframework.components.htmleditor.GWMozillaBrowser;
import com.appframework.components.htmleditor.HTMLTextViewer;
import com.appframework.components.htmleditor.SimpleHTMLViewer;
import com.appframework.mvc.MVCController;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ItemBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.List;
import org.apache.log4j.Logger;

public class MessageSource
extends OrientablePanel
implements ItemBox {
    private static Logger logger = Logger.getLogger(MessageSource.class);
    private boolean contentRead = false;
    private SimpleHTMLViewer htmlViewer;
    private AbstractItem item;

    public MessageSource(AbstractItem item, MVCController parentController) {
        this(parentController);
        this.item = item;
    }

    public MessageSource(MVCController parentController) {
        this.htmlViewer = GWClient.USE_EXTERNAL_HTML_VIEWER() ? GWBrowserFactory.getBrowser(parentController, BrowserType.MESSAGE_SOURCE) : new HTMLTextViewer();
        this.setLayout(new BorderLayout());
        OrientableScrollPane pane = new OrientableScrollPane((Component)((Object)this.htmlViewer));
        pane.setVerticalScrollBarPolicy(21);
        this.add((Component)pane, "Center");
        this.setName(StringResources.MESSAGE_SOURCE);
    }

    public void setItem(AbstractItem item) {
        this.contentRead = false;
        this.item = item;
    }

    public AbstractItem getItem() {
        return this.item;
    }

    public void loadContent() {
        this.readSourceAttachment();
    }

    private void readSourceAttachment() {
        if (!this.contentRead) {
            this.htmlViewer.setStyledText("");
            this.contentRead = true;
            int sourceAttachmentIndex = this.item.getNativeItem().findSourceAttachment();
            logger.debug((Object)("sourceAttachmentIndex: " + sourceAttachmentIndex));
            if (sourceAttachmentIndex > -1) {
                List<GWAttachment> attachments = this.item.getAttachments();
                logger.debug((Object)("number of attachments: " + attachments.size()));
                while (sourceAttachmentIndex >= attachments.size()) {
                    logger.debug((Object)("reducing incorrect sourceAttachmentIndex to: " + --sourceAttachmentIndex));
                }
                GWAttachment attachment = attachments.get(sourceAttachmentIndex);
                logger.debug((Object)("attachment to show: " + attachment));
                if (attachment == null) {
                    return;
                }
                String attFile = attachment.saveToTempFile();
                if (attFile == null || attFile.equals("")) {
                    logger.debug((Object)">>  CAN'T SAVE ATTACHMENT <<");
                    return;
                }
                File file = new File(attFile);
                if (file.exists()) {
                    try {
                        if ("822".equalsIgnoreCase(Utils.getExtention(file.getName()))) {
                            logger.debug((Object)".822 file encountered, copying to .txt");
                            file = this.copy822FileToTxtFile(file);
                        }
                        this.htmlViewer.setPage(file.toURL());
                    }
                    catch (MalformedURLException e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                    catch (IOException e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                }
            }
        }
    }

    private File copy822FileToTxtFile(File file822) throws IOException {
        assert (file822.exists()) : "file does not exist: " + file822;
        File fileTxt = null;
        AbstractInterruptibleChannel ic = null;
        AbstractInterruptibleChannel oc = null;
        try {
            fileTxt = File.createTempFile(file822.getName(), ".txt", file822.getParentFile());
            ic = new FileInputStream(file822).getChannel();
            oc = new FileOutputStream(fileTxt).getChannel();
            ((FileChannel)ic).transferTo(0L, ((FileChannel)ic).size(), (WritableByteChannel)((Object)oc));
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (ic != null) {
                ic.close();
            }
            if (oc != null) {
                oc.close();
            }
        }
        return fileTxt;
    }

    public void release() {
        if (this.htmlViewer != null && GWClient.USE_EXTERNAL_HTML_VIEWER()) {
            GWBrowserFactory.releaseBrowser((GWMozillaBrowser)this.htmlViewer);
        }
    }
}

