/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.components.htmleditor.HTMLViewer;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.actions.componentrelated.ActionQuickViewer;
import com.novell.gw.jclient.application.commands.AttributeKey;
import com.novell.gw.jclient.application.controls.itemlisttable.lastlevel.ItemListTable;
import com.novell.gw.jclient.application.controls.itemview.QuickViewer;
import com.novell.gw.jclient.application.interfaces.ISelectedItemsInfo;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickViewerController
extends MVCController<QuickViewer> {
    private static Logger logger = Logger.getLogger(QuickViewerController.class);

    public QuickViewerController(QuickViewer view, MVCController parentController) {
        super(view, parentController, ActionQuickViewer.class);
    }

    @Override
    protected void initListeners() {
        Level level = this.getFrameLevel();
        logger.debug((Object)("level = " + level));
        AppEventListener listener = new GWITEM_SELECTED_listener();
        AppEventListenerDescriptor descriptor = new AppEventListenerDescriptor(level, 20, listener);
        this.addListenerDescriptor(descriptor);
        listener = new FOLDER_SELECTED_listener();
        descriptor = new AppEventListenerDescriptor(level, 10, listener);
        this.addListenerDescriptor(descriptor);
        listener = new NO_ITEMS_SELECTED_listener();
        descriptor = new AppEventListenerDescriptor(level, 470, listener);
        this.addListenerDescriptor(descriptor);
        listener = new MULTIPLE_ITEMS_SELECTED_listener();
        descriptor = new AppEventListenerDescriptor(level, 430, listener);
        this.addListenerDescriptor(descriptor);
        listener = new EDITABLE_COMPONENT_SELECTED_listener();
        descriptor = new AppEventListenerDescriptor(level, 1160, listener);
        this.addListenerDescriptor(descriptor);
        listener = new SHOW_HIDE_QUICKVIEWER_listener();
        descriptor = new AppEventListenerDescriptor(level, 710, listener);
        this.addListenerDescriptor(descriptor);
        listener = new GWITEM_MARKED_READ_LATER_listener();
        descriptor = new AppEventListenerDescriptor(level, 1870, listener);
        this.addListenerDescriptor(descriptor);
    }

    private class SHOW_HIDE_QUICKVIEWER_listener
    extends AppEventListener {
        private SHOW_HIDE_QUICKVIEWER_listener() {
        }

        public void handle(AppEvent theEvent) {
            if (!((Boolean)theEvent.getData()).booleanValue()) {
                return;
            }
            try {
                if (((QuickViewer)QuickViewerController.this.getMVCView()).getItem() != null) {
                    ((QuickViewer)QuickViewerController.this.getMVCView()).getItem().markOpen();
                }
            }
            catch (EngineException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
        }
    }

    private class MULTIPLE_ITEMS_SELECTED_listener
    extends AppEventListener {
        private MULTIPLE_ITEMS_SELECTED_listener() {
        }

        public void handle(AppEvent theEvent) {
            ((QuickViewer)QuickViewerController.this.getMVCView()).setMVCModel(null);
        }
    }

    private class NO_ITEMS_SELECTED_listener
    extends AppEventListener {
        private NO_ITEMS_SELECTED_listener() {
        }

        public void handle(AppEvent theEvent) {
            ((QuickViewer)QuickViewerController.this.getMVCView()).setMVCModel(null);
        }
    }

    private class EDITABLE_COMPONENT_SELECTED_listener
    extends AppEventListener {
        private EDITABLE_COMPONENT_SELECTED_listener() {
        }

        public void handle(AppEvent theEvent) {
            if (theEvent.getData() instanceof ItemListTable) {
                HTMLViewer htmlExternalTextViewer = (HTMLViewer)((QuickViewer)QuickViewerController.this.getMVCView()).getTextComponent();
                if (htmlExternalTextViewer.getMode() == 2) {
                    QuickViewerController.this.getActionList().processCommand(new Command(1320, htmlExternalTextViewer.getTextComponent()));
                } else {
                    QuickViewerController.this.getActionList().processCommand(new Command(1320, null));
                }
            }
        }
    }

    private class FOLDER_SELECTED_listener
    extends AppEventListener {
        private FOLDER_SELECTED_listener() {
        }

        public void handle(AppEvent theEvent) {
            Object source = theEvent.getAttribute((Object)AttributeKey.SOURCE);
            if (source != null && QuickViewer.SELECTION_EVENT_SOURCES.contains(source.getClass())) {
                ((QuickViewer)QuickViewerController.this.getMVCView()).setMVCModel(null);
            }
        }
    }

    private class GWITEM_SELECTED_listener
    extends AppEventListener {
        private GWITEM_SELECTED_listener() {
        }

        public void handle(AppEvent theEvent) {
            ISelectedItemsInfo itemsInfo;
            Object o = theEvent.getData();
            if (o instanceof ISelectedItemsInfo && (itemsInfo = (ISelectedItemsInfo)o).hasItems()) {
                ((QuickViewer)QuickViewerController.this.getMVCView()).processGWItemSelected(itemsInfo.getItem());
                return;
            }
            ((QuickViewer)QuickViewerController.this.getMVCView()).setMVCModel(null);
        }
    }

    private class GWITEM_MARKED_READ_LATER_listener
    extends AppEventListener {
        private GWITEM_MARKED_READ_LATER_listener() {
        }

        public void handle(AppEvent event) {
            String itemId = (String)event.getData();
            ((QuickViewer)QuickViewerController.this.getMVCView()).processGWItemMarkedReadLater(itemId);
        }
    }
}

