/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview.contentviewer;

import com.appframework.AppAction;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.api.enums.AppointmentAcceptLevel;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.itemview.contentviewer.AppointmentAcceptLevelColorButtonController;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class AppointmentAcceptLevelColorButton
extends OrientableLabel
implements MVCView {
    private final MVCController controller;
    private AppointmentAcceptLevel acceptLevel;
    private JPopupMenu popup;
    private Icon icon;

    private AppointmentAcceptLevelColorButton(MVCController controller) {
        this.controller = new AppointmentAcceptLevelColorButtonController(this, controller);
    }

    public AppointmentAcceptLevelColorButton(MVCController controller, AppointmentAcceptLevel acceptLevel) {
        this(controller);
        this.setAcceptLevel(acceptLevel);
        this.init();
        this.buildUI();
    }

    private void init() {
        this.popup = new AALCBPopup();
        this.icon = new AcceptLevelIcon();
    }

    public void setAcceptLevel(AppointmentAcceptLevel acceptLevel) {
        this.acceptLevel = acceptLevel;
        this.repaint();
    }

    public AppointmentAcceptLevel getAcceptLevel() {
        return this.acceptLevel;
    }

    private void buildUI() {
        this.setOpaque(true);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                AppointmentAcceptLevelColorButton.this.popup.show(AppointmentAcceptLevelColorButton.this, 0, AppointmentAcceptLevelColorButton.this.getHeight());
            }
        });
        this.setIcon(this.icon);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void setController(MVCController controller) {
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object model) {
        if (model instanceof AppointmentAcceptLevel) {
            this.setAcceptLevel((AppointmentAcceptLevel)((Object)model));
        }
    }

    public AppointmentAcceptLevel getMVCModel() {
        return this.getAcceptLevel();
    }

    private class AcceptLevelIcon
    implements Icon {
        final int divider = 3;

        private AcceptLevelIcon() {
        }

        public void paintIcon(Component component, Graphics g, int x, int y) {
            int size = component.getHeight();
            size -= size % 3;
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (AppointmentAcceptLevel.TENTATIVE.equals((Object)AppointmentAcceptLevelColorButton.this.acceptLevel)) {
                g2.setPaint(AppointmentAcceptLevel.tentativeTexturePaint);
            } else {
                Color color = AppointmentAcceptLevelColorButton.this.acceptLevel.getColor();
                g.setColor(color != null ? color : component.getBackground());
            }
            g.fillRoundRect(x, y, size, size, size / 3, size / 3);
        }

        public int getIconWidth() {
            return 15;
        }

        public int getIconHeight() {
            return 15;
        }
    }

    private class AALCBPopup
    extends GWPopupMenu {
        private AALCBPopup() {
            this.addAppAction(AppointmentAcceptLevelColorButton.this.controller.getActionList().getAction(ActionKey.SHOW_AS_FREE));
            this.addAppAction(AppointmentAcceptLevelColorButton.this.controller.getActionList().getAction(ActionKey.SHOW_AS_TENTATIVE));
            this.addAppAction(AppointmentAcceptLevelColorButton.this.controller.getActionList().getAction(ActionKey.SHOW_AS_BUSY));
            this.addAppAction(AppointmentAcceptLevelColorButton.this.controller.getActionList().getAction(ActionKey.SHOW_AS_OUT_OF_OFFICE));
        }

        public void addAppAction(AppAction action) {
            super.add(action.getMenuItem());
        }
    }
}

