/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview.imageviewer;

import com.novell.gw.jclient.application.controls.itemview.imageviewer.ImageLoadException;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.om.PathManager;
import com.sun.media.jai.codec.ByteArraySeekableStream;
import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.apache.log4j.Logger;

public class ImageReader {
    private static Logger logger = Logger.getLogger(ImageReader.class);
    private static String DEFAULT_IMAGE_FILE = "images/ci.png";

    public static PlanarImage readImage(String filename) throws ImageLoadException {
        try {
            Object stream;
            RenderedOp image = null;
            File file = new File(filename);
            boolean fileExists = file.exists();
            if (System.getProperty("JAI_IMAGE_READER_USE_CODECS") == null) {
                if (fileExists) {
                    image = JAI.create((String)"fileload", (Object)filename);
                } else {
                    stream = new ByteArraySeekableStream(ImageResources.loadImageStream(filename));
                    image = JAI.create((String)"stream", (Object)stream);
                }
            } else {
                stream = null;
                stream = fileExists ? new FileSeekableStream(filename) : new ByteArraySeekableStream(ImageResources.loadImageStream(filename));
                String[] names = ImageCodec.getDecoderNames((SeekableStream)stream);
                ImageDecoder dec = ImageCodec.createImageDecoder((String)names[0], (SeekableStream)stream, null);
                RenderedImage im = dec.decodeAsRenderedImage();
                image = PlanarImage.wrapRenderedImage((RenderedImage)im);
            }
            if (image.getColorModel() instanceof IndexColorModel) {
                IndexColorModel icm = (IndexColorModel)image.getColorModel();
                int mapSize = icm.getMapSize();
                byte[][] lutData = new byte[3][mapSize];
                icm.getReds(lutData[0]);
                icm.getGreens(lutData[1]);
                icm.getBlues(lutData[2]);
                LookupTableJAI lut = new LookupTableJAI(lutData);
                image = JAI.create((String)"lookup", (RenderedImage)image, (Object)lut);
            }
            return image;
        }
        catch (Exception e) {
            logger.debug((Object)e, (Throwable)e);
            logger.error((Object)e);
            File f = new File(filename);
            if (f.exists()) {
                f.delete();
            }
            throw new ImageLoadException("Error opening image [" + filename + "] :" + e.getMessage());
        }
    }

    public static PlanarImage getDefaultImage() {
        try {
            StringBuilder path = new StringBuilder(PathManager.getTempFolderPath());
            path.append(File.separator);
            path.append("ci.png");
            String ciPath = path.toString();
            File defaulFile = new File(ciPath);
            if (!defaulFile.exists()) {
                byte[] bytes = ImageResources.loadImageStream(DEFAULT_IMAGE_FILE);
                FileOutputStream out = new FileOutputStream(defaulFile);
                out.write(bytes);
                out.flush();
                out.close();
            }
            return ImageReader.readImage(ciPath);
        }
        catch (Exception e) {
            logger.debug((Object)e, (Throwable)e);
            return null;
        }
    }
}

