/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview.itemviewer;

import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.MachineSettings;
import com.novell.gw.jclient.application.actions.ActionHTMLText;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionPlainText;
import com.novell.gw.jclient.application.controls.itemview.itemviewer.ItemViewer;
import com.novell.gw.jclient.application.frames.open.FrameOpenActionList;
import com.novell.gw.jclient.application.interfaces.ISelectedItemsInfo;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MessageBody;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemViewerController
extends MVCController<ItemViewer> {
    private static Logger logger = Logger.getLogger(ItemViewerController.class);
    private boolean handleSelectionCommands;

    public ItemViewerController(ItemViewer itemViewer, MVCController parentController, boolean handleSelectionCommands) {
        super(parentController.getLevel());
        this.setMVCView(itemViewer);
        this.handleSelectionCommands = handleSelectionCommands;
    }

    @Override
    protected void initListeners() {
        Level level = this.getFrameLevel();
        AppEventListener listener = new ATTACHMENT_SELECTED_listener();
        AppEventListenerDescriptor descriptor = new AppEventListenerDescriptor(level, 50, listener);
        this.addListenerDescriptor(descriptor);
        listener = new GWITEM_SELECTED_listener();
        descriptor = new AppEventListenerDescriptor(level, 20, listener);
        this.addListenerDescriptor(descriptor);
        listener = new FOLDER_SELECTED_listener();
        descriptor = new AppEventListenerDescriptor(level, 10, listener);
        this.addListenerDescriptor(descriptor);
        listener = new NO_ITEMS_SELECTED_listener();
        descriptor = new AppEventListenerDescriptor(level, 470, listener);
        this.addListenerDescriptor(descriptor);
        listener = new MULTIPLE_ITEMS_SELECTED_listener();
        descriptor = new AppEventListenerDescriptor(level, 430, listener);
        this.addListenerDescriptor(descriptor);
        listener = new ACTION_PLAIN_TEXT_PERFORMED_listener();
        descriptor = new AppEventListenerDescriptor(level, 780, listener);
        this.addListenerDescriptor(descriptor);
        listener = new ACTION_HTML_TEXT_PERFORMED_listener();
        descriptor = new AppEventListenerDescriptor(level, 790, listener);
        this.addListenerDescriptor(descriptor);
        listener = new ACTION_SWITCH_ATTACHMENT_WINDOW_listener();
        descriptor = new AppEventListenerDescriptor(level, 890, listener);
        this.addListenerDescriptor(descriptor);
        listener = new ACTION_HIDE_SYSTEM_ATTACHMENTS_listener();
        descriptor = new AppEventListenerDescriptor(level, 940, listener);
        this.addListenerDescriptor(descriptor);
        listener = new OPEN_MESSAGE_ATTACHMENT_listener();
        descriptor = new AppEventListenerDescriptor(level, 920, listener);
        this.addListenerDescriptor(descriptor);
        listener = new ZOOM_RESET_listener();
        descriptor = new AppEventListenerDescriptor(level, 1250, listener);
        this.addListenerDescriptor(descriptor);
        listener = new ZOOM_IN_listener();
        descriptor = new AppEventListenerDescriptor(level, 1230, listener);
        this.addListenerDescriptor(descriptor);
        listener = new ZOOM_OUT_listener();
        descriptor = new AppEventListenerDescriptor(level, 1240, listener);
        this.addListenerDescriptor(descriptor);
    }

    public void updatePlainHTML() {
        MachineSettings.TextOption textOption = OptionManager.getInstance().getTextOption();
        AbstractItem item = ((ItemViewer)this.getMVCView()).getCurrentItem();
        ActionHTMLText htmlAction = (ActionHTMLText)this.getActionList().getAction(ActionKey.HTML_TEXT);
        ActionPlainText plainAction = (ActionPlainText)this.getActionList().getAction(ActionKey.PLAIN_TEXT);
        if (item != null && item.isHTMLMessage() && !textOption.isHTMLDisallowed()) {
            htmlAction.setEnabled(true);
            plainAction.setEnabled(!MessageBody.isHTMLOnlyMessage(item.getMessage()));
            if (((ItemViewer)this.getMVCView()).getViewMode() == 1) {
                htmlAction.setSelected(true);
                plainAction.setSelected(false);
            } else {
                plainAction.setSelected(true);
                htmlAction.setSelected(false);
            }
        } else {
            htmlAction.setEnabled(false);
            plainAction.setEnabled(false);
            htmlAction.setSelected(false);
            plainAction.setSelected(true);
        }
    }

    void turnOff() {
        ActionHTMLText htmlAction = (ActionHTMLText)this.getActionList().getAction(ActionKey.HTML_TEXT);
        htmlAction.setSelected(false);
        htmlAction.setEnabled(false);
        ActionPlainText plainAction = (ActionPlainText)this.getActionList().getAction(ActionKey.PLAIN_TEXT);
        plainAction.setSelected(false);
        plainAction.setEnabled(false);
    }

    private void handleNO_ITEMS_SELECTED() {
        ((ItemViewer)this.getMVCView()).setItem(null);
        ((ItemViewer)this.getMVCView()).setEmbededParentViewVisible(false);
        this.turnOff();
        if (this.handleSelectionCommands) {
            ((ItemViewer)this.getMVCView()).loadContent();
        }
    }

    private class ZOOM_OUT_listener
    extends AppEventListener {
        private ZOOM_OUT_listener() {
        }

        public void handle(AppEvent theEvent) {
            ((ItemViewer)ItemViewerController.this.getMVCView()).zoom(false);
        }
    }

    private class ZOOM_IN_listener
    extends AppEventListener {
        private ZOOM_IN_listener() {
        }

        public void handle(AppEvent theEvent) {
            ((ItemViewer)ItemViewerController.this.getMVCView()).zoom(true);
        }
    }

    private class ZOOM_RESET_listener
    extends AppEventListener {
        private ZOOM_RESET_listener() {
        }

        public void handle(AppEvent theEvent) {
            ((ItemViewer)ItemViewerController.this.getMVCView()).resetZoom();
        }
    }

    private class OPEN_MESSAGE_ATTACHMENT_listener
    extends AppEventListener {
        private OPEN_MESSAGE_ATTACHMENT_listener() {
        }

        public void handle(AppEvent theEvent) {
            ((ItemViewer)ItemViewerController.this.getMVCView()).setEmbededMessage((AbstractItem)theEvent.getData());
        }
    }

    private class ACTION_HIDE_SYSTEM_ATTACHMENTS_listener
    extends AppEventListener {
        private ACTION_HIDE_SYSTEM_ATTACHMENTS_listener() {
        }

        public void handle(AppEvent theEvent) {
            ((ItemViewer)ItemViewerController.this.getMVCView()).setHideSystemAttachments();
        }
    }

    private class ACTION_SWITCH_ATTACHMENT_WINDOW_listener
    extends AppEventListener {
        private ACTION_SWITCH_ATTACHMENT_WINDOW_listener() {
        }

        public void handle(AppEvent event) {
            FrameOpenActionList frameOpenActionList = (FrameOpenActionList)ItemViewerController.this.getParentController(FrameOpenActionList.class);
            if (frameOpenActionList != null) {
                if (frameOpenActionList.equals(event.getSource())) {
                    ((ItemViewer)ItemViewerController.this.getMVCView()).setShowAttachments((Boolean)event.getData());
                }
            } else {
                ((ItemViewer)ItemViewerController.this.getMVCView()).setShowAttachments();
            }
        }
    }

    private class ACTION_HTML_TEXT_PERFORMED_listener
    extends AppEventListener {
        private ACTION_HTML_TEXT_PERFORMED_listener() {
        }

        public void handle(AppEvent theEvent) {
            ((ItemViewer)ItemViewerController.this.getMVCView()).setupHTMLView();
            ActionHTMLText htmlAction = (ActionHTMLText)ItemViewerController.this.getActionList().getAction(ActionKey.HTML_TEXT);
            htmlAction.setSelected(true);
        }
    }

    private class ACTION_PLAIN_TEXT_PERFORMED_listener
    extends AppEventListener {
        private ACTION_PLAIN_TEXT_PERFORMED_listener() {
        }

        public void handle(AppEvent theEvent) {
            ((ItemViewer)ItemViewerController.this.getMVCView()).setupRtfMessage();
            ActionPlainText plainAction = (ActionPlainText)ItemViewerController.this.getActionList().getAction(ActionKey.PLAIN_TEXT);
            plainAction.setSelected(true);
        }
    }

    private class MULTIPLE_ITEMS_SELECTED_listener
    extends AppEventListener {
        private MULTIPLE_ITEMS_SELECTED_listener() {
        }

        public void handle(AppEvent theEvent) {
            if (!ItemViewerController.this.handleSelectionCommands) {
                return;
            }
            ItemViewerController.this.handleNO_ITEMS_SELECTED();
        }
    }

    private class NO_ITEMS_SELECTED_listener
    extends AppEventListener {
        private NO_ITEMS_SELECTED_listener() {
        }

        public void handle(AppEvent theEvent) {
            if (!ItemViewerController.this.handleSelectionCommands) {
                return;
            }
            ItemViewerController.this.handleNO_ITEMS_SELECTED();
        }
    }

    private class FOLDER_SELECTED_listener
    extends AppEventListener {
        private FOLDER_SELECTED_listener() {
        }

        public void handle(AppEvent theEvent) {
            if (!ItemViewerController.this.handleSelectionCommands) {
                return;
            }
            AbstractFolder abstractFolder = (AbstractFolder)theEvent.getData();
            ((ItemViewer)ItemViewerController.this.getMVCView()).processFolderSelected(abstractFolder);
        }
    }

    private class GWITEM_SELECTED_listener
    extends AppEventListener {
        private GWITEM_SELECTED_listener() {
        }

        public void handle(AppEvent theEvent) {
            ISelectedItemsInfo itemsInfo;
            if (!ItemViewerController.this.handleSelectionCommands) {
                return;
            }
            Object o = theEvent.getData();
            if (o instanceof ISelectedItemsInfo && (itemsInfo = (ISelectedItemsInfo)o).hasItems()) {
                ((ItemViewer)ItemViewerController.this.getMVCView()).processGWItemSelected(itemsInfo.getItem());
                return;
            }
            ItemViewerController.this.handleNO_ITEMS_SELECTED();
        }
    }

    private class ATTACHMENT_SELECTED_listener
    extends AppEventListener {
        private ATTACHMENT_SELECTED_listener() {
        }

        public void handle(AppEvent theEvent) {
            if (!((ItemViewer)ItemViewerController.this.getMVCView()).canSetAttachment()) {
                logger.debug((Object)"itemViewer not ready - skipping event");
                return;
            }
            Object data = theEvent.getData();
            ((ItemViewer)ItemViewerController.this.getMVCView()).setAttachment(data);
            if (data instanceof AbstractItem) {
                ItemViewerController.this.updatePlainHTML();
            } else {
                ItemViewerController.this.turnOff();
            }
        }
    }
}

