/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.menus;

import com.appframework.ActionList;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.menus.AbstractGWItemPopupMenu;
import com.novell.gw.jclient.application.controls.menus.CategoriesMenuListener;
import com.novell.gw.jclient.application.controls.mnemonic.MnemonicMenu;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class CalendarViewGWItemPopupMenu
extends AbstractGWItemPopupMenu {
    private String itemType;

    protected CalendarViewGWItemPopupMenu(ActionList actionList, AbstractFolder folder, IItemList itemList, AbstractItem item, String itemType) {
        super(actionList, folder, itemList, item, null);
        this.itemType = itemType;
        this.build();
    }

    private void build() {
        JMenu menuNew = GWCalendarUtils.buildNewCalendarItemMenu(this.actionList, this.itemType);
        this.add(menuNew);
        this.addAction(ActionKey.OPEN_ITEM);
        if (this.item.canAccept()) {
            this.addAction(ActionKey.ACCEPT);
            this.addAction(ActionKey.ACCEPT_WITH_OPTIONS);
        }
        if (this.item.canDecline()) {
            this.addAction(ActionKey.DECLINE);
            this.addAction(ActionKey.DECLINE_WITH_OPTIONS);
        }
        this.addAction(ActionKey.CHANGE_ITEM_TO);
        if (this.item.canDelegate()) {
            this.addAction(ActionKey.DELEGATE);
        }
        this.addAction(ActionKey.RESEND);
        this.addAction(ActionKey.SAVE_GWITEM);
        if (this.itemType.equals("Task")) {
            this.addAction(ActionKey.COMPLETE);
        }
        this.addAction(ActionKey.DELETE_ITEM);
        this.addAction(ActionKey.MARK_PRIVATE);
        this.addAction(ActionKey.ALARM);
        JMenu menuCategories = (JMenu)this.actionList.getAction(ActionKey.EDIT_CATEGORIES_FOR_GWMENU).getMenuItem();
        menuCategories.addMenuListener(new CategoriesMenuListener(this.actionList));
        this.add(menuCategories);
        this.addAction(ActionKey.MOVE_TO_ARCHIVE);
        if (this.itemType.equals("Appointment") || this.itemType.equals("AllDayEvent")) {
            this.add(this.buildMenuShowAppointmentAs());
            this.addSeparator();
            this.addAction(ActionKey.ALTERNATE_TIME_ZONE);
        }
        if (this.item.canDoInfo()) {
            this.addSeparator();
            this.addAction(ActionKey.ITEM_PROPERTIES);
        }
    }

    private JMenu buildMenuShowAppointmentAs() {
        MnemonicMenu menuShowAppointmentAs = new MnemonicMenu(StringResources.MENU_SHOW_APPOINTMENT_AS);
        ButtonGroup bg = new ButtonGroup();
        JMenuItem item = this.actionList.getAction(ActionKey.SHOW_AS_FREE).getMenuItem();
        bg.add(item);
        menuShowAppointmentAs.add(item);
        item = this.actionList.getAction(ActionKey.SHOW_AS_TENTATIVE).getMenuItem();
        bg.add(item);
        menuShowAppointmentAs.add(item);
        item = this.actionList.getAction(ActionKey.SHOW_AS_BUSY).getMenuItem();
        bg.add(item);
        menuShowAppointmentAs.add(item);
        item = this.actionList.getAction(ActionKey.SHOW_AS_OUT_OF_OFFICE).getMenuItem();
        bg.add(item);
        menuShowAppointmentAs.add(item);
        return menuShowAppointmentAs;
    }
}

