/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.menus;

import com.novell.gw.jclient.api.enums.CategoryListRecordStatusType;
import com.novell.gw.jclient.api.interfaces.ICategory;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class CategorySelectAction
extends AbstractAction {
    private static Logger logger = Logger.getLogger(CategorySelectAction.class);
    JMenuItem menuItem;
    ICategory category;
    IItem[] items;
    private IItemList itemList;

    private CategorySelectAction(IItemList itemList, ICategory category) {
        this.itemList = itemList;
        this.category = category;
        this.menuItem = MenuItemFactory.createCkeckBoxMenuItem(this);
        this.menuItem.setText(category.getName());
    }

    public CategorySelectAction(IItemList itemList, IItem[] items, ICategory category) {
        this(itemList, category);
        this.items = items;
        this.menuItem.setSelected(CategoryUtils.getCategories(this.items).findCategoryIndex(category) > -1);
    }

    public JMenuItem getMenuItem() {
        return this.menuItem;
    }

    public void actionPerformed(ActionEvent e) {
        boolean selected = this.menuItem.isSelected();
        for (IItem item : this.items) {
            IItem[] array = new IItem[]{item};
            ICategoryList categories = CategoryUtils.getCategories(item);
            if (categories == null) continue;
            this.menuItem.setSelected(selected);
            if (selected) {
                categories.addCategory(this.category, CategoryListRecordStatusType.ADD);
            } else if (categories.isPrimary(categories.findCategoryIndex(this.category))) {
                categories.setPrimary(this.category, false, CategoryListRecordStatusType.REMOVE);
            } else {
                categories.setState(this.category, CategoryListRecordStatusType.REMOVE);
            }
            this.itemList.setCategories(categories, array);
        }
    }
}

