/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.menus;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.enums.FolderType;
import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.folder.IContactsFolder;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.filter.ActionContextItemContactFilter;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListView;
import com.novell.gw.jclient.application.controls.menus.AbstractActionsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.GWApplicationFrameMenuBar;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.utils.ColumnInfos;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.ContactItemDescription;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;

public class ItemListFolderPopupMenu
extends AbstractActionsPopupMenu {
    private GWMenu menuNew;
    private IViewDisplaySettings displaySettings;
    private IContact contact;
    private ItemListView itemListView;

    public ItemListFolderPopupMenu(MVCController controller, ItemListView itemListView, AbstractItem item, String column) {
        this.itemListView = itemListView;
        this.actionList = controller.getActionList();
        this.displaySettings = itemListView.getViewDisplaySettings();
        this.folder = itemListView.getAbstractFolder();
        this.columnName = column;
        this.item = item;
        this.init();
        this.build();
    }

    public ItemListFolderPopupMenu(MVCController controller, ItemListView itemListView, IContact contact, String column) {
        this.itemListView = itemListView;
        this.actionList = controller.getActionList();
        this.displaySettings = itemListView.getViewDisplaySettings();
        this.folder = itemListView.getAbstractFolder();
        this.columnName = column;
        this.contact = contact;
        this.init();
        this.build();
    }

    private void init() {
        this.isInPanel = this.displaySettings.isPanelSettings();
        this.panelName = this.displaySettings.getViewMode() == 8 ? ((IPanelDisplaySettings)this.displaySettings).getPanelName() : null;
        this.checkMenuOpenedInPanel(this.getActionList());
    }

    private ActionContextItemContactFilter getContactFindAction() {
        ActionContextItemContactFilter actionContextItemFilter = (ActionContextItemContactFilter)this.actionList.getAction(ActionKey.CONTEXT_ITEM_CONTACT_FILTER);
        ColumnInfos columnInfos = new ColumnInfos(this.displaySettings.getColumnAndSortInfo());
        ContactItemDescription description = this.contact != null ? new ContactItemDescription(this.contact, this.columnName, columnInfos) : null;
        actionContextItemFilter.setModel(description, this.isInPanel ? this.panelName : this.folder.getName(), this.isInPanel);
        return actionContextItemFilter;
    }

    protected void build() {
        AppAction action;
        this.buildNew();
        this.add(this.menuNew);
        boolean isContacts = this.folder.isContactsFolder();
        if (isContacts) {
            this.add(this.getContactFindAction());
        } else {
            this.add(this.getFindAction());
        }
        int viewMode = this.displaySettings.getViewMode();
        FolderType folderType = this.folder.getNativeFolder().getType();
        if (viewMode != 5 && (folderType != FolderType.CHECKLIST || viewMode != 7)) {
            action = this.folder instanceof QueryFolder ? new ActionToggleGroupLabel(this.actionList) : this.actionList.getAction(ActionKey.TOGGLE_GROUP_LABELS);
            this.add(action);
        }
        if (!isContacts) {
            action = this.folder instanceof QueryFolder ? new ActionToggleMessagePreview(this.actionList) : this.actionList.getAction(ActionKey.TOGGLE_MESSAGE_PREVIEW);
            this.add(action);
        }
        if (this.displaySettings.getViewMode() == 7) {
            this.addSeparator();
            this.addAction(ActionKey.HIDE_ITEMS_NOT_IN_TASKLIST);
            this.addAction(ActionKey.HIDE_COMPLETED_ITEMS_IMMEDIATELY);
            this.addAction(ActionKey.HIDE_COMPLETED_ITEMS_AFTER_A_DAY);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        this.addSeparator();
        if (this.folder instanceof QueryFolder) {
            action = new ActionViewDetail(this.actionList);
            this.add(action, buttonGroup);
        } else if (ControlsUtils.isViewByDetailsSupported(this.folder, this.isInPanel)) {
            action = this.actionList.getAction(ActionKey.SET_VIEW_MODE_DETAILS);
            this.add(action, buttonGroup);
        }
        if (this.folder instanceof QueryFolder) {
            action = new ActionViewThreads(this.actionList);
            this.add(action, buttonGroup);
        } else if (ControlsUtils.isViewByConversationSupported(this.folder, this.isInPanel)) {
            action = this.actionList.getAction(ActionKey.SET_VIEW_MODE_CONVERSATION);
            this.add(action, buttonGroup);
        }
        if (!this.isInPanel) {
            action = this.actionList.getAction(ActionKey.SET_VIEW_MODE_PANELS);
            this.add(action, buttonGroup);
        }
        if (ControlsUtils.isViewByCalendarSupported(this.folder, this.isInPanel)) {
            action = this.actionList.getAction(ActionKey.SET_VIEW_MODE_CALENDAR);
            this.add(action, buttonGroup);
        }
        if (ControlsUtils.isViewByCheckListSupported(this.folder, this.isInPanel)) {
            action = this.actionList.getAction(ActionKey.SET_VIEW_MODE_CHECKLIST);
            this.add(action, buttonGroup);
        }
        this.addSeparator();
        buttonGroup = new ButtonGroup();
        action = this.folder instanceof QueryFolder ? new ActionSetFolderViewColumns(this.actionList) : this.actionList.getAction(ActionKey.SET_FOLDER_VIEW_COLUMNS);
        this.add(action, buttonGroup);
        action = this.folder instanceof QueryFolder ? new ActionSetFolderViewSummary(this.actionList) : this.actionList.getAction(ActionKey.SET_FOLDER_VIEW_SUMMARY);
        this.add(action, buttonGroup);
        buttonGroup = new ButtonGroup();
        action = this.actionList.getAction(ActionKey.SAVE_DISPLAY_SETTINGS);
        if (action != null) {
            this.addSeparator();
        }
        this.add(action, buttonGroup);
    }

    public void add(AppAction a) {
        this.add(a, null);
    }

    public void add(AppAction a, ButtonGroup bg) {
        JMenuItem mi;
        if (a != null && (mi = a.getMenuItem()) != null) {
            if (bg != null) {
                bg.add(mi);
            }
            this.add(mi);
        }
    }

    private void buildNew() {
        this.menuNew = new GWMenu(StringResources.MENU_NEW);
        boolean needAddContact = !(this.itemListView.getFolder() instanceof IContactsFolder) || !((IContactsFolder)this.itemListView.getFolder()).getAddressBook(EngineCommandManager.getAddressBookManager()).isReadOnly();
        GWApplicationFrameMenuBar.rebuildFileNewWithFolder(this.menuNew, (ApplicationFrameActionList)this.actionList, needAddContact);
    }

    private void refreshTable() {
        if (this.itemListView != null) {
            this.itemListView.refresh();
        }
    }

    private class ActionViewThreads
    extends AppAction {
        public ActionViewThreads(ActionList theAppActionList) {
            super(theAppActionList, ActionKey.SET_VIEW_MODE_CONVERSATION, StringResources.VIEW_DISCUSSION_THREADS);
            this.setType(AppAction.ActionType.RADIO);
            this.setSelected(ItemListFolderPopupMenu.this.displaySettings.getViewMode() == 5);
        }

        protected void performAction(ActionEvent e) {
            ItemListFolderPopupMenu.this.displaySettings.setViewMode(5);
            ItemListFolderPopupMenu.this.refreshTable();
        }
    }

    private class ActionViewDetail
    extends AppAction {
        public ActionViewDetail(ActionList theAppActionList) {
            super(theAppActionList, ActionKey.SET_VIEW_MODE_DETAILS, StringResources.VIEW_DETAILS);
            this.setType(AppAction.ActionType.RADIO);
            this.setSelected(ItemListFolderPopupMenu.this.displaySettings.getViewMode() == 1);
        }

        protected void performAction(ActionEvent e) {
            ItemListFolderPopupMenu.this.displaySettings.setViewMode(1);
            ItemListFolderPopupMenu.this.refreshTable();
        }
    }

    private class ActionSetFolderViewSummary
    extends AppAction {
        public ActionSetFolderViewSummary(ActionList theAppActionList) {
            super(theAppActionList, ActionKey.SET_FOLDER_VIEW_SUMMARY, StringResources.VIEW_SUMMARY);
            this.setType(AppAction.ActionType.RADIO);
            this.setSelected(ItemListFolderPopupMenu.this.displaySettings.isSummaryView());
        }

        protected void performAction(ActionEvent e) {
            ItemListFolderPopupMenu.this.displaySettings.setSummaryView(true);
            ItemListFolderPopupMenu.this.refreshTable();
        }
    }

    private class ActionSetFolderViewColumns
    extends AppAction {
        public ActionSetFolderViewColumns(ActionList theAppActionList) {
            super(theAppActionList, ActionKey.SET_FOLDER_VIEW_COLUMNS, StringResources.VIEW_COLUMNS);
            this.setType(AppAction.ActionType.RADIO);
            this.setSelected(!ItemListFolderPopupMenu.this.displaySettings.isSummaryView());
        }

        protected void performAction(ActionEvent e) {
            ItemListFolderPopupMenu.this.displaySettings.setSummaryView(false);
            ItemListFolderPopupMenu.this.refreshTable();
        }
    }

    private class ActionToggleGroupLabel
    extends AppAction {
        public ActionToggleGroupLabel(ActionList theAppActionList) {
            super(theAppActionList, ActionKey.TOGGLE_GROUP_LABELS, StringResources.SHOW_GROUP_LABELS);
            this.setType(AppAction.ActionType.CHECKABLE);
            this.setSelected(ItemListFolderPopupMenu.this.displaySettings.showGroupHeaders());
        }

        protected void performAction(ActionEvent e) {
            ItemListFolderPopupMenu.this.displaySettings.setShowGroupHeaders(!this.isSelected());
            ItemListFolderPopupMenu.this.refreshTable();
        }
    }

    private class ActionToggleMessagePreview
    extends AppAction {
        public ActionToggleMessagePreview(ActionList theAppActionList) {
            super(theAppActionList, ActionKey.TOGGLE_MESSAGE_PREVIEW, StringResources.MESSAGE_PREVIEW);
            this.setType(AppAction.ActionType.CHECKABLE);
            this.setSelected(ItemListFolderPopupMenu.this.displaySettings.getMsgPreview());
        }

        protected void performAction(ActionEvent e) {
            boolean selected = ((AbstractButton)e.getSource()).isSelected();
            ItemListFolderPopupMenu.this.displaySettings.setMsgPreview(selected);
            ItemListFolderPopupMenu.this.refreshTable();
        }
    }
}

