/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.menus;

import com.appframework.ActionList;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.menus.AbstractGWItemPopupMenu;
import com.novell.gw.jclient.application.controls.menus.GWItemPopupMenu;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import org.apache.log4j.Logger;

public class NNTPItemPopupMenu
extends AbstractGWItemPopupMenu {
    private static Logger logger = Logger.getLogger(GWItemPopupMenu.class);

    public NNTPItemPopupMenu(ActionList actionList, AbstractFolder folder, IItemList itemList, AbstractItem item, String columnName) {
        super(actionList, folder, itemList, item, columnName);
        this.build();
    }

    private void build() {
        this.addAction(ActionKey.OPEN_ITEM);
        if (this.folder.getType().compareTo(StringResources.CALENDAR_FOLDER) != 0) {
            this.addAction(ActionKey.PRINT);
            this.buildFindMenuItem();
        }
        this.addSeparator();
        if (!this.item.getNativeItem().isNNTPHeader()) {
            this.addAction(ActionKey.REPLY);
            this.addAction(ActionKey.FORWARD);
            this.addAction(ActionKey.FORWARD_AS_ATTACHMENT);
        }
        if (this.item.isDeleted() || this.item.isIMAPDeleted()) {
            this.addAction(ActionKey.EMPTY_ITEM);
            this.addAction(ActionKey.UNDELETE_ITEM);
        } else {
            this.addAction(ActionKey.DELETE_ITEM);
        }
        if (!this.item.getNativeItem().isNNTPHeader()) {
            this.addAction(ActionKey.MOVE_TO_ARCHIVE);
        }
        this.buildJunkMailMenu();
        this.addSeparator();
        if (this.item.isStatusRead()) {
            this.addAction(ActionKey.MARK_READ_LATER);
        } else {
            this.addAction(ActionKey.MARK_READ);
        }
        if (!this.item.getNativeItem().isNNTPHeader() && this.actionList.getAction(ActionKey.SHOW_IN_CHECKLIST) != null) {
            this.addAction(ActionKey.SHOW_IN_CHECKLIST);
        }
        this.buildNavigationMenu();
        this.buildMarkThread();
        if (!this.item.getNativeItem().isNNTPHeader() && this.item.canDoInfo()) {
            this.addSeparator();
            this.addAction(ActionKey.ITEM_PROPERTIES);
        }
    }
}

