/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.panelviews;

import com.appframework.components.htmleditor.BrowserType;
import com.appframework.components.htmleditor.GWBrowserFactory;
import com.appframework.components.htmleditor.GWMozillaBrowser;
import com.appframework.components.htmleditor.HTMLTextViewer;
import com.appframework.components.htmleditor.SimpleHTMLViewer;
import com.appframework.listener.ListenerManager;
import com.appframework.listener.ListenerType;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.NetUtils;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.itemview.contentviewer.HTMLViewerHyperlinkListener;
import com.novell.gw.jclient.application.controls.itemview.contentviewer.HTMLViewerStatusbarHyperlinkListener;
import com.novell.gw.jclient.application.controls.itemview.contentviewer.RtfLinkController;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.panelviews.BrowserPanelActionList;
import com.novell.gw.jclient.application.controls.panelviews.BrowserPanelBrowserListener;
import com.novell.gw.jclient.application.controls.panelviews.PanelContent;
import com.novell.gw.jclient.application.controls.panelviews.PanelView;
import com.novell.gw.jclient.application.dialogs.folderproperties.AbstractEditPanelDialog;
import com.novell.gw.jclient.application.options.OptionManager;
import com.webrenderer.swing.event.NetworkAdapter;
import com.webrenderer.swing.event.NetworkEvent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserPanel
extends OrientablePanel
implements MVCView<BrowserPanelActionList, Object>,
PanelContent {
    private static Logger logger = Logger.getLogger(BrowserPanel.class);
    private SimpleHTMLViewer browser;
    private BrowserPanelActionList actionList;
    private PanelView parentPanel = null;

    public BrowserPanel(MVCController parentController, int refreshInterval) {
        if (parentController == null) {
            throw new IllegalArgumentException("parentController is null");
        }
        if (refreshInterval <= 0 && refreshInterval != AbstractEditPanelDialog.UNSET_REFRESH_INTERVAL) {
            throw new IllegalArgumentException("illegal value of refreshInterval: " + refreshInterval);
        }
        this.actionList = new BrowserPanelActionList(this, parentController, refreshInterval);
        if (GWClient.USE_EXTERNAL_HTML_VIEWER()) {
            this.browser = GWBrowserFactory.getBrowser(this.actionList, BrowserType.BROWSER_PANEL);
            this.initExternalBrowser();
        } else {
            this.browser = new HTMLTextViewer();
            ((HTMLTextViewer)this.browser).setBrowserState(true);
            this.initInternalBrowser();
        }
        this.loadProxySettings();
        logger.debug((Object)("JS enabled: " + this.browser.isJavascriptEnabled()));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)((Object)this.browser), c);
    }

    private void initExternalBrowser() {
        GWMozillaBrowser externalBrowser = (GWMozillaBrowser)this.browser;
        this.browser.setLoadPopupWindowInBrowser(true);
        externalBrowser.addBrowserListener(new BrowserPanelBrowserListener());
        ListenerManager listenerManager = ControlsUtils.getListenerManager(this.actionList);
        listenerManager.addListener(externalBrowser, new PageLoadingListener(), ListenerType.NETWORK_LISTENER);
    }

    private void initInternalBrowser() {
        HTMLTextViewer internalBrowser = (HTMLTextViewer)this.browser;
        RtfLinkController rtfLinkController = new RtfLinkController(this.actionList, internalBrowser);
        internalBrowser.addHyperlinkListener(new HTMLViewerHyperlinkListener(internalBrowser));
        internalBrowser.addHyperlinkListener(new HTMLViewerStatusbarHyperlinkListener(this.actionList));
        internalBrowser.addMouseListener(rtfLinkController);
        internalBrowser.addMouseMotionListener(rtfLinkController);
        internalBrowser.addTextComponentPropertyChangeListener("page", new PageLoadingListener());
    }

    public boolean setPage(String url) {
        boolean result = false;
        try {
            URL page = NetUtils.createUrl(url);
            logger.debug((Object)("URL: " + page));
            this.browser.setPage(page);
            result = true;
        }
        catch (MalformedURLException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        return result;
    }

    @Override
    public BrowserPanelActionList getController() {
        return this.actionList;
    }

    @Override
    public void setController(BrowserPanelActionList theController) {
        logger.warn((Object)"setController called, nothing would be done!");
    }

    @Override
    public Object getMVCModel() {
        return null;
    }

    @Override
    public void setMVCModel(Object theModel) {
    }

    public void cleanUp() {
        this.actionList.dispose();
        this.removeAll();
        if (GWClient.USE_EXTERNAL_HTML_VIEWER()) {
            GWBrowserFactory.releaseBrowser((GWMozillaBrowser)this.browser);
        }
        this.browser = null;
    }

    public void reload() {
        logger.debug((Object)"reloading...");
        this.browser.reload();
    }

    public boolean canGoBack() {
        return this.browser.canGoBack();
    }

    public boolean canGoForward() {
        return this.browser.canGoForward();
    }

    public void goBack() {
        logger.debug((Object)"going back...");
        this.browser.goBack();
    }

    public void goForward() {
        logger.debug((Object)"going forward...");
        this.browser.goForward();
    }

    public boolean isJavascriptEnabled() {
        return this.browser.isJavascriptEnabled();
    }

    public void setJavascriptEnabled(boolean enabled) {
        this.browser.setJavascriptEnabled(enabled);
    }

    private void fireDocumentLoaded() {
        logger.debug((Object)"firing BROWSER_PANEL_DOCUMENT_LOADED");
        this.actionList.processCommand(new Command(1760, this));
    }

    private void fireDocumentLoading() {
        logger.debug((Object)"firing BROWSER_PANEL_DOCUMENT_LOADING");
        this.actionList.processCommand(new Command(1761, this));
    }

    void loadProxySettings() {
        this.browser.setProxyConfiguration(OptionManager.getInstance().getEnvironmentOptions().getProxyConfiguration());
        logger.debug((Object)"proxy settings reloaded");
    }

    @Override
    public PanelView getParentPanel() {
        return this.parentPanel;
    }

    @Override
    public void setParentPanel(PanelView parentPanel) {
        this.parentPanel = parentPanel;
    }

    @Override
    public IItemList getItemList() {
        throw new IllegalStateException(this.getClass().getName() + " has no ItemList");
    }

    @Override
    public boolean hasItemList() {
        return false;
    }

    @Override
    public void parentPanelSelected() {
        this.actionList.processCommand(new Command(470, this));
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public void print(boolean showPrintSetupDialog) {
        this.browser.print(showPrintSetupDialog);
    }

    private class PageLoadingListener
    extends NetworkAdapter
    implements PropertyChangeListener {
        private PageLoadingListener() {
        }

        public void onDocumentComplete(NetworkEvent networkEvent) {
            BrowserPanel.this.fireDocumentLoaded();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("page".equals(evt.getPropertyName())) {
                BrowserPanel.this.fireDocumentLoaded();
            }
        }

        public void onDocumentLoad(NetworkEvent event) {
            BrowserPanel.this.fireDocumentLoading();
        }
    }
}

