/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.panelviews;

import com.appframework.ActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.actions.browser.ActionWebPanelGoBack;
import com.novell.gw.jclient.application.actions.browser.ActionWebPanelGoForward;
import com.novell.gw.jclient.application.actions.browser.ActionWebPanelGoToStartPage;
import com.novell.gw.jclient.application.actions.browser.ActionWebPanelReload;
import com.novell.gw.jclient.application.controls.panelviews.BrowserPanel;
import com.novell.gw.jclient.application.dialogs.folderproperties.AbstractEditPanelDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserPanelActionList
extends ActionList<BrowserPanel> {
    private static Logger logger = Logger.getLogger(BrowserPanelActionList.class);
    private Timer timerRefresher;

    public BrowserPanelActionList(BrowserPanel view, MVCController parentController, int refreshInterval) {
        super(view, parentController);
        if (refreshInterval <= 0 && refreshInterval != AbstractEditPanelDialog.UNSET_REFRESH_INTERVAL) {
            throw new IllegalArgumentException("illegal value of refreshInterval: " + refreshInterval);
        }
        if (refreshInterval != AbstractEditPanelDialog.UNSET_REFRESH_INTERVAL) {
            int delay = refreshInterval * 1000 * 60;
            logger.debug((Object)("web page will be refreshed every " + refreshInterval + " minutes"));
            this.timerRefresher = new Timer(delay, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    logger.debug((Object)"refreshing page");
                    ((BrowserPanel)BrowserPanelActionList.this.getMVCView()).reload();
                }
            });
            this.timerRefresher.setRepeats(true);
            this.timerRefresher.start();
        }
        this.createActions();
    }

    private void createActions() {
        this.addAction(new ActionWebPanelGoBack(this));
        this.addAction(new ActionWebPanelGoForward(this));
        this.addAction(new ActionWebPanelReload(this));
        this.addAction(new ActionWebPanelGoToStartPage(this));
    }

    @Override
    protected void initListeners() {
        Level level = this.getFrameLevel();
        RELOAD_WEB_PROXY_OPTIONS_Listener listener = new RELOAD_WEB_PROXY_OPTIONS_Listener();
        AppEventListenerDescriptor descriptor = new AppEventListenerDescriptor(level, 1820, listener);
        this.addListenerDescriptor(descriptor);
    }

    protected void dispose() {
        if (this.timerRefresher != null) {
            this.timerRefresher.stop();
            this.timerRefresher = null;
        }
    }

    private class RELOAD_WEB_PROXY_OPTIONS_Listener
    extends AppEventListener {
        private RELOAD_WEB_PROXY_OPTIONS_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ((BrowserPanel)BrowserPanelActionList.this.getMVCView()).loadProxySettings();
        }
    }
}

