/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.panelviews;

import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.panelviews.MultiPanelViewModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MultiPanelViewModelManager {
    private static Logger logger = Logger.getLogger(MultiPanelViewModelManager.class);
    private static int MAX_SIZE = 20;
    private static MultiPanelViewModelManager instance = null;
    private Map<Integer, MultiPanelViewModel> modelMap = new HashMap<Integer, MultiPanelViewModel>();
    private Map<Integer, Integer> frequencyMap = new HashMap<Integer, Integer>();

    protected MultiPanelViewModelManager() {
    }

    public static MultiPanelViewModelManager getInstance() {
        if (instance == null) {
            instance = new MultiPanelViewModelManager();
        }
        return instance;
    }

    public synchronized MultiPanelViewModel getModel(IFolder folder, String userGuid) {
        if (folder == null) {
            throw new IllegalArgumentException("folder is null");
        }
        if (userGuid == null) {
            throw new IllegalArgumentException("userGuid is null");
        }
        MultiPanelViewModel model = this.get(folder);
        if (model == null) {
            model = new MultiPanelViewModel(folder, userGuid);
            this.put(folder, model);
        }
        assert (model != null) : "model is null";
        return model;
    }

    private MultiPanelViewModel get(IFolder folder) {
        MultiPanelViewModel model = this.modelMap.get(folder.getId());
        if (model != null) {
            int usages = this.frequencyMap.get(folder.getId());
            this.frequencyMap.put(folder.getId(), ++usages);
        }
        return model;
    }

    private void put(IFolder folder, MultiPanelViewModel model) {
        assert (folder != null) : "folder is null";
        assert (model != null) : "model is null";
        if (this.modelMap.size() == MAX_SIZE) {
            logger.debug((Object)"maximal cache size reached > clearing");
            this.removeLFUModel();
        }
        this.modelMap.put(folder.getId(), model);
        this.frequencyMap.put(folder.getId(), 1);
        logger.debug((Object)("adding model for a folder: " + folder));
    }

    private void removeLFUModel() {
        Integer id = null;
        int minValue = Integer.MAX_VALUE;
        Set<Integer> keySet = this.frequencyMap.keySet();
        for (Integer key : keySet) {
            int currentValue = this.frequencyMap.get(key);
            if (currentValue >= minValue) continue;
            minValue = currentValue;
            id = key;
        }
        this.modelMap.remove(id);
        this.frequencyMap.remove(id);
    }

    public synchronized void removeModel(IFolder folder) {
        this.modelMap.remove(folder.getId());
        this.frequencyMap.remove(folder.getId());
    }

    public synchronized void clear() {
        this.modelMap.clear();
        this.frequencyMap.clear();
    }
}

