/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.popedit;

import com.appframework.utils.OS;
import com.novell.gw.ab.AddressBookManager;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.ExtendedGWTable;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class DisambiguationDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger(DisambiguationDialog.class);
    private ContactTableModel contactTableModel;
    private ExtendedGWTable tableContacts;
    private AbstractAction editAction = new EditAction();
    private AbstractAction deleteAction = new DeleteAction();
    private static boolean isActive;

    public DisambiguationDialog(JFrame owner, List theItemList) throws HeadlessException {
        super(owner);
        this.init(theItemList);
    }

    public DisambiguationDialog(JDialog owner, List theItemList) throws HeadlessException {
        super(owner);
        this.init(theItemList);
    }

    private void init(List theItemList) {
        this.setTitle(StringResources.SELECT_AN_ENTRY);
        this.contactTableModel = new ContactTableModel(theItemList);
        this.buildUI();
    }

    private void buildUI() {
        this.tableContacts = new ExtendedGWTable(this.contactTableModel);
        JPanel pnlContent = (JPanel)this.getContentPane();
        pnlContent.setLayout(new BorderLayout(10, 5));
        pnlContent.add((Component)new OrientableLabel(StringResources.SELECT_ONE), "North");
        pnlContent.add((Component)new ColoredScrollPane(this.tableContacts), "Center");
        OrientablePanel pnlButtons = new OrientablePanel(new GridLayout(0, 1, 0, 5));
        pnlButtons.add(this.btnOK);
        pnlButtons.add(this.btnCancel);
        pnlButtons.add(new OrientableButton(this.editAction));
        pnlButtons.add(new OrientableButton(this.deleteAction));
        OrientablePanel pnlTemp = new OrientablePanel(new BorderLayout());
        pnlTemp.add((Component)pnlButtons, "North");
        pnlContent.add((Component)pnlTemp, "After");
        pnlContent.setPreferredSize(new Dimension(570, 240));
        pnlContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 20, 10));
        this.tableContacts.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (OS.isDoubleClick(e)) {
                    DisambiguationDialog.this.btnOK.doClick();
                }
            }
        });
        this.tableContacts.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DisambiguationDialog.this.btnOK.doClick();
                } else if (e.getKeyCode() == OptionManager.getInstance().getGeneralOptions().getItemDeleteKey()) {
                    DisambiguationDialog.this.deleteAction.actionPerformed(null);
                }
            }
        });
        this.tableContacts.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DisambiguationDialog.this.processSelection();
            }
        });
        if (this.tableContacts.getRowCount() > 0) {
            this.tableContacts.setRowSelectionInterval(0, 0);
        }
    }

    private void processSelection() {
        int selectedRow = this.tableContacts.getSelectedRow();
        boolean b = selectedRow == -1;
        this.btnOK.setEnabled(!b);
        this.editAction.setEnabled(!b && this.tableContacts.getSelectedRowCount() == 1);
    }

    public IContact getSelectedContact() {
        int selectedRow = this.tableContacts.getSelectedRow();
        return selectedRow == -1 ? null : this.contactTableModel.getItemList().get(selectedRow);
    }

    public List getSelectedContacts() {
        ArrayList result = new ArrayList();
        int[] selectedRows = this.tableContacts.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            int selectedRow = selectedRows[i];
            result.add(this.contactTableModel.getItemList().get(selectedRow));
        }
        return result;
    }

    public void setVisible(boolean b) {
        isActive = b;
        super.setVisible(b);
        isActive = false;
    }

    public static boolean isOneVisibled() {
        return isActive;
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(StringResources.DELETE);
        }

        public void actionPerformed(ActionEvent e) {
            List contacts = DisambiguationDialog.this.getSelectedContacts();
            try {
                boolean b = GWEngineUtils.deleteContacts(contacts, DisambiguationDialog.this);
                if (b) {
                    int nSize = contacts.size();
                    for (int i = 0; i < nSize; ++i) {
                        IContact contact = (IContact)contacts.get(i);
                        DisambiguationDialog.this.contactTableModel.deleteContact(contact);
                        if (DisambiguationDialog.this.contactTableModel.getRowCount() != 0) continue;
                        this.setEnabled(false);
                    }
                }
            }
            catch (EngineException e1) {
                logger.error((Object)e1);
            }
        }
    }

    private class EditAction
    extends AbstractAction {
        public EditAction() {
            super(StringResources.EDIT);
        }

        public void actionPerformed(ActionEvent e) {
            IContact selectedContact = DisambiguationDialog.this.getSelectedContact();
            ContactDetailsDialog dialog = ContactDetailsDialog.createContactDetailsDialog((Window)DisambiguationDialog.this, selectedContact, null);
            dialog.showMe();
        }
    }

    private static class ContactTableModel
    extends AbstractTableModel {
        public final int[] columnsIDS = new int[]{3, 9};
        private List contactsList;

        public ContactTableModel(List contactsList) {
            this.contactsList = contactsList;
        }

        public String getColumnName(int column) {
            return AddressBookManager.getPropertyLabel((int)this.columnsIDS[column]);
        }

        public int getRowCount() {
            return this.contactsList.size();
        }

        public int getColumnCount() {
            return this.columnsIDS.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            String value = ((IContact)this.contactsList.get(rowIndex)).getStringValue(this.columnsIDS[columnIndex]);
            return value == null ? "" : value;
        }

        public List getItemList() {
            return Collections.unmodifiableList(this.contactsList);
        }

        public void deleteContact(IContact contact) {
            int i = this.contactsList.indexOf(contact);
            if (i != -1) {
                this.contactsList.remove(contact);
                this.fireTableRowsDeleted(i, i);
            }
        }
    }
}

