/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.ext;

import com.appframework.components.GWBorder;
import com.appframework.resources.ImageResources;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ext.ChevronLayout;
import com.novell.gw.jclient.application.controls.toolbars.ext.ChevronPopupMenu;
import com.novell.gw.jclient.application.controls.toolbars.ext.Chevronable;
import com.novell.gw.jclient.application.controls.toolbars.ext.MultilineToolBarLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ChevronToolbar
extends SkinnableToolBar
implements Chevronable {
    private AbstractButton btnChevron;
    private ChevronPopupMenu pmChevron;
    private boolean isPopupVisible = false;
    protected ChevronToolbarLayout chevronLayout;
    private MultilineToolBarLayout multilineLayout;

    public ChevronToolbar() {
        this(2, 2);
    }

    public ChevronToolbar(int hgap, int vgap) {
        this.setOpaque(false);
        this.setRollover(true);
        this.setFloatable(false);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.btnChevron = new ChevronButton();
        this.btnChevron.addMouseListener(new ChevronButtonMouseListener());
        this.pmChevron = new ChevronPopupMenu();
        this.pmChevron.addPopupMenuListener(new ChevronPopupMenuListener());
        this.chevronLayout = new ChevronToolbarLayout(this, hgap, vgap);
        this.multilineLayout = new MultilineToolBarLayout();
        this.setLayout(this.chevronLayout);
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    public ChevronToolbarLayout getChevronLayout() {
        return this.chevronLayout;
    }

    public MultilineToolBarLayout getMultilineLayout() {
        return this.multilineLayout;
    }

    public JComponent getChevron() {
        return this.btnChevron;
    }

    public void setLayout(LayoutManager mgr) {
        super.setLayout(mgr);
        if (mgr instanceof MultilineToolBarLayout) {
            this.remove(this.getChevron());
        } else if (mgr instanceof ChevronLayout && this.isPreferredSizeSet()) {
            this.setPreferredSize(this.getLayout().preferredLayoutSize(this));
        }
    }

    protected class ChevronToolbarLayout
    extends ChevronLayout {
        public ChevronToolbarLayout(ChevronToolbar theSource, int hgap, int vgap) {
            super(theSource, hgap, vgap);
        }

        protected void componentsStateChanged(Set theInvisibleComponents) {
            ChevronToolbar.this.pmChevron.rebuild(theInvisibleComponents);
        }

        protected boolean resizeVertical(Component theComponent) {
            return theComponent instanceof JSeparator;
        }
    }

    private class ChevronPopupMenuListener
    implements PopupMenuListener {
        private ChevronPopupMenuListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            ChevronToolbar.this.isPopupVisible = true;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            ChevronToolbar.this.isPopupVisible = false;
            ChevronToolbar.this.btnChevron.setBorder(GWBorder.NO_BORDER);
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            ChevronToolbar.this.isPopupVisible = false;
            ChevronToolbar.this.btnChevron.setBorder(GWBorder.NO_BORDER);
        }
    }

    private class ChevronButtonMouseListener
    extends MouseAdapter {
        private ChevronButtonMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            AbstractButton btnChevron = ChevronToolbar.this.btnChevron;
            btnChevron.getModel().setArmed(false);
            btnChevron.setBorder(GWBorder.LOWERED_BORDER);
            ChevronToolbar.this.pmChevron.show(btnChevron, 0, btnChevron.getHeight());
        }

        public void mouseReleased(MouseEvent e) {
            if (!ChevronToolbar.this.isPopupVisible) {
                ChevronToolbar.this.btnChevron.setBorder(GWBorder.RAISED_BORDER);
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (!ChevronToolbar.this.isPopupVisible) {
                ChevronToolbar.this.btnChevron.setBorder(GWBorder.RAISED_BORDER);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!ChevronToolbar.this.isPopupVisible) {
                ChevronToolbar.this.btnChevron.setBorder(GWBorder.NO_BORDER);
            }
        }
    }

    private static class ChevronButton
    extends JButton {
        public ChevronButton() {
            ImageIcon chevronIcon = ImageResources.ARROW_MORE;
            this.setOpaque(false);
            this.setIcon(chevronIcon);
            this.setBorder(null);
            this.setFocusable(false);
            this.getModel().setArmed(false);
        }
    }
}

