/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.ext;

import com.novell.gw.jclient.application.controls.toolbars.ext.DropablePanel;
import com.novell.gw.jclient.application.controls.toolbars.ext.ResizableToolbar;
import com.novell.gw.jclient.application.controls.toolbars.ext.ToolBarUtils;
import com.novell.gw.jclient.application.controls.toolbars.ext.ToolBarsLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DropableToolBarsPanel
extends DropablePanel {
    private static Logger logger = Logger.getLogger(DropableToolBarsPanel.class);
    JComponent lastDraggedComponent;

    public DropableToolBarsPanel() {
        this(0, 0);
    }

    public DropableToolBarsPanel(int hGap, int vGap) {
        this.setLayout(new ToolBarsLayout(hGap, vGap));
    }

    public void processComponentDragOver(JComponent theComponent, Point theOldMouseLocation, Point theNewMouseLocation) {
        if (theComponent instanceof ResizableToolbar) {
            this.checkToolbarAdded((ResizableToolbar)theComponent, theNewMouseLocation.x);
            int shiftX = theNewMouseLocation.x - theComponent.getX();
            ToolBarUtils.processToolbarResizing((ResizableToolbar)theComponent, shiftX);
            ToolBarUtils.processToolbarMoving(theComponent, theNewMouseLocation);
        }
        this.lastDraggedComponent = theComponent;
    }

    public void dragExit(DropTargetEvent e) {
        if (this.lastDraggedComponent == null) {
            return;
        }
        Container parent = this.lastDraggedComponent.getParent();
        if (parent instanceof DropableToolBarsPanel) {
            Point newPoint = new Point(this.lastMouseLocation);
            ((DropableToolBarsPanel)parent).processComponentDragExit(this.lastDraggedComponent, newPoint);
        }
    }

    public void processComponentDrop(JComponent theComponent, Point theLocation) {
    }

    public void processComponentDragExit(JComponent theComponent, Point theLocation) {
        if (theComponent instanceof ResizableToolbar) {
            int left = theLocation.x;
            int right = this.getWidth() - theLocation.x;
            int top = theLocation.y;
            int bottom = this.getHeight() - theLocation.y;
            if (bottom == ToolBarUtils.min(left, right, top, bottom) && ToolBarUtils.getVisibleComponentsCount(this) > 1) {
                if (ToolBarUtils.isLastVisible(this)) {
                    DropableToolBarsPanel newToolbar = this.getNewToolBarPanel();
                    this.getParent().add(newToolbar);
                    this.checkToolbarAdded((ResizableToolbar)theComponent, newToolbar);
                } else {
                    Component nextToolBarPanel = ToolBarUtils.getNextVisible(this.getParent(), this);
                    if (ToolBarUtils.getVisibleComponentsCount((Container)nextToolBarPanel) == 0) {
                        this.checkToolbarAdded((ResizableToolbar)theComponent, (DropableToolBarsPanel)nextToolBarPanel);
                    }
                }
            } else if (top == ToolBarUtils.min(left, right, top, bottom) && ToolBarUtils.getVisibleComponentsCount(this) > 1) {
                if (ToolBarUtils.isFirstVisible(this)) {
                    DropableToolBarsPanel newToolbar = this.getNewToolBarPanel();
                    this.getParent().add((Component)newToolbar, 0);
                    this.checkToolbarAdded((ResizableToolbar)theComponent, newToolbar);
                } else {
                    Component previousToolBarPanel = ToolBarUtils.getPreviousVisible(this.getParent(), this);
                    if (ToolBarUtils.getVisibleComponentsCount((Container)previousToolBarPanel) == 0) {
                        this.checkToolbarAdded((ResizableToolbar)theComponent, (DropableToolBarsPanel)previousToolBarPanel);
                    }
                }
            }
        }
    }

    private DropableToolBarsPanel getNewToolBarPanel() {
        DropableToolBarsPanel newToolbar = new DropableToolBarsPanel(0, 0);
        newToolbar.setBackground(this.getBackground());
        return newToolbar;
    }

    private void checkToolbarAdded(ResizableToolbar theToolbar, DropableToolBarsPanel theNewParent, int theXLocation) {
        Container oldParent = theToolbar.getParent();
        if (oldParent != null && oldParent != theNewParent) {
            Component componentBelow;
            oldParent.remove(theToolbar);
            int index = -1;
            if (theXLocation > 0 && (componentBelow = theNewParent.getComponentAt(new Point(theXLocation, theNewParent.getHeight() / 2))) != null) {
                index = ToolBarUtils.indexOf(componentBelow) + 1;
            }
            theNewParent.add((Component)theToolbar, index);
            if (oldParent.getComponentCount() == 0) {
                Container parent = oldParent.getParent();
                parent.remove(oldParent);
            }
            SwingUtilities.getWindowAncestor(this).validate();
        }
    }

    private void checkToolbarAdded(ResizableToolbar theToolbar, DropableToolBarsPanel theNewParent) {
        this.checkToolbarAdded(theToolbar, theNewParent, -1);
    }

    private void checkToolbarAdded(ResizableToolbar theToolbar, int theXLocation) {
        this.checkToolbarAdded(theToolbar, this, -1);
    }

    protected boolean isDragAcceptable(DataFlavor[] supportedDataFlavors, Transferable transferable) {
        Object transferData;
        boolean acceptable = super.isDragAcceptable(supportedDataFlavors, transferable);
        if (acceptable && (transferData = this.getTransferData(supportedDataFlavors, transferable)) instanceof JComponent) {
            JComponent component = (JComponent)transferData;
            JComponent parent = (JComponent)component.getParent();
            if (this.equals(parent)) {
                acceptable = true;
            } else if (parent == null) {
                logger.warn((Object)"parent of dragged component is null");
                acceptable = false;
            } else {
                Container grandParent = parent.getParent();
                Container thisParent = this.getParent();
                if (grandParent == null || thisParent == null) {
                    logger.warn((Object)"grand parent of dragged component or this parent is null");
                    acceptable = false;
                } else {
                    acceptable = thisParent == grandParent;
                }
            }
        }
        return acceptable;
    }
}

