/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.ext;

import com.appframework.components.customizedbutton.ToolBarToggleButton;
import com.novell.gw.jclient.application.controls.toolbars.ext.StoredComponent;
import com.novell.gw.jclient.application.controls.toolbars.ext.SuperButton;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public class ExToolBar
extends JToolBar {
    protected SuperButton superButton = ExToolBar.createSuperButton();

    public ExToolBar() {
        this.addComponentListener(new ToolBarComponentListener());
    }

    protected static SuperButton createSuperButton() {
        return new SuperButton();
    }

    public ExToolBar(LayoutManager layoutManager) {
        this();
        this.setLayout(layoutManager);
    }

    public Component add(Component comp) {
        if (comp instanceof ToolBarToggleButton) {
            ToolBarToggleButton button = (ToolBarToggleButton)comp;
            Border border = button.getBorder();
            Component component = super.add(button);
            button.setBorder(border);
            return component;
        }
        return super.add(comp);
    }

    public Component add(Component comp, int index) {
        if (comp instanceof ToolBarToggleButton) {
            ToolBarToggleButton button = (ToolBarToggleButton)comp;
            Border border = button.getBorder();
            Component component = super.add((Component)button, index);
            button.setBorder(border);
            return component;
        }
        return super.add(comp, index);
    }

    public void updateSuperButton() {
        StoredComponent comp;
        boolean needUpdate = false;
        Insets insets = this.getInsets();
        int currentWidth = this.getWidth() - insets.left - insets.right;
        Insets margine = this.getMargin();
        int margin = margine.left + margine.right;
        ArrayList<Component> invisibleComponents = new ArrayList<Component>();
        int minWidth = 0;
        boolean saved = false;
        int nCount = this.getComponentCount();
        for (int i = 0; i < nCount; ++i) {
            Component component = this.getComponentAtIndex(i);
            if (saved || currentWidth >= (minWidth += (int)component.getPreferredSize().getWidth() + margin)) continue;
            for (int j = this.getComponentCount() - 1; j >= i; --j) {
                component = this.getComponentAtIndex(j);
                if (component == this.superButton) {
                    Component componentBefore = this.getComponentAtIndex(j - 1);
                    invisibleComponents.add(componentBefore);
                    continue;
                }
                invisibleComponents.add(component);
            }
            saved = true;
        }
        int nSize = invisibleComponents.size();
        for (int i = 0; i < nSize; ++i) {
            Component component = (Component)invisibleComponents.get(i);
            if (component instanceof JLabel && ((JLabel)component).getText().trim().length() == 0) continue;
            StoredComponent storedComponent = new StoredComponent(component, this.getComponentIndex(component), component.getSize());
            this.superButton.addStored(storedComponent);
            this.remove(component);
            needUpdate = true;
        }
        while (minWidth <= currentWidth && (comp = this.superButton.getLastStored()) != null) {
            if ((minWidth += (int)comp.getDim().getWidth()) > currentWidth) continue;
            this.add(comp.getComponent(), comp.getIndex());
            this.superButton.removeLastStored();
            needUpdate = true;
        }
        if (this.superButton.getStoredCount() <= 0) {
            if (this.getComponentIndex(this.superButton) > 0) {
                this.remove(this.superButton);
                needUpdate = true;
            }
        } else if (this.getComponentIndex(this.superButton) < 0) {
            this.add(this.superButton);
            needUpdate = true;
        }
        if (needUpdate) {
            this.validate();
        }
    }

    public SuperButton getSuperButton() {
        return this.superButton;
    }

    private class ToolBarComponentListener
    implements ComponentListener {
        private ToolBarComponentListener() {
        }

        public void componentResized(ComponentEvent e) {
            ExToolBar.this.updateSuperButton();
        }

        public void componentMoved(ComponentEvent e) {
            ExToolBar.this.updateSuperButton();
        }

        public void componentShown(ComponentEvent e) {
            ExToolBar.this.updateSuperButton();
        }

        public void componentHidden(ComponentEvent e) {
        }
    }
}

