/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.navigation;

import com.appframework.resources.ImageResources;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.skinnable.ComponentProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinnablePanel;
import com.novell.gw.jclient.application.controls.toolbars.ext.ChevronLayout;
import com.novell.gw.jclient.application.controls.toolbars.ext.ChevronPopupMenu;
import com.novell.gw.jclient.application.controls.toolbars.ext.Chevronable;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarButton;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarChevronPopupMenu;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ChevronPanel
extends SkinnablePanel
implements Chevronable {
    private ChevronButton btnChevron;
    private ChevronPopupMenu pmChevron;
    private boolean isPopupVisible = false;
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);

    public ChevronPanel() {
        this(2, 2, null);
    }

    public ChevronPanel(int hgap, int vgap, NavBarPanel master) {
        this.skinnableDelegate.clearPropertyBindings();
        this.skinnableDelegate.putSkinProperty(SkinProperty.BACKGROUND_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.BACK_TOP_END_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEL_END_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEL_START_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HILITE_END_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HILITE_START_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HILITE_BORDER_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEL_BORDER_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.TOOLBAR_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HIGHLIGHTED_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.setOpaque(false);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.btnChevron = new ChevronButton(master);
        this.btnChevron.addMouseListener(new ChevronButtonMouseListener());
        this.pmChevron = new NavBarChevronPopupMenu(master);
        this.pmChevron.addPopupMenuListener(new ChevronPopupMenuListener());
        this.setLayout(new ChevronPanelLayout(this, hgap, vgap));
    }

    public Insets getInsets() {
        return ZERO_INSETS;
    }

    public JComponent getChevron() {
        return this.btnChevron;
    }

    private class ChevronPanelLayout
    extends ChevronLayout {
        public ChevronPanelLayout(ChevronPanel theSource, int hgap, int vgap) {
            super(theSource, hgap, vgap);
        }

        protected void componentsStateChanged(Set theInvisibleComponents) {
            ChevronPanel.this.pmChevron.rebuild(theInvisibleComponents);
        }

        protected boolean resizeVertical(Component theComponent) {
            return theComponent != ChevronPanel.this.btnChevron;
        }
    }

    private class ChevronPopupMenuListener
    implements PopupMenuListener {
        private ChevronPopupMenuListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            ChevronPanel.this.isPopupVisible = true;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            ChevronPanel.this.isPopupVisible = false;
            ChevronPanel.this.btnChevron.getModel().setSelected(false);
            ChevronPanel.this.btnChevron.repaint();
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            ChevronPanel.this.isPopupVisible = false;
            ChevronPanel.this.btnChevron.getModel().setSelected(false);
            ChevronPanel.this.btnChevron.repaint();
        }
    }

    private class ChevronButtonMouseListener
    extends MouseAdapter {
        private ChevronButtonMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            ((ChevronPanel)ChevronPanel.this).btnChevron.mousePressed = true;
            ((ChevronPanel)ChevronPanel.this).btnChevron.mouseReleased = false;
            ChevronPanel.this.isPopupVisible = false;
            ChevronPanel.this.btnChevron.getModel().setSelected(true);
            ChevronPanel.this.btnChevron.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            ((ChevronPanel)ChevronPanel.this).btnChevron.mousePressed = false;
            ((ChevronPanel)ChevronPanel.this).btnChevron.mouseReleased = true;
            ChevronPanel.this.btnChevron.getModel().setSelected(false);
            if (((ChevronPanel)ChevronPanel.this).btnChevron.mouseEntered) {
                ChevronPanel.this.pmChevron.show(ChevronPanel.this.btnChevron, 0, ChevronPanel.this.btnChevron.getHeight());
                ChevronPanel.this.isPopupVisible = true;
            }
        }

        private boolean isMuseButtonPressed(MouseEvent me) {
            return me != null && (SwingUtilities.isLeftMouseButton(me) || SwingUtilities.isRightMouseButton(me) || SwingUtilities.isMiddleMouseButton(me));
        }

        public void mouseEntered(MouseEvent e) {
            ((ChevronPanel)ChevronPanel.this).btnChevron.mouseEntered = true;
            ((ChevronPanel)ChevronPanel.this).btnChevron.mouseExited = false;
            ((ChevronPanel)ChevronPanel.this).btnChevron.mousePressed = e.getButton() != 0 || this.isMuseButtonPressed(e);
        }

        public void mouseExited(MouseEvent e) {
            ((ChevronPanel)ChevronPanel.this).btnChevron.mouseEntered = false;
            ((ChevronPanel)ChevronPanel.this).btnChevron.mouseExited = true;
            ((ChevronPanel)ChevronPanel.this).btnChevron.mousePressed = false;
        }
    }

    public class ChevronButton
    extends NavBarButton {
        boolean mouseReleased;
        boolean mousePressed;
        boolean mouseEntered;
        boolean mouseExited;

        public ChevronButton(NavBarPanel master) {
            super(ImageResources.ARROW_MORE, master);
            this.mouseReleased = false;
            this.mousePressed = false;
            this.mouseEntered = false;
            this.mouseExited = true;
            ImageIcon chevronIcon = ImageResources.ARROW_MORE;
            this.setContentAreaFilled(false);
            this.setOpaque(false);
            this.setIcon(chevronIcon);
            this.setBorder(null);
            this.setFocusable(false);
            this.getModel().setArmed(false);
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void paint(Graphics g) {
            Graphics2D g2D = (Graphics2D)UIUtils.enableAntialiasing(g);
            Color highSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.BACK_TOP_END_COLOR);
            Color highSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.BACKGROUND_COLOR);
            Color lowSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.BACK_TOP_END_COLOR);
            Color lowSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.BACKGROUND_COLOR);
            Color textColor = (Color)this.getClientProperty((Object)SkinProperty.HIGHLIGHTED_TEXT_COLOR);
            Color borderColor = null;
            boolean paintSegments = true;
            if (ChevronPanel.this.isPopupVisible || this.mouseExited) {
                paintSegments = false;
            } else if (this.mouseEntered) {
                if (this.mousePressed) {
                    highSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.SEL_START_COLOR);
                    highSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.SEL_END_COLOR);
                    lowSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.SEL_START_COLOR);
                    lowSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.SEL_END_COLOR);
                    textColor = (Color)this.getClientProperty((Object)SkinProperty.TOOLBAR_TEXT_COLOR);
                    borderColor = (Color)this.getClientProperty((Object)SkinProperty.SEL_BORDER_COLOR);
                } else {
                    highSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.HILITE_START_COLOR);
                    highSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.HILITE_END_COLOR);
                    lowSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.HILITE_START_COLOR);
                    lowSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.HILITE_END_COLOR);
                    textColor = (Color)this.getClientProperty((Object)SkinProperty.HIGHLIGHTED_TEXT_COLOR);
                    borderColor = (Color)this.getClientProperty((Object)SkinProperty.HILITE_BORDER_COLOR);
                }
            }
            if (paintSegments) {
                int w = this.getPreferredSize().width - 1;
                int h = this.getSize().height;
                GeneralPath border = new GeneralPath();
                border.moveTo(4.0f, 1.0f);
                border.lineTo(3.0f, 1.0f);
                border.lineTo(1.0f, 3.0f);
                border.lineTo(1.0f, 4.0f);
                border.lineTo(0.0f, 5.0f);
                border.lineTo(0.0f, h - 6);
                border.lineTo(1.0f, h - 5);
                border.lineTo(1.0f, h - 4);
                border.lineTo(3.0f, h - 2);
                border.lineTo(4.0f, h - 2);
                border.lineTo(5.0f, h - 1);
                border.lineTo(w - 6, h - 1);
                border.lineTo(w - 5, h - 2);
                border.lineTo(w - 4, h - 2);
                border.lineTo(w - 2, h - 4);
                border.lineTo(w - 2, h - 5);
                border.lineTo(w - 1, h - 6);
                border.lineTo(w - 1, 5.0f);
                border.lineTo(w - 2, 4.0f);
                border.lineTo(w - 2, 3.0f);
                border.lineTo(w - 4, 1.0f);
                border.lineTo(w - 5, 1.0f);
                border.lineTo(w - 6, 0.0f);
                border.lineTo(5.0f, 0.0f);
                GradientPaint paintHigherSegment = new GradientPaint(0.0f, 0.0f, highSegmentColorFrom, 0.0f, (int)((double)this.getHeight() * 0.3), highSegmentColorTo);
                g2D.setPaint(paintHigherSegment);
                g2D.fill(border);
                GradientPaint paintLowerSegment = new GradientPaint(0.0f, (int)((double)this.getHeight() * 0.3), lowSegmentColorFrom, 0.0f, this.getHeight(), lowSegmentColorTo);
                g2D.setPaint(paintLowerSegment);
                g2D.fill(border);
                if (borderColor != null) {
                    g2D.setColor(borderColor);
                    g2D.draw(border);
                }
            }
            g2D.setColor(textColor);
            g2D.setFont(this.masterPanel.getFont());
            if (this.getText() != null) {
                g2D.drawString(this.getText(), this.getInsets().left, this.getHeight() - this.getInsets().bottom - this.getFontMetrics(g2D.getFont()).getDescent());
            }
            if (this.getIcon() != null) {
                Dimension btnSize = this.getSize();
                int iw = this.getIcon().getIconWidth();
                int ih = this.getIcon().getIconHeight();
                g2D.drawImage(((ImageIcon)this.getIcon()).getImage(), (btnSize.width - iw) / 2, (btnSize.height - ih) / 2, this);
            }
        }
    }
}

