/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.navigation;

import com.appframework.ApplicationFrame;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.DnDUtils;
import com.novell.gw.jclient.application.controls.toolbars.navigation.InsertPosition;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarButton;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarButtonTransferData;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarButtonTransferable;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarPanel;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

class NavBarDropTargetListener
implements DropTargetListener {
    private static Logger logger = Logger.getLogger(NavBarPanel.class);
    private NavBarPanel navBarPanel;

    public NavBarDropTargetListener(NavBarPanel navBarPanel) {
        if (navBarPanel == null) {
            throw new IllegalArgumentException("navBarPanel is null");
        }
        this.navBarPanel = navBarPanel;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        this.dragOver(dtde);
    }

    public void dragExit(DropTargetEvent dte) {
        this.navBarPanel.adjustIndicatorPainterLocation(null);
        this.navBarPanel.setReorderingFolderButtonsMode(false);
    }

    public void dragOver(DropTargetDragEvent dtde) {
        Point location = dtde.getLocation();
        NavBarButton button = this.navBarPanel.getFolderButtonAt(location);
        boolean acceptDrag = this.verifyDragFromFoldersTree(dtde);
        if (button != null && !acceptDrag) {
            acceptDrag = this.verifyDragOverFolderButton(dtde, button);
        }
        if (!acceptDrag) {
            acceptDrag = this.verifyDragOverPanel(dtde);
        }
        if (acceptDrag) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        this.navBarPanel.adjustIndicatorPainterLocation(null);
        if (dtde.isDataFlavorSupported(GWFlavors.folderFlavor) && this.verifyDropFromFoldersTree(dtde)) {
            this.processDropFromFoldersTree(dtde);
        } else {
            Point location = dtde.getLocation();
            NavBarButton button = this.navBarPanel.getFolderButtonAt(location);
            if (dtde.getTransferable().isDataFlavorSupported(GWFlavors.transferItemsFlavor) && button != null) {
                this.processDropOnFolderButton(dtde, button);
            } else {
                this.processDropOnPanel(dtde);
            }
        }
        this.navBarPanel.setReorderingFolderButtonsMode(false);
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        this.dragOver(dtde);
    }

    private boolean verifyDragOverFolderButton(DropTargetDragEvent dtde, NavBarButton button) {
        AbstractFolder folder = this.navBarPanel.getFolder(button);
        if (GWClient.getActiveFrame() == null) {
            return false;
        }
        if (!DnDUtils.isDropOnFolderAllowed(folder, dtde.getTransferable(), GWClient.getActiveFrame().getController())) {
            return false;
        }
        return dtde.getTransferable().isDataFlavorSupported(GWFlavors.transferItemsFlavor);
    }

    private boolean verifyDragOverPanel(DropTargetDragEvent dtde) {
        boolean acceptDrag = dtde.getTransferable().isDataFlavorSupported(NavBarButtonTransferable.navBarButtonFlavor);
        if (acceptDrag) {
            NavBarButtonTransferData transferData = NavBarDropTargetListener.getTransferData(dtde.getTransferable());
            String sourceFrameId = transferData.getFrameId();
            acceptDrag = sourceFrameId.equals(this.getFrameId());
        }
        this.navBarPanel.setReorderingFolderButtonsMode(acceptDrag);
        this.navBarPanel.adjustIndicatorPainterLocation(acceptDrag ? dtde.getLocation() : null);
        if (acceptDrag) {
            this.navBarPanel.repaintIndicatorPainter();
        }
        return acceptDrag;
    }

    public boolean verifyDragFromFoldersTree(DropTargetDragEvent dtde) {
        boolean acceptDrag = false;
        try {
            String id;
            if (dtde.isDataFlavorSupported(GWFlavors.folderFlavor) && (id = (String)dtde.getTransferable().getTransferData(GWFlavors.folderFlavor)) != null && this.findFolder(id) != null) {
                acceptDrag = true;
            }
        }
        catch (UnsupportedFlavorException e) {
            logger.debug((Object)e);
            logger.error((Object)e);
        }
        catch (IOException e) {
            logger.debug((Object)e);
            logger.error((Object)e);
        }
        this.navBarPanel.setReorderingFolderButtonsMode(acceptDrag);
        this.navBarPanel.adjustIndicatorPainterLocation(acceptDrag ? dtde.getLocation() : null);
        if (acceptDrag) {
            this.navBarPanel.repaintIndicatorPainter();
        }
        return acceptDrag;
    }

    public boolean verifyDropFromFoldersTree(DropTargetDropEvent dtde) {
        if (!dtde.isDataFlavorSupported(GWFlavors.folderFlavor)) {
            return false;
        }
        try {
            String id = (String)dtde.getTransferable().getTransferData(GWFlavors.folderFlavor);
            if (id != null && this.findFolder(id) != null) {
                return true;
            }
        }
        catch (UnsupportedFlavorException e) {
            logger.debug((Object)e);
            logger.error((Object)e);
        }
        catch (IOException e) {
            logger.debug((Object)e);
            logger.error((Object)e);
        }
        return false;
    }

    private void processDropOnFolderButton(DropTargetDropEvent dtde, NavBarButton button) {
        AbstractFolder targetFolder = this.navBarPanel.getFolder(button);
        boolean transferSucceeded = DnDUtils.performTransferToFolder(dtde, targetFolder, GWClient.getActiveFrame().getController());
        logger.debug((Object)("transferSucceeded: " + transferSucceeded));
        dtde.dropComplete(transferSucceeded);
    }

    private void processDropOnPanel(DropTargetDropEvent dtde) {
        InsertPosition insertPositon = this.navBarPanel.getFolderButtonInsertPosition(dtde.getLocation());
        if (insertPositon == null) {
            logger.info((Object)"insertPositon is null > drop failed");
            dtde.dropComplete(false);
            return;
        }
        String folderId = NavBarDropTargetListener.getTransferData(dtde.getTransferable()).getFolderId();
        if (folderId == null) {
            logger.info((Object)"folderId is null > drop failed");
            dtde.dropComplete(false);
            return;
        }
        boolean result = this.navBarPanel.moveFolderToPosition(folderId, insertPositon);
        logger.debug((Object)("success: " + result));
        dtde.dropComplete(result);
    }

    private void processDropFromFoldersTree(DropTargetDropEvent dtde) {
        try {
            String id = (String)dtde.getTransferable().getTransferData(GWFlavors.folderFlavor);
            AbstractFolder folder = this.findFolder(id);
            if (folder != null) {
                InsertPosition insertPosition = this.navBarPanel.getFolderButtonInsertPosition(dtde.getLocation());
                if (insertPosition == null) {
                    logger.info((Object)"insertPositon is null > drop failed");
                    dtde.dropComplete(false);
                    return;
                }
                if (!this.navBarPanel.getNavBarModel().getVisibleFolderList().contains(folder)) {
                    this.navBarPanel.getNavBarModel().setFolderVisible(folder, true);
                }
                this.navBarPanel.moveFolderToPosition(String.valueOf(id), insertPosition);
                dtde.dropComplete(true);
                return;
            }
        }
        catch (UnsupportedFlavorException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        dtde.dropComplete(false);
    }

    private static NavBarButtonTransferData getTransferData(Transferable transferable) {
        NavBarButtonTransferData data = null;
        try {
            data = (NavBarButtonTransferData)transferable.getTransferData(NavBarButtonTransferable.navBarButtonFlavor);
        }
        catch (UnsupportedFlavorException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        if (data == null) {
            logger.warn((Object)"transfer data is null");
        }
        return data;
    }

    private String getFrameId() {
        String id = null;
        if (this.navBarPanel.getTopLevelAncestor() instanceof ApplicationFrame) {
            id = ((ApplicationFrame)this.navBarPanel.getTopLevelAncestor()).getID();
        } else {
            logger.warn((Object)("problem with top level ancestor: " + this.navBarPanel.getTopLevelAncestor()));
        }
        return id;
    }

    private AbstractFolder findFolder(String id) {
        List<AbstractFolder> folderList = this.navBarPanel.getNavBarModel().getFolderList();
        int nSize = folderList.size();
        for (int i = 0; i < nSize; ++i) {
            if (!folderList.get(i).getID().equals(id)) continue;
            return folderList.get(i);
        }
        return null;
    }
}

