/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs;

import com.appframework.ApplicationFrame;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.options.DateTimeOptions;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public class AboutDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger(AboutDialog.class);
    private JLabel imageLabel;
    private String infoAboutVertion = "";

    public AboutDialog() {
        this((ApplicationFrame)null);
    }

    public AboutDialog(ApplicationFrame parentFrame) {
        super(parentFrame);
        this.setTitle(StringResources.ABOUT_NOVELL_GROUPWISE_CLIENT);
        this.getContentPane().removeAll();
        String userGuid = parentFrame == null ? EngineCommandManager.getUserGuid() : parentFrame.getUserGuid();
        this.imageLabel = new OrientableLabel(ControlsUtils.getAboutImage());
        this.imageLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
        OrientablePanel contentPane = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 10;
        constraints.weightx = 1.0;
        contentPane.add((Component)this.imageLabel, constraints);
        OrientablePanel infoPanel = new OrientablePanel(new GridBagLayout());
        infoPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 7, 0));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 21;
        c.insets = new Insets(5, 1, 0, 5);
        EngineMode currentMode = EngineCommandManager.getCurrentMode();
        String productVersionName = EngineCommandManager.getProductVersionName();
        String userName = GWCommandManager.getInstance(userGuid).getCurrentUserInfo().getName();
        String fileId = GWCommandManager.getInstance(userGuid).getCurrentUserInfo().getFileId();
        String postOffice = GWCommandManager.getInstance(userGuid).getCurrentUserInfo().getPostOffice();
        String sGWClientImplVersion = this.getClass().getPackage().getImplementationVersion();
        String sGWAPIImplVersion = EngineCommandManager.getGWAPIJarVersion();
        String sGWClientVersion = AboutDialog.getBuildNumber(sGWClientImplVersion);
        String sGWAPIVersion = AboutDialog.getBuildNumber(sGWAPIImplVersion);
        String sJarDate = "";
        Date jarDate = Utils.getClassDate(this.getClass());
        if (jarDate != null) {
            DateTimeOptions dateTimeOptions = OptionManager.getInstance().getDateTimeOptions();
            DateFormat dateFormatOut = DateAndTimeFormattingUtils.getDateFormat(dateTimeOptions.getShortDateFormat());
            sJarDate = dateFormatOut.format(jarDate);
        }
        boolean bIsLeftToRight = UIUtils.getComponentOrientation().isLeftToRight();
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        infoPanel.add((Component)new AboutLabel(StringResources.PROGRAM_RELEASE_C), c);
        this.infoAboutVertion = this.infoAboutVertion + StringResources.PROGRAM_RELEASE_C + ' ';
        c.gridx = 1;
        c.weightx = 1.0;
        String jarNameString = "(gwclient.jar)";
        AboutLabel tmpLabel = bIsLeftToRight ? new AboutLabel(productVersionName + ' ' + sJarDate + ' ' + jarNameString) : new AboutLabel(jarNameString + ' ' + sJarDate + ' ' + productVersionName);
        this.infoAboutVertion = this.infoAboutVertion + tmpLabel.getText();
        infoPanel.add((Component)tmpLabel, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        infoPanel.add((Component)new AboutLabel(StringResources.BUILD_NUMBER_C), c);
        this.infoAboutVertion = this.infoAboutVertion + '\n' + StringResources.BUILD_NUMBER_C + ' ';
        c.gridx = 1;
        c.weightx = 1.0;
        tmpLabel = new AboutLabel((sGWAPIVersion != null ? sGWAPIVersion : "0") + "." + (sGWClientVersion != null ? sGWClientVersion : "0"));
        this.infoAboutVertion = this.infoAboutVertion + tmpLabel.getText();
        infoPanel.add((Component)tmpLabel, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        infoPanel.add((Component)new AboutLabel(StringResources.USERNAME_C), c);
        this.infoAboutVertion = this.infoAboutVertion + '\n' + StringResources.USERNAME_C + ' ';
        c.gridx = 1;
        c.weightx = 1.0;
        tmpLabel = bIsLeftToRight ? new AboutLabel((userName + (currentMode == EngineMode.ONLINE ? " (" + fileId + ')' : "")).toUpperCase()) : new AboutLabel(((currentMode == EngineMode.ONLINE ? '(' + fileId + ") " : "") + userName).toUpperCase());
        this.infoAboutVertion = this.infoAboutVertion + tmpLabel.getText();
        infoPanel.add((Component)tmpLabel, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        infoPanel.add((Component)new AboutLabel(StringResources.POST_OFFICE_C), c);
        this.infoAboutVertion = this.infoAboutVertion + '\n' + StringResources.POST_OFFICE_C + ' ';
        c.gridx = 1;
        c.weightx = 1.0;
        infoPanel.add((Component)new AboutLabel(postOffice), c);
        this.infoAboutVertion = this.infoAboutVertion + postOffice;
        if (currentMode == EngineMode.ONLINE) {
            String tcpipAddress = GWCommandManager.getInstance(userGuid).getCurrentUserInfo().getServerIP();
            String tcpipPort = String.valueOf(GWCommandManager.getInstance(userGuid).getCurrentUserInfo().getPort());
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            infoPanel.add((Component)new AboutLabel(StringResources.TCPIP_ADDRESS_C), c);
            this.infoAboutVertion = this.infoAboutVertion + '\n' + StringResources.TCPIP_ADDRESS_C + ' ';
            c.gridx = 1;
            c.weightx = 1.0;
            infoPanel.add((Component)new AboutLabel(tcpipAddress), c);
            this.infoAboutVertion = this.infoAboutVertion + tcpipAddress;
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            infoPanel.add((Component)new AboutLabel(StringResources.TCPIP_PORT_C), c);
            this.infoAboutVertion = this.infoAboutVertion + '\n' + StringResources.TCPIP_PORT_C + ' ';
            c.gridx = 1;
            c.weightx = 1.0;
            infoPanel.add((Component)new AboutLabel(tcpipPort), c);
            this.infoAboutVertion = this.infoAboutVertion + tcpipPort;
        } else {
            String cachingPath = GWCommandManager.getInstance(userGuid).getCurrentUserInfo().getCachingPath();
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            infoPanel.add((Component)new AboutLabel(StringResources.PATH_TO_POST_OFFICE_C), c);
            this.infoAboutVertion = this.infoAboutVertion + '\n' + StringResources.PATH_TO_POST_OFFICE_C + ' ';
            c.gridx = 1;
            c.weightx = 1.0;
            infoPanel.add((Component)new AboutLabel(cachingPath), c);
            this.infoAboutVertion = this.infoAboutVertion + cachingPath;
        }
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        infoPanel.add((Component)new AboutLabel(StringResources.JAVA_RUNTIME_VERSION_C), c);
        this.infoAboutVertion = this.infoAboutVertion + '\n' + StringResources.JAVA_RUNTIME_VERSION_C + ' ';
        c.gridx = 1;
        c.weightx = 1.0;
        if (bIsLeftToRight) {
            tmpLabel = new AboutLabel(System.getProperty("java.runtime.version") + " (" + System.getProperty("java.vendor.url") + ')');
            this.infoAboutVertion = this.infoAboutVertion + System.getProperty("java.runtime.version") + " (" + System.getProperty("java.vendor.url") + ')';
        } else {
            tmpLabel = new AboutLabel('(' + System.getProperty("java.vendor.url") + ") " + System.getProperty("java.runtime.version"));
            this.infoAboutVertion = this.infoAboutVertion + '(' + System.getProperty("java.vendor.url") + ") " + System.getProperty("java.runtime.version");
        }
        infoPanel.add((Component)tmpLabel, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        infoPanel.add((Component)new AboutLabel(StringResources.PLATFORM_C), c);
        this.infoAboutVertion = this.infoAboutVertion + '\n' + StringResources.PLATFORM_C + ' ';
        c.gridx = 1;
        c.weightx = 1.0;
        if (bIsLeftToRight) {
            tmpLabel = new AboutLabel(System.getProperty("os.name") + " / " + System.getProperty("os.version") + " / " + System.getProperty("os.arch"));
            this.infoAboutVertion = this.infoAboutVertion + System.getProperty("os.name") + " / " + System.getProperty("os.version") + " / " + System.getProperty("os.arch");
        } else {
            tmpLabel = new AboutLabel(System.getProperty("os.arch") + " / " + System.getProperty("os.version") + " / " + System.getProperty("os.name"));
            this.infoAboutVertion = this.infoAboutVertion + System.getProperty("os.arch") + " / " + System.getProperty("os.version") + " / " + System.getProperty("os.name");
        }
        infoPanel.add((Component)tmpLabel, c);
        constraints.gridy = 1;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        contentPane.add((Component)infoPanel, constraints);
        OrientablePanel buttonPanel = new OrientablePanel();
        CancelAction action = new CancelAction();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        buttonPanel.add(new OrientableButton(new CopyInfoAction()));
        buttonPanel.add(new OrientableButton(action));
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 22;
        constraints.insets.bottom = 10;
        constraints.insets.left = 10;
        contentPane.add((Component)buttonPanel, constraints);
        contentPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.getContentPane().add((Component)new OrientableScrollPane(contentPane), "Center");
        this.setDefaultCancelAction(action);
        this.pack();
    }

    private static String getBuildNumber(String value) {
        int index;
        if (value != null && (index = value.indexOf("-")) != -1) {
            return value.substring(index + 1);
        }
        return value;
    }

    private class CopyInfoAction
    extends AbstractAction {
        public CopyInfoAction() {
            super(StringResources.COPY_INFO);
        }

        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = AboutDialog.this.getToolkit().getSystemClipboard();
            StringSelection clipString = new StringSelection(AboutDialog.this.infoAboutVertion);
            clipboard.setContents(clipString, clipString);
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent e) {
            AboutDialog.this.dispose();
        }
    }

    private static class AboutLabel
    extends JLabel {
        public AboutLabel(String label) {
            super(label);
            this.setFont(new Font(PLAFChanger.getFontName(), 0, PLAFChanger.getFontSize()));
        }

        public void setText(String text) {
            super.setText(text + ' ');
        }
    }
}

