/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs;

import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.basicdialogs.OkCancelDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveTypesToggle;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.DateTimeOptions;
import com.novell.gw.jclient.bl.om.options.GWTimeZone;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class AlternateTimeZoneDialog
extends OkCancelDialog {
    private static Logger logger = Logger.getLogger(AlternateTimeZoneDialog.class);
    private OrientableCheckBox cbDisplayATZ;
    private GWTextField tfLabelATZ;
    private GWTextField tfLabelWTZ;
    private OrientableComboBox cmbTimeZoneATZ;
    private OrientableComboBox cmbTimeZoneWTZ;
    private MVCController parentController;

    public AlternateTimeZoneDialog(JFrame parentFrame, MVCController controller) {
        super(parentFrame);
        this.parentController = controller;
        this.initUIComponents();
        this.loadData();
        this.buildDialogUI();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void initUIComponents() {
        this.cbDisplayATZ = new OrientableCheckBox(StringResources.DISPLAY_ADDITIONAL_TIME_ZONE);
        this.tfLabelATZ = new GWTextField(11);
        this.tfLabelWTZ = new GWTextField(11);
        DateTimeOptions dateTime = OptionManager.getInstance().getDateTimeOptions();
        this.cmbTimeZoneATZ = new OrientableComboBox(dateTime.getTimeZoneOptions().getTimeZoneNames());
        this.cmbTimeZoneWTZ = new OrientableComboBox(dateTime.getTimeZoneOptions().getTimeZoneNames());
        this.cmbTimeZoneWTZ.setEnabled(false);
    }

    private void saveData() {
        ActiveTypesToggle.getInstance().setShowAlternateTimeZone(this.cbDisplayATZ.isSelected());
        DateTimeOptions dateTimeOptions = OptionManager.getInstance().getDateTimeOptions();
        dateTimeOptions.setWorkstationTimeZoneLabel(this.tfLabelWTZ.getText());
        dateTimeOptions.setAlternateTimeZoneLabel(this.tfLabelATZ.getText());
        dateTimeOptions.setTimeZone(((GWTimeZone)this.cmbTimeZoneWTZ.getSelectedItem()).getTimeZone());
        dateTimeOptions.setAlternateTimeZone(((GWTimeZone)this.cmbTimeZoneATZ.getSelectedItem()).getTimeZone());
        OptionManager.getInstance().setDateTimeOptions(dateTimeOptions);
        logger.debug((Object)"TimeZones information saved");
        this.parentController.processCommand(new GlobalCommand(86));
    }

    private void loadData() {
        this.cbDisplayATZ.setSelected(ActiveTypesToggle.getInstance().isShowAlternateTimeZone());
        DateTimeOptions dateTimeOptions = OptionManager.getInstance().getDateTimeOptions();
        this.tfLabelWTZ.setText(dateTimeOptions.getWorkstationTimeZoneLabel());
        this.tfLabelATZ.setText(dateTimeOptions.getAlternateTimeZoneLabel());
        this.cmbTimeZoneWTZ.setSelectedItem(new GWTimeZone(OptionManager.getInstance().getDateTimeOptions().getTimeZone()));
        this.cmbTimeZoneATZ.setSelectedItem(new GWTimeZone(OptionManager.getInstance().getDateTimeOptions().getAlternateTimeZone()));
        logger.debug((Object)"TimeZones information loaded");
    }

    private void buildDialogUI() {
        OrientablePanel cp = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        OrientablePanel pnlTemp = new OrientablePanel(new BorderLayout());
        pnlTemp.add((Component)new OrientableLabel(StringResources.ADDITIONAL_TIME_ZONE), "Before");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 0, 5, 0);
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.anchor = 21;
        cp.add((Component)pnlTemp, gbc);
        gbc.insets = new Insets(5, 10, 5, 0);
        ++gbc.gridy;
        cp.add((Component)this.cbDisplayATZ, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        cp.add((Component)new OrientableLabel(StringResources.LABEL_C), gbc);
        gbc.weightx = 1.0;
        ++gbc.gridx;
        gbc.fill = 0;
        cp.add((Component)this.tfLabelATZ, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.fill = 1;
        cp.add((Component)new OrientableLabel(StringResources.TIME_ZONE), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        cp.add((Component)this.cmbTimeZoneATZ, gbc);
        pnlTemp = new OrientablePanel(new BorderLayout(5, 5));
        pnlTemp.add((Component)new OrientableLabel(StringResources.WORKSTATION_TIME_ZONE), "Before");
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(5, 0, 5, 0);
        cp.add((Component)pnlTemp, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(5, 10, 5, 0);
        cp.add((Component)new OrientableLabel(StringResources.LABEL_C), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        cp.add((Component)this.tfLabelWTZ, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.fill = 1;
        cp.add((Component)new OrientableLabel(StringResources.TIME_ZONE), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        cp.add((Component)this.cmbTimeZoneWTZ, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(5, 0, 0, 0);
        cp.add((Component)this.getButtonPanel(), gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.weighty = 1.0;
        cp.add((Component)new JPanel(), gbc);
        cp.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setContentPane(cp);
        this.pack();
        this.setTitle(StringResources.ADDITIONAL_TIME_ZONE);
    }

    private JPanel getButtonPanel() {
        OrientablePanel pnlResult = new OrientablePanel(new BorderLayout());
        pnlResult.add((Component)this.createOkCancelButtonsPanel(), "After");
        return pnlResult;
    }

    protected void processOkAction(ActionEvent event) {
        super.processOkAction(event);
        this.saveData();
    }
}

