/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.alarm;

import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.notify.FileChooserUtils;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class AlarmDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger(AlarmDialog.class);
    private static int MAX_HOURS_VALUE = 2400;
    private static int MAX_MINUTES_VALUE = 59;
    private static int MILLISECONDS_IN_A_MINUTE = 60000;
    private static int MILLISECONDS_IN_A_HOUR = 3600000;
    private AppointmentItem item;
    private int initialHours;
    private int initialMinutes;
    private String initialProgram;
    private OrientablePanel pnlTime;
    private OrientablePanel pnlProgram = new OrientablePanel();
    private OrientablePanel pnlButtons = new OrientablePanel();
    private JSpinner spnHoursSpinner;
    private JSpinner spnMinutesSpinner;
    private JTextField tfProgram;
    private JButton btnChooseProgram;
    private boolean isAlarmSet;

    public AlarmDialog(JFrame parentFrame, AppointmentItem appointmentItem) {
        super(parentFrame);
        if (parentFrame == null) {
            throw new IllegalArgumentException("parentFrame is null");
        }
        if (appointmentItem == null) {
            throw new IllegalArgumentException("appointmentItem is null");
        }
        this.item = appointmentItem;
        this.isAlarmSet = this.item.isAlarmSet();
        this.initValues();
        this.buildUI();
    }

    private void initValues() {
        if (this.item.isAlarmSet()) {
            Date alarmDate = this.item.getAlarmTime();
            Date startDate = this.item.getStartDate();
            long milliseconds = startDate.getTime() - alarmDate.getTime();
            this.initialHours = (int)milliseconds / MILLISECONDS_IN_A_HOUR;
            milliseconds -= milliseconds / (long)MILLISECONDS_IN_A_HOUR * (long)MILLISECONDS_IN_A_HOUR;
            this.initialMinutes = (int)milliseconds / MILLISECONDS_IN_A_MINUTE;
            this.initialProgram = this.item.getLaunchProgram();
        } else {
            DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
            int time = this.item.isAllDayEvent() ? ((Integer)dataStoreSettings.getAllDayEventAlarmMinutes().getValue()).intValue() : ((Integer)dataStoreSettings.getAppointmentAlarmMinutes().getValue()).intValue();
            this.initialHours = time / 60;
            this.initialMinutes = time - this.initialHours * 60;
            this.initialProgram = "";
        }
        logger.debug((Object)("hours: " + this.initialHours + ", minutes: " + this.initialMinutes));
    }

    private void buildUI() {
        this.setTitle(StringResources.ALARM);
        this.buildTimePanel();
        this.buildProgramPanel();
        this.buildButtonsPanel();
        OrientablePanel pnlContent = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 21;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        pnlContent.add((Component)this.pnlTime, c);
        ++c.gridy;
        pnlContent.add((Component)this.pnlProgram, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 0;
        c.weightx = 0.0;
        pnlContent.add((Component)this.pnlButtons, c);
        this.setContentPane(pnlContent);
    }

    private void buildTimePanel() {
        SpinnerNumberModel hoursModel = new SpinnerNumberModel(this.initialHours, 0, MAX_HOURS_VALUE, 1);
        this.spnHoursSpinner = new OrientableSpinner(hoursModel);
        SpinnerNumberModel minutesModel = new SpinnerNumberModel(this.initialMinutes, 0, MAX_MINUTES_VALUE, 1);
        this.spnMinutesSpinner = new OrientableSpinner(minutesModel);
        OrientableLabel lbHours = new OrientableLabel(StringResources.HOURS_BEFORE_C);
        OrientableLabel lbMintes = new OrientableLabel(StringResources.MINUTES_BEFORE_C);
        this.pnlTime = new OrientablePanel(new FlowLayout(3));
        this.pnlTime.add(lbHours);
        this.pnlTime.add(this.spnHoursSpinner);
        this.pnlTime.add(lbMintes);
        this.pnlTime.add(this.spnMinutesSpinner);
    }

    private void buildProgramPanel() {
        OrientableLabel lbProgram = new OrientableLabel(StringResources.PROGRAM_TO_LAUNCH);
        this.tfProgram = new GWTextField(this.initialProgram);
        this.tfProgram.addFocusListener(new ProgramLostFocusListener());
        this.btnChooseProgram = new OrientableButton(new ActionChooseProgram());
        this.pnlProgram = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 21;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        this.pnlProgram.add((Component)lbProgram, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.pnlProgram.add((Component)this.tfProgram, c);
        c.gridx = 1;
        c.weightx = 0.0;
        this.pnlProgram.add((Component)this.btnChooseProgram, c);
    }

    private void buildButtonsPanel() {
        OrientableButton btnClear = new OrientableButton(new AbstractAction(StringResources.CLEAR){

            public boolean isEnabled() {
                return AlarmDialog.this.item.canClearAlarm();
            }

            public void actionPerformed(ActionEvent e) {
                AlarmDialog.this.setActionCompleteSuccessfully(true);
                AlarmDialog.this.item.clearAlarm();
                AlarmDialog.this.isAlarmSet = false;
                AlarmDialog.this.dispose();
            }
        });
        OrientableButton btnSet = new OrientableButton(new AbstractAction(StringResources.SET){

            public void actionPerformed(ActionEvent e) {
                boolean result = AlarmDialog.this.setAlarm();
                if (result) {
                    AlarmDialog.this.setActionCompleteSuccessfully(true);
                    AlarmDialog.this.isAlarmSet = true;
                    AlarmDialog.this.dispose();
                }
            }
        });
        this.pnlButtons = new OrientablePanel();
        this.pnlButtons.setLayout(new GridLayout(3, 1, 2, 2));
        this.pnlButtons.add(btnSet);
        this.pnlButtons.add(btnClear);
        this.pnlButtons.add(this.btnCancel);
    }

    private void handleChooseProgram() {
        int returnValue = FileChooserUtils.getProgramFileChooser().showOpenDialog(this.btnChooseProgram);
        if (returnValue == 0) {
            File file = FileChooserUtils.getProgramFileChooser().getSelectedFile();
            this.tfProgram.setText(file.getAbsolutePath());
        }
    }

    private boolean setAlarm() {
        boolean result = false;
        if (this.hasAlarmTimePassed()) {
            JOptionPane.showMessageDialog(this, StringResources.YOU_CANNOT_SET_ALARM_FOR_EXPIRED_TIME, StringResources.SET_ALARM, 1);
        } else {
            this.item.setAlarm((Integer)this.spnHoursSpinner.getModel().getValue(), (Integer)this.spnMinutesSpinner.getModel().getValue(), this.tfProgram.getText());
            result = true;
        }
        return result;
    }

    private boolean hasAlarmTimePassed() {
        Date startDate = this.item.getStartDate();
        long alarmMoment = startDate.getTime();
        alarmMoment -= (long)((Integer)this.spnHoursSpinner.getModel().getValue() * MILLISECONDS_IN_A_HOUR);
        logger.debug((Object)("start date" + startDate + ", alarm date: " + new Date(alarmMoment -= (long)((Integer)this.spnMinutesSpinner.getModel().getValue() * MILLISECONDS_IN_A_MINUTE))));
        return alarmMoment < System.currentTimeMillis();
    }

    private void handleProgramFileFocusLost() {
        if (this.tfProgram.getText().trim().length() == 0) {
            return;
        }
        String error = FileChooserUtils.checkProgramFile(this.tfProgram.getText());
        if (error != null) {
            this.tfProgram.setText("");
            JOptionPane.showMessageDialog(this, error, StringResources.GROUP_WISE_NOTIFY, 0);
        }
    }

    public boolean isAlarmSet() {
        return this.isAlarmSet;
    }

    private class ProgramLostFocusListener
    implements FocusListener {
        private ProgramLostFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            AlarmDialog.this.handleProgramFileFocusLost();
        }
    }

    private class ActionChooseProgram
    extends AbstractAction {
        public ActionChooseProgram() {
            super(null, ImageResources.OPEN_FILE);
        }

        public void actionPerformed(ActionEvent e) {
            AlarmDialog.this.handleChooseProgram();
        }
    }
}

