/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.categories;

import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.ExtendedGWTable;
import com.novell.gw.jclient.application.controls.ColoredLimitingTableScrollPane;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.TableRendererUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.categories.CategoriesBooleanCellEditor;
import com.novell.gw.jclient.application.dialogs.categories.CategoriesBooleanCellRenderer;
import com.novell.gw.jclient.application.dialogs.categories.CategoriesEditDialogController;
import com.novell.gw.jclient.application.dialogs.categories.CategoriesTableModel;
import com.novell.gw.jclient.application.dialogs.categories.CategoriesTextCellEditor;
import com.novell.gw.jclient.application.dialogs.categories.CategoriesTextCellRenderer;
import com.novell.gw.jclient.application.dialogs.folderproperties.ColorChooserButton;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class CategoriesEditDialog
extends ApplicationDialog {
    private static final String TYPE_HERE = "<" + StringResources.TYPE_HERE_TO_ADD_NEW_CATEGORY + ">";
    private JTable table;
    private JTextField tfNewCategory;
    private JTextField tfColorSample;
    private JButton addButton;
    private JButton primaryButton;
    private JButton renameButton;
    private JButton deleteButton;
    private ColorChooserButton colorChooserBtn;
    private ColorChooserButton colorBackgroundBtn;
    private IItemList itemList;
    private IItem[] items;
    private CategoriesTableModel model;
    private boolean newCategoryEntered = false;
    private String userGuid = ControlsUtils.getUserGuid(this.getController());

    private CategoriesEditDialog(JFrame frame, MVCController controller) {
        super((Frame)frame, controller);
    }

    public CategoriesEditDialog(JFrame frame, MVCController parentController, IItemList itemList, IItem[] items) {
        this(frame, parentController);
        this.itemList = itemList;
        this.items = items;
        this.model = new CategoriesTableModel(CategoryUtils.getCategories(items), this.userGuid);
        CategoryUtils.printCategories(items);
        this.buildUI();
    }

    public CategoriesEditDialog(JFrame theFrame, MVCController theParentController, ICategoryList categories) {
        this(theFrame, theParentController);
        if (categories == null) {
            IDataStore dataStore = EngineCommandManager.getInstance(this.userGuid).getCurrentDataStore();
            categories = APIWrapperManager.createCategoryList(dataStore);
        }
        this.model = new CategoriesTableModel(categories, this.userGuid);
        this.buildUI();
    }

    public static ICategoryList show(Window window, MVCController parentController, ICategoryList itemCategories) {
        CategoriesEditDialog dialog = new CategoriesEditDialog((JFrame)window, parentController, itemCategories);
        dialog.showMe();
        if (dialog.isOkActionProcessed()) {
            return dialog.getCategories();
        }
        return null;
    }

    public void showMe() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public static void show(Window window, MVCController theParentController, IItemList itemList, IItem[] items) {
        CategoriesEditDialog dialog = new CategoriesEditDialog((JFrame)window, theParentController, itemList, items);
        dialog.showMe();
    }

    private void buildUI() {
        this.setTitle(StringResources.EDIT_CATEGORIES);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.removeAll();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 5, 0);
        c.fill = 1;
        contentPane.add((Component)this.buildCategoriesPanel(), c);
        c.anchor = 11;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        contentPane.add((Component)this.buildButtonPanel(), c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        contentPane.add((Component)new JSeparator(), c);
        OrientablePanel categoryAddPanel = new OrientablePanel(new BorderLayout());
        categoryAddPanel.add((Component)new OrientableLabel(StringResources.NEW_CATEGORY), "North");
        this.tfNewCategory = new GWTextField(TYPE_HERE);
        this.tfNewCategory.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tfNewCategory.getDocument().addDocumentListener(new AddFieldListener());
        this.tfNewCategory.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (!CategoriesEditDialog.this.newCategoryEntered) {
                    CategoriesEditDialog.this.tfNewCategory.setText("");
                }
            }

            public void focusLost(FocusEvent e) {
                if (!CategoriesEditDialog.this.newCategoryEntered) {
                    CategoriesEditDialog.this.tfNewCategory.setText(TYPE_HERE);
                }
            }
        });
        categoryAddPanel.add((Component)this.tfNewCategory, "Center");
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 2;
        c.gridwidth = 1;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 0);
        contentPane.add((Component)categoryAddPanel, c);
        this.addButton = new OrientableButton(StringResources.ADD);
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(new AddButtonListener());
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 2;
        c.gridwidth = 1;
        c.anchor = 20;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        contentPane.add((Component)this.addButton, c);
        if (CategoryUtils.getCategoryCount(this.userGuid) > 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private OrientablePanel buildButtonPanel() {
        OrientablePanel buttonPanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 11;
        c.insets = new Insets(0, 0, 5, 0);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        buttonPanel.add((Component)this.getBtnOk(), c);
        c.gridy = 1;
        buttonPanel.add((Component)this.getBtnCancel(), c);
        c.gridy = 2;
        JPanel emptyPanel = new JPanel();
        emptyPanel.setMinimumSize(new Dimension(0, 25));
        buttonPanel.add((Component)emptyPanel, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.gridy = 3;
        this.primaryButton = new OrientableButton(StringResources.PRIMARY);
        this.primaryButton.addActionListener(new PrimaryButtonListener());
        this.primaryButton.setEnabled(false);
        buttonPanel.add((Component)this.primaryButton, c);
        c.gridy = 6;
        this.renameButton = new OrientableButton(StringResources.RENAME);
        this.renameButton.addActionListener(new RenameButtonListener());
        this.renameButton.setEnabled(false);
        buttonPanel.add((Component)this.renameButton, c);
        c.gridy = 7;
        this.deleteButton = new OrientableButton(StringResources.DELETE);
        this.deleteButton.addActionListener(new DeleteCategoryListener());
        this.deleteButton.setEnabled(false);
        buttonPanel.add((Component)this.deleteButton, c);
        c.gridy = 8;
        OrientablePanel panel = new OrientablePanel(new BorderLayout(5, 0));
        OrientableLabel lbText = new OrientableLabel(StringResources.TEXT);
        this.colorChooserBtn = new ColorChooserButton(null);
        this.colorChooserBtn.addPropertyChangeListener(new TextColorAction());
        this.colorChooserBtn.setEnabled(false);
        panel.add((Component)lbText, "Before");
        panel.add((Component)this.colorChooserBtn, "After");
        buttonPanel.add((Component)panel, c);
        c.gridy = 9;
        panel = new OrientablePanel(new BorderLayout(5, 0));
        OrientableLabel lbForeground = new OrientableLabel(StringResources.BACKGROUND);
        this.colorBackgroundBtn = new ColorChooserButton(null);
        this.colorBackgroundBtn.addPropertyChangeListener(new BackgroundColorAction());
        this.colorBackgroundBtn.setEnabled(false);
        panel.add((Component)this.colorBackgroundBtn, "After");
        panel.add((Component)lbForeground, "Before");
        buttonPanel.add((Component)panel, c);
        return buttonPanel;
    }

    private JPanel buildCategoriesPanel() {
        OrientablePanel categoriesTablePanel = new OrientablePanel(new BorderLayout());
        categoriesTablePanel.add((Component)new OrientableLabel(StringResources.CATEGORIES), "North");
        this.table = new ExtendedGWTable(this.model);
        this.table.setTableHeader(null);
        this.table.setShowHorizontalLines(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setDefaultRenderer(String.class, new CategoriesTextCellRenderer(this.model.getCategories()));
        this.table.setDefaultEditor(String.class, new CategoriesTextCellEditor());
        this.table.setDefaultRenderer(Boolean.class, new CategoriesBooleanCellRenderer(this.model.getCategories(), this.userGuid));
        this.table.setDefaultEditor(Boolean.class, new CategoriesBooleanCellEditor(this.model.getCategories()));
        TableColumn column = this.table.getColumnModel().getColumn(0);
        column.setResizable(false);
        column.setMaxWidth(17);
        column.setMinWidth(17);
        this.table.setShowGrid(false);
        this.table.setSelectionMode(2);
        this.table.addKeyListener(new OKCancelKeyAdapter());
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.addListSelectionListener(new TableSelectionListener());
        ColoredLimitingTableScrollPane scrollPane = new ColoredLimitingTableScrollPane(this.table, 200);
        categoriesTablePanel.add((Component)scrollPane, "Center");
        categoriesTablePanel.add((Component)this.buildSamplePanel(), "Last");
        return categoriesTablePanel;
    }

    private OrientablePanel buildSamplePanel() {
        OrientablePanel panel = new OrientablePanel(new BorderLayout());
        OrientableLabel lbSample = new OrientableLabel(StringResources.COLOR_SAMPLE);
        panel.add((Component)lbSample, "First");
        this.tfColorSample = new GWTextField();
        this.tfColorSample.setEditable(false);
        this.tfColorSample.setBorder(null);
        panel.add(this.tfColorSample);
        return panel;
    }

    private void deleteCategories() {
        this.model.deleteCategory(this.table.getSelectedRows());
    }

    private void enableButtonAdd() {
        if (this.newCategoryEntered && !this.addButton.isEnabled()) {
            this.addButton.setEnabled(true);
            this.setDefaultButton(this.addButton);
        }
    }

    private void disableButtonAdd() {
        if (this.addButton.isEnabled()) {
            this.setDefaultButton(this.getBtnOk());
            this.addButton.setEnabled(false);
        }
    }

    protected MVCController createController(MVCController parentController) {
        return new CategoriesEditDialogController(this, parentController);
    }

    protected void processOkAction(ActionEvent event) {
        super.processOkAction(event);
        CategoriesEditDialog dialog = this;
        if (dialog.itemList != null) {
            CategoryUtils.setCategoriesToItemList(dialog.itemList, dialog.model.getCategories(), dialog.items, dialog.model.getChangedCategories());
            ((MVCController)this.getController()).processCommand(new GlobalCommand(1401));
        }
    }

    public void setCategories(ICategoryList categories) {
        this.model.setCategories(categories);
    }

    public ICategoryList getCategories() {
        return this.model.getCategories();
    }

    private class AddFieldListener
    implements DocumentListener {
        private AddFieldListener() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            if (CategoriesEditDialog.this.tfNewCategory.getText().length() > 0 && !CategoriesEditDialog.this.tfNewCategory.getText().equals(TYPE_HERE)) {
                CategoriesEditDialog.this.newCategoryEntered = true;
            }
            CategoriesEditDialog.this.enableButtonAdd();
        }

        public void removeUpdate(DocumentEvent e) {
            if (CategoriesEditDialog.this.tfNewCategory.getText().length() == 0) {
                CategoriesEditDialog.this.disableButtonAdd();
            }
        }
    }

    private class OKCancelKeyAdapter
    extends KeyAdapter {
        private OKCancelKeyAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            int result;
            if (e.getKeyCode() == 127 && (result = JOptionPane.showConfirmDialog(CategoriesEditDialog.this, StringResources.ARE_YOU_SURE_YOU_WANT_TO_DELETE_CATEGORIES, StringResources.CONFIRM_CATEGORY_DELETE, 2)) == 0) {
                CategoriesEditDialog.this.deleteCategories();
            }
        }
    }

    private class AddButtonListener
    extends AbstractAction {
        private AddButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String name = CategoriesEditDialog.this.tfNewCategory.getText();
            if (CategoryUtils.getCategory(name, CategoriesEditDialog.this.userGuid) == null) {
                CategoriesEditDialog.this.model.addCategory(name);
                CategoriesEditDialog.this.tfNewCategory.setText("");
                CategoriesEditDialog.this.disableButtonAdd();
            } else {
                CategoriesEditDialog.this.tfNewCategory.requestFocus(true);
            }
        }
    }

    private class DeleteCategoryListener
    extends AbstractAction {
        private DeleteCategoryListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int result = JOptionPane.showConfirmDialog(CategoriesEditDialog.this, StringResources.ARE_YOU_SURE_YOU_WANT_TO_DELETE_CATEGORIES, StringResources.CONFIRM_CATEGORY_DELETE, 0, 1);
            if (result == 0) {
                CategoriesEditDialog.this.deleteCategories();
            }
        }
    }

    private class RenameButtonListener
    extends AbstractAction {
        private RenameButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int selectedRow = CategoriesEditDialog.this.table.getSelectedRow();
            int selectedColumn = CategoriesEditDialog.this.table.getSelectedColumn();
            if (selectedRow >= 0) {
                CategoriesEditDialog.this.table.scrollRectToVisible(CategoriesEditDialog.this.table.getCellRect(selectedRow, selectedColumn, true));
                CategoriesEditDialog.this.table.editCellAt(selectedRow, 1);
                CategoriesEditDialog.this.table.getEditorComponent().requestFocus();
            }
        }
    }

    private class TextColorAction
    implements PropertyChangeListener {
        private TextColorAction() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(ColorChooserButton.COLOR_CHANGE_PROPERTY_NAME)) {
                CategoriesEditDialog.this.model.setTextColor(CategoriesEditDialog.this.table.getSelectedRow(), CategoriesEditDialog.this.colorChooserBtn.getColor());
            }
        }
    }

    private class BackgroundColorAction
    implements PropertyChangeListener {
        private BackgroundColorAction() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(ColorChooserButton.COLOR_CHANGE_PROPERTY_NAME)) {
                CategoriesEditDialog.this.model.setBackgroundColor(CategoriesEditDialog.this.table.getSelectedRow(), CategoriesEditDialog.this.colorBackgroundBtn.getColor());
            }
        }
    }

    private class PrimaryButtonListener
    extends AbstractAction {
        private PrimaryButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            CategoriesEditDialog.this.model.setPrimary(CategoriesEditDialog.this.table.getSelectedRow());
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (lsm.isSelectionEmpty()) {
                CategoriesEditDialog.this.colorChooserBtn.setEnabled(false);
                CategoriesEditDialog.this.colorBackgroundBtn.setEnabled(false);
                CategoriesEditDialog.this.primaryButton.setEnabled(false);
                CategoriesEditDialog.this.renameButton.setEnabled(false);
                CategoriesEditDialog.this.deleteButton.setEnabled(false);
                CategoriesEditDialog.this.tfColorSample.setText("");
                CategoriesEditDialog.this.tfColorSample.setBackground(Color.WHITE);
            } else {
                Color foreground = CategoryUtils.getCategory(CategoriesEditDialog.this.table.getSelectedRow(), CategoriesEditDialog.this.userGuid).getTextColor();
                Color background = CategoryUtils.getCategory(CategoriesEditDialog.this.table.getSelectedRow(), CategoriesEditDialog.this.userGuid).getBackgroundColor();
                CategoriesEditDialog.this.colorChooserBtn.setEnabled(true);
                CategoriesEditDialog.this.colorChooserBtn.setColor(foreground);
                CategoriesEditDialog.this.colorChooserBtn.repaint();
                CategoriesEditDialog.this.colorBackgroundBtn.setEnabled(true);
                CategoriesEditDialog.this.colorBackgroundBtn.setColor(background);
                CategoriesEditDialog.this.colorBackgroundBtn.repaint();
                if (background == null) {
                    background = TableRendererUtils.ITEM_LIST_TABLE_BACKGROUND;
                }
                if (foreground == null) {
                    foreground = TableRendererUtils.ITEM_LIST_TABLE_FOREGROUND;
                }
                CategoriesEditDialog.this.tfColorSample.setForeground(foreground);
                CategoriesEditDialog.this.tfColorSample.setBackground(background);
                CategoriesEditDialog.this.tfColorSample.setText(CategoryUtils.getCategory(CategoriesEditDialog.this.table.getSelectedRow(), CategoriesEditDialog.this.userGuid).getName());
                if (CategoriesEditDialog.this.table.getSelectedRowCount() > 1) {
                    CategoriesEditDialog.this.colorChooserBtn.setEnabled(false);
                    CategoriesEditDialog.this.colorBackgroundBtn.setEnabled(false);
                    CategoriesEditDialog.this.primaryButton.setEnabled(false);
                    CategoriesEditDialog.this.renameButton.setEnabled(false);
                } else {
                    CategoriesEditDialog.this.colorChooserBtn.setEnabled(true);
                    CategoriesEditDialog.this.colorBackgroundBtn.setEnabled(true);
                    CategoriesEditDialog.this.primaryButton.setEnabled(true);
                    CategoriesEditDialog.this.renameButton.setEnabled(true);
                }
                CategoriesEditDialog.this.deleteButton.setEnabled(true);
            }
        }
    }
}

