/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.certificate;

import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.basicdialogs.OkCancelDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.cert.Certificate;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class AcceptCertificateDialog
extends OkCancelDialog {
    private static final Logger logger = Logger.getLogger(AcceptCertificateDialog.class);
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(10, 10, 10, 10);
    private static ClassLoader loader;
    private final Certificate[] certificates;

    public static void main(String[] args) {
        AcceptCertificateDialog dialog = new AcceptCertificateDialog((Frame)null, new Certificate[]{null});
        dialog.setDefaultCloseOperation(2);
        ((Dialog)dialog).setVisible(true);
    }

    public AcceptCertificateDialog(Frame owner, Certificate ... certificates) {
        super(owner);
        this.init();
        this.buildUI();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.certificates = certificates;
    }

    public AcceptCertificateDialog(Dialog owner, Certificate ... certificates) {
        super(owner);
        this.init();
        this.buildUI();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.certificates = certificates;
    }

    private void init() {
        JButton btnOk = this.getBtnOk();
        btnOk.setText("<html> <body>" + StringResources.ACCEPT + "<br>" + StringResources.ACCEPT_THIS_CERTIFICATE_AND_ALWAYS_TRUST_IT + "</br></html> </body>");
        btnOk.setIcon(ImageResources.ICON_ACCEPT);
        btnOk.setHorizontalAlignment(10);
        btnOk.setMargin(new Insets(5, 5, 5, 5));
        JButton btnCancel = this.getBtnCancel();
        btnCancel.setText("<html> <body>" + StringResources.CANCEL + "<br>" + StringResources.DO_NOT_ACCEPT_THIS_CERTIFICATE_AND_DO_NOT_CONNECT + "</br></html> </body>");
        btnCancel.setIcon(ImageResources.ICON_CANCEL);
        btnCancel.setHorizontalAlignment(10);
        btnCancel.setMargin(new Insets(5, 5, 5, 5));
    }

    private void buildUI() {
        this.setTitle(StringResources.GROUPWISE_SECURITY_WARNING);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 23;
        constraints.fill = 1;
        this.add((Component)this.createWarningPanel(), constraints);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        this.add((Component)this.createInfoPanel(), constraints);
        ++constraints.gridy;
        constraints.weighty = 0.0;
        this.add((Component)this.createOkCancelButtonsPanel(), constraints);
    }

    protected JPanel createOkCancelButtonsPanel() {
        OrientablePanel panel = new OrientablePanel(new GridLayout(0, 1, 5, 5));
        panel.add(this.getBtnOk());
        panel.add(this.getBtnCancel());
        int shift = 50;
        Border border = this.getComponentOrientation().isLeftToRight() ? BorderFactory.createEmptyBorder(0, shift, 0, 0) : BorderFactory.createEmptyBorder(0, 0, 0, shift);
        panel.setBorder(BorderFactory.createCompoundBorder(EMPTY_BORDER, border));
        return panel;
    }

    private JComponent createWarningPanel() {
        OrientableLabel label = new OrientableLabel();
        if (OS.isNimbusLAF()) {
            label.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
        } else {
            label.setIcon(ImageResources.ICON_ALERT);
        }
        ((JLabel)label).setText(StringResources.GROUPWISE_SECURITY_WARNING);
        Font font = label.getFont();
        label.setFont(font.deriveFont(font.getStyle(), 30.0f));
        label.setBackground(Color.WHITE);
        label.setOpaque(true);
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), EMPTY_BORDER));
        return label;
    }

    private JComponent createInfoPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        panel.setBorder(EMPTY_BORDER);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.insets.bottom = 5;
        constraints.anchor = 23;
        constraints.fill = 1;
        OrientableLabel label1 = new OrientableLabel();
        ((JLabel)label1).setText("<html> <body>" + StringResources.GROUPWISE_DOES_NOT_RECOGNIZE_THE_CERTIFICATE + "</html> </body>");
        panel.add((Component)label1, constraints);
        ++constraints.gridy;
        OrientableLabel label2 = new OrientableLabel();
        ((JLabel)label2).setText("<html> <body>" + StringResources.PLEASE_EXAMINE_THE_CERTIFICATE_CAREFULLY + "</html> </body>");
        panel.add((Component)label2, constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 0;
        OrientableLabel label3 = new OrientableLabel();
        label3.setCursor(Cursor.getPredefinedCursor(12));
        ((JLabel)label3).setText("<html><body><font color=blue>" + StringResources.VIEW_THE_CERTIFICATE + "</font></html></body>");
        label3.addMouseListener(new ViewCertificateAction());
        panel.add((Component)label3, constraints);
        panel.setPreferredSize(new Dimension(600, 200));
        return panel;
    }

    static {
        try {
            JarEntry entry;
            String jarPath = System.getProperty("java.home") + File.separatorChar + "lib" + File.separatorChar + "deploy.jar";
            logger.debug((Object)("deploy.jar path: (" + jarPath + ")"));
            loader = new URLClassLoader(new URL[]{new URL("file", null, jarPath)});
            JarInputStream inputStream = new JarInputStream(new FileInputStream(jarPath));
            while ((entry = inputStream.getNextJarEntry()) != null) {
                String end;
                String name = entry.getName();
                if (!name.endsWith(end = ".class")) continue;
                name = name.substring(0, name.length() - end.length());
                name = name.replace('/', '.');
                try {
                    loader.loadClass(name);
                }
                catch (Throwable e) {
                    logger.error((Object)e, e);
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private class ViewCertificateAction
    extends MouseAdapter {
        private ViewCertificateAction() {
        }

        public void mouseClicked(MouseEvent e) {
            if (loader != null && AcceptCertificateDialog.this.certificates != null && AcceptCertificateDialog.this.certificates.length > 0) {
                Object[] parameters = new Object[]{AcceptCertificateDialog.this, AcceptCertificateDialog.this.certificates, 0, AcceptCertificateDialog.this.certificates.length};
                try {
                    Class<?> dialogClass = loader.loadClass("com.sun.deploy.security.CertificateDialog");
                    if (OS.getJavaVersionMajor() < 1 || OS.getJavaVersionMajor() == 1 && OS.getJavaVersionMinor() <= 5) {
                        Class[] classes = new Class[]{Component.class, Certificate[].class, Integer.TYPE, Integer.TYPE};
                        Constructor<?> constructor = dialogClass.getConstructor(classes);
                        Object dialog = constructor.newInstance(parameters);
                        dialogClass.getMethod("DoModal", new Class[0]).invoke(dialog, new Object[0]);
                    } else if (OS.getJavaVersionMajor() >= 1 && OS.getJavaVersionMinor() >= 6) {
                        Class[] classes = new Class[]{JDialog.class, Certificate[].class, Integer.TYPE, Integer.TYPE};
                        Method method = dialogClass.getMethod("showCertificates", classes);
                        method.invoke(dialogClass, parameters);
                    }
                }
                catch (NoSuchMethodException e1) {
                    logger.error((Object)e1, (Throwable)e1);
                }
                catch (InvocationTargetException e1) {
                    logger.error((Object)e1, (Throwable)e1);
                }
                catch (IllegalAccessException e1) {
                    logger.error((Object)e1, (Throwable)e1);
                }
                catch (InstantiationException e1) {
                    logger.error((Object)e1, (Throwable)e1);
                }
                catch (ClassNotFoundException e1) {
                    logger.error((Object)e1, (Throwable)e1);
                }
            }
        }
    }
}

