/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.panelviews.MultiPanelViewModel;
import com.novell.gw.jclient.application.controls.panelviews.MultiPanelViewModelManager;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.AddPanelDialogController;
import com.novell.gw.jclient.application.dialogs.folderproperties.CreatePanelTemplateDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.DisplaySettingsPanelNameIgnoreCaseComparator;
import com.novell.gw.jclient.application.dialogs.folderproperties.EditPanelTemplateDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.PanelListCellRenderer;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPanelDialog
extends ApplicationDialog<AddPanelDialogController> {
    private AbstractFolder folder;
    private MultiPanelViewModel model;
    private int column;
    private int columnPosition;
    private DefaultListModel listModel = new DefaultListModel();
    private JList lstAvailableTemplates = new OrientableList((ListModel)this.listModel);
    private DisplaySettingsPanelNameIgnoreCaseComparator comparator = new DisplaySettingsPanelNameIgnoreCaseComparator();
    private JButton btnEditPanel;
    private JButton btnDeletePanel;
    private IPanelDisplaySettings selectedTemplate;

    public AddPanelDialog(JFrame window, MVCController parentController, AbstractFolder folder, int column, int columnPosition) {
        super((Frame)window, parentController);
        this.folder = folder;
        this.model = MultiPanelViewModelManager.getInstance().getModel(folder.getNativeFolder(), this.getUserGuid());
        this.column = column;
        this.columnPosition = columnPosition;
        this.setTitle(StringResources.ADD_PANEL);
        this.initTemplatesList();
        this.buildUI();
        this.handleListSelectionChange();
        this.updateAvailablePanels();
        this.setSelection();
    }

    @Override
    protected AddPanelDialogController createController(MVCController parentController) {
        return new AddPanelDialogController(this, parentController);
    }

    private String getUserGuid() {
        return ControlsUtils.getUserGuid(this.getController());
    }

    public AbstractFolder getFolder() {
        return this.folder;
    }

    private void initTemplatesList() {
        this.lstAvailableTemplates.setSelectionMode(0);
        this.lstAvailableTemplates.setCellRenderer(new PanelListCellRenderer());
        this.lstAvailableTemplates.addListSelectionListener(new TemplateSelectionListener());
    }

    private void buildUI() {
        OrientableButton btnRestoreDefaults = new OrientableButton(new ActionRestoreDefaults());
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.removeAll();
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 25;
        constraints.insets = new Insets(0, 0, 2, 0);
        contentPane.add((Component)new OrientableLabel(StringResources.AVAILABLE_PANELS), constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 10, 0, 0);
        contentPane.add((Component)this.createButtonsPanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 0, 0, 0);
        OrientableScrollPane lstScrollPane = new OrientableScrollPane(this.lstAvailableTemplates);
        lstScrollPane.setPreferredSize(new Dimension(lstScrollPane.getPreferredSize().width, 250));
        contentPane.add((Component)lstScrollPane, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 0, 0, 0);
        contentPane.add((Component)btnRestoreDefaults, constraints);
    }

    private JPanel createButtonsPanel() {
        OrientablePanel result = new OrientablePanel(new GridLayout(6, 1, 0, 5));
        result.add(this.getBtnOk());
        this.getBtnOk().setText(StringResources.ADD);
        result.add(this.getBtnCancel());
        result.add(Box.createVerticalStrut(20));
        OrientableButton btnNewPanel = new OrientableButton(new ActionCreatePanelTemplate());
        result.add(btnNewPanel);
        this.btnEditPanel = new OrientableButton(new ActionEditPanelTemplate());
        result.add(this.btnEditPanel);
        this.btnDeletePanel = new OrientableButton(new ActionDeletePanel());
        result.add(this.btnDeletePanel);
        return result;
    }

    void updateAvailablePanels() {
        IDataStore currentDataStore = EngineCommandManager.getInstance(this.getUserGuid()).getCurrentDataStore();
        IPanelDisplaySettings[] loadedDisplaySettings = new IPanelDisplaySettings[currentDataStore.getPanelTemplateSettingsCount()];
        int nCount = currentDataStore.getPanelTemplateSettingsCount();
        for (int i = 0; i < nCount; ++i) {
            loadedDisplaySettings[i] = currentDataStore.getPanelTemplateSettings(i);
        }
        Arrays.sort(loadedDisplaySettings, this.comparator);
        this.listModel.removeAllElements();
        for (IPanelDisplaySettings ds : loadedDisplaySettings) {
            this.listModel.addElement(ds);
        }
    }

    void setSelection() {
        if (this.listModel.getSize() == 0) {
            return;
        }
        if (this.selectedTemplate == null) {
            this.selectedTemplate = (IPanelDisplaySettings)this.lstAvailableTemplates.getModel().getElementAt(0);
            this.lstAvailableTemplates.setSelectedIndex(0);
        } else {
            int nSize = this.listModel.getSize();
            for (int i = 0; i < nSize; ++i) {
                if (((IPanelDisplaySettings)this.listModel.getElementAt(i)).getId() != this.selectedTemplate.getId()) continue;
                this.selectedTemplate = (IPanelDisplaySettings)this.listModel.getElementAt(i);
                this.lstAvailableTemplates.setSelectedValue(this.selectedTemplate, true);
                break;
            }
        }
        if (this.lstAvailableTemplates.isSelectionEmpty()) {
            this.lstAvailableTemplates.setSelectedIndex(0);
        }
    }

    private void handleListSelectionChange() {
        boolean enableButtons = false;
        if (this.lstAvailableTemplates.getModel().getSize() != 0 && !this.lstAvailableTemplates.isSelectionEmpty()) {
            enableButtons = true;
            this.selectedTemplate = (IPanelDisplaySettings)this.lstAvailableTemplates.getSelectedValue();
        }
        this.btnDeletePanel.setEnabled(enableButtons);
        this.btnEditPanel.setEnabled(enableButtons);
        this.getBtnOk().setEnabled(enableButtons);
    }

    @Override
    protected void processOkAction(ActionEvent event) {
        IPanelDisplaySettings selectedTemplate = (IPanelDisplaySettings)this.lstAvailableTemplates.getModel().getElementAt(this.lstAvailableTemplates.getSelectedIndex());
        IDataStore dataStore = EngineCommandManager.getInstance(this.getUserGuid()).getCurrentDataStore();
        IPanelDisplaySettings newPanel = APIWrapperManager.createPanelDisplaySettings(dataStore, selectedTemplate);
        this.model.insert(newPanel, this.column, this.columnPosition);
        super.processOkAction(event);
    }

    private class TemplateSelectionListener
    implements ListSelectionListener {
        private TemplateSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            AddPanelDialog.this.handleListSelectionChange();
        }
    }

    private class ActionRestoreDefaults
    extends AbstractAction {
        public ActionRestoreDefaults() {
            super(StringResources.RESTORE_DEFAULTS);
        }

        public void actionPerformed(ActionEvent e) {
            IDataStore currentDataStore = EngineCommandManager.getInstance(GWDialog.getUserGuidFromParentFrame(AddPanelDialog.this)).getCurrentDataStore();
            APIWrapperManager.createPanelDisplaySettings(currentDataStore).createPanelTemplateDisplaySettings();
            ((AddPanelDialogController)AddPanelDialog.this.getController()).processCommand(new GlobalCommand(1610));
        }
    }

    private class ActionEditPanelTemplate
    extends AbstractAction {
        public ActionEditPanelTemplate() {
            super(StringResources.EDIT_PANEL_D);
        }

        public void actionPerformed(ActionEvent e) {
            EditPanelTemplateDialog dialog = new EditPanelTemplateDialog(AddPanelDialog.this, (MVCController)AddPanelDialog.this.getController(), AddPanelDialog.this.selectedTemplate);
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            dialog.dispose();
        }
    }

    private class ActionDeletePanel
    extends AbstractAction {
        public ActionDeletePanel() {
            super(StringResources.DELETE_PANEL);
        }

        public void actionPerformed(ActionEvent e) {
            int selectedIndex = AddPanelDialog.this.lstAvailableTemplates.getSelectedIndex();
            if (selectedIndex == AddPanelDialog.this.listModel.getSize() - 1) {
                --selectedIndex;
            }
            int id = AddPanelDialog.this.selectedTemplate.getId();
            boolean result = AddPanelDialog.this.selectedTemplate.deleteSettings();
            if (result) {
                ((AddPanelDialogController)AddPanelDialog.this.getController()).processCommand(new GlobalCommand(1600, id));
                if (selectedIndex > -1) {
                    AddPanelDialog.this.lstAvailableTemplates.setSelectedIndex(selectedIndex);
                }
            }
        }
    }

    private class ActionCreatePanelTemplate
    extends AbstractAction {
        public ActionCreatePanelTemplate() {
            super(StringResources.NEW_PANEL_D);
        }

        public void actionPerformed(ActionEvent e) {
            CreatePanelTemplateDialog dialog = new CreatePanelTemplateDialog(AddPanelDialog.this, (MVCController)AddPanelDialog.this.getController(), AddPanelDialog.this.folder);
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            dialog.dispose();
        }
    }
}

