/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.Filter;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IFolderDisplaySettings;
import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.FoldersDialog;
import com.novell.gw.jclient.application.controls.GWLabeledSeparator;
import com.novell.gw.jclient.application.controls.MinimumSizeKeepingPanel;
import com.novell.gw.jclient.application.controls.WrappedNativeListCellRenderer;
import com.novell.gw.jclient.application.controls.addressbook.ABUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialogController;
import com.novell.gw.jclient.application.controls.filter.ContactFilter;
import com.novell.gw.jclient.application.controls.filter.ContactFilterDialog;
import com.novell.gw.jclient.application.controls.filter.CustomFilter;
import com.novell.gw.jclient.application.controls.filter.FilterDialog;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextArea;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.DisplaySettingsMode;
import com.novell.gw.jclient.application.dialogs.folderproperties.MoreDisplaySettingsDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.displaysettings.DisplaySettingsManager;
import com.novell.gw.jclient.bl.eng_impl.displaysettings.FolderDisplaySettings;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatePanelTemplateDialog
extends ApplicationDialog<ApplicationDialogController> {
    private static Logger logger = Logger.getLogger(CreatePanelTemplateDialog.class);
    private static Insets DEFAULT_INSETS = new Insets(4, 4, 4, 4);
    private static String INITIAL_WEB_PAGE = '<' + StringResources.TYPE_WEB_PAGE_ADDRESS + '>';
    public static int INITIAL_WEB_PAGE_REFRESH_INTERVAL = 10;
    private IPanelDisplaySettings displaySettings;
    private OrientablePanel pnlName;
    private OrientablePanel pnlType;
    private OrientablePanel pnlDisplaySettings;
    private OrientablePanel pnlFilter;
    private OrientablePanel pnlButtons;
    private GWTextField txtPanelName;
    private OrientableLabel lbSelectedFolder;
    private OrientableRadioButton rbFolder;
    private OrientableRadioButton rbWebPage;
    private GWTextField txtWebPage;
    private OrientableComboBox cmbViewBy;
    private OrientableCheckBox cbRefreshWebPage;
    private JSpinner spnWebPageRefreshSpinner;
    private OrientableLabel lbEmptyFilterDescription;
    private OrientableTextArea taFilterDescription;
    private MinimumSizeKeepingPanel pnlFilterDescription;
    private JButton btnChangeFilter;
    private AbstractFolder folder;
    private PersonalAddressBook addressBook;
    private com.novell.gw.jclient.bl.om.filter.Filter filter;
    private com.novell.gw.jclient.bl.om.filter.Filter contactFilter = new ContactFilter(null, false);
    private ActionChangeFolder actionChangeFolder;
    private DisplaySettingsMode mode;
    private boolean isContactFolder;

    public CreatePanelTemplateDialog(JDialog dialog, MVCController parentController, AbstractFolder folder) {
        super((Dialog)dialog, parentController);
        this.setTitle(StringResources.CREATE_PANEL);
        this.folder = folder;
        this.mode = DisplaySettingsMode.FOLDER;
        logger.debug((Object)("creating for folder " + folder));
        this.init();
        this.buildUI();
    }

    @Override
    protected ApplicationDialogController createController(MVCController parentController) {
        return new ApplicationDialogController<CreatePanelTemplateDialog>(this, parentController);
    }

    @Override
    protected void processOkAction(ActionEvent event) {
        if (!this.checkSettings()) {
            return;
        }
        this.writeDisplayOptions();
        boolean result = this.displaySettings.createTemplateDisplaySettingsRec();
        if (result) {
            ((ApplicationDialogController)this.getController()).processCommand(new GlobalCommand(1590, this.displaySettings.getId()));
        }
        super.processOkAction(event);
    }

    private void init() {
        IDataStore currentDataStore = EngineCommandManager.getInstance(GWDialog.getUserGuidFromParentFrame(this)).getCurrentDataStore();
        this.displaySettings = APIWrapperManager.createPanelDisplaySettings(currentDataStore, this.folder.isContactsFolder());
    }

    private void buildUI() {
        this.buildButtonPanel();
        this.buildNamePanel();
        this.buildTypePanel();
        this.buildDisplaySettingsPanel();
        this.buildFilterPanel();
        GWLabeledSeparator filterLabeledSeparator = new GWLabeledSeparator(StringResources.CHOOSE_FILTER_C);
        GWLabeledSeparator displaySettingsLabeledSeparator = new GWLabeledSeparator(StringResources.CHOOSE_DISPLAY_SETTINGS_C);
        Container contentPane = this.getContentPane();
        contentPane.removeAll();
        ((JPanel)contentPane).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        contentPane.add((Component)this.pnlName, c);
        ++c.gridy;
        contentPane.add((Component)this.pnlType, c);
        ++c.gridy;
        contentPane.add((Component)displaySettingsLabeledSeparator, c);
        ++c.gridy;
        c.gridwidth = 2;
        c.weighty = 1.0;
        contentPane.add((Component)this.pnlDisplaySettings, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weighty = 0.0;
        contentPane.add((Component)filterLabeledSeparator, c);
        ++c.gridy;
        c.gridwidth = 2;
        c.weighty = 1.0;
        contentPane.add((Component)this.pnlFilter, c);
        c.gridheight = c.gridy;
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        contentPane.add(this.pnlButtons);
    }

    private void buildButtonPanel() {
        this.pnlButtons = new OrientablePanel(new GridLayout(2, 1, 0, 5));
        this.pnlButtons.add(this.getBtnOk());
        this.pnlButtons.add(this.getBtnCancel());
    }

    private void buildNamePanel() {
        this.pnlName = new OrientablePanel();
        this.txtPanelName = new GWTextField();
        this.txtPanelName.setText(StringResources.NEW_PANEL);
        this.pnlName.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = DEFAULT_INSETS;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.pnlName.add((Component)this.txtPanelName, c);
        Border emptyBorder = BorderFactory.createEmptyBorder();
        this.pnlName.setBorder(BorderFactory.createTitledBorder(emptyBorder, StringResources.NAME_NEW_PANEL_C));
    }

    private void buildTypePanel() {
        this.pnlType = new OrientablePanel();
        this.lbSelectedFolder = new OrientableLabel(this.folder.getName());
        this.actionChangeFolder = new ActionChangeFolder();
        OrientableButton btnChangeFolder = new OrientableButton(this.actionChangeFolder);
        this.rbFolder = new OrientableRadioButton(StringResources.SELECTED_FOLDER_C);
        this.rbWebPage = new OrientableRadioButton(StringResources.SELECTED_WEB_PAGE_C);
        this.rbFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                logger.debug((Object)"rbFolder selected");
                CreatePanelTemplateDialog.this.handleSwitchToFolder();
            }
        });
        this.rbWebPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                logger.debug((Object)"rbWebPage selected");
                CreatePanelTemplateDialog.this.handleSwitchToWebPage();
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbFolder);
        group.add(this.rbWebPage);
        this.rbFolder.setSelected(true);
        this.txtWebPage = new GWTextField(INITIAL_WEB_PAGE);
        this.txtWebPage.setEnabled(false);
        this.txtWebPage.addFocusListener(new WebPageFocusListener());
        this.pnlType.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = DEFAULT_INSETS;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.pnlType.add((Component)new GWLabeledSeparator(StringResources.CHOOSE_FOLDER_OR_WEB_PAGE_C), c);
        c.anchor = 21;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.gridy = 1;
        OrientablePanel pnlFolder = new OrientablePanel();
        pnlFolder.setLayout(new BoxLayout(pnlFolder, 2));
        pnlFolder.add(this.rbFolder);
        pnlFolder.add(this.lbSelectedFolder);
        this.pnlType.add((Component)pnlFolder, c);
        c.gridy = 2;
        OrientablePanel pnlButton = new OrientablePanel();
        pnlButton.setLayout(new BoxLayout(pnlButton, 2));
        pnlButton.add(Box.createRigidArea(new Dimension(20, 0)));
        pnlButton.add(btnChangeFolder);
        this.pnlType.add((Component)pnlButton, c);
        c.gridy = 3;
        OrientablePanel pnlWebPage = new OrientablePanel();
        pnlWebPage.setLayout(new BoxLayout(pnlWebPage, 2));
        pnlWebPage.add(this.rbWebPage);
        this.pnlType.add((Component)pnlWebPage, c);
        c.gridy = 4;
        OrientablePanel pnlText = new OrientablePanel();
        pnlText.setLayout(new BoxLayout(pnlText, 2));
        pnlText.add(Box.createRigidArea(new Dimension(20, 0)));
        pnlText.add(this.txtWebPage);
        this.pnlType.add((Component)pnlText, c);
    }

    private void buildDisplaySettingsPanel() {
        this.pnlDisplaySettings = new OrientablePanel();
        OrientableLabel lbViewBy = new OrientableLabel(StringResources.VIEW_BY_C);
        this.cmbViewBy = new OrientableComboBox();
        this.updateViewByTypes();
        this.cmbViewBy.setRenderer(new ViewByListCellRenderer(this.cmbViewBy.getRenderer()));
        OrientableButton btnMoreSettings = new OrientableButton(new ActionMoreDisplaySettings());
        OrientablePanel pnlGeneral = new OrientablePanel();
        pnlGeneral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(CreatePanelTemplateDialog.DEFAULT_INSETS.top, CreatePanelTemplateDialog.DEFAULT_INSETS.left, CreatePanelTemplateDialog.DEFAULT_INSETS.bottom, CreatePanelTemplateDialog.DEFAULT_INSETS.right);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        pnlGeneral.add((Component)lbViewBy, c);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets.right = 0;
        pnlGeneral.add((Component)this.cmbViewBy, c);
        c.gridx = 2;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        pnlGeneral.add(Box.createRigidArea(new Dimension(this.pnlButtons.getMinimumSize().width, 0)), c);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = DEFAULT_INSETS;
        c.fill = 0;
        c.gridwidth = 2;
        c.anchor = 21;
        pnlGeneral.add((Component)btnMoreSettings, c);
        this.cbRefreshWebPage = new OrientableCheckBox(StringResources.AUTOMATICALLY_REFRESH_WEB_PAGE_EVERY);
        this.cbRefreshWebPage.addItemListener(new AutoRefreshItemListener());
        OrientableLabel lbMinutes = new OrientableLabel(StringResources.MINUTE_S);
        SpinnerNumberModel minutesModel = new SpinnerNumberModel(INITIAL_WEB_PAGE_REFRESH_INTERVAL, 1, 1440, 1);
        this.spnWebPageRefreshSpinner = new OrientableSpinner(minutesModel);
        this.spnWebPageRefreshSpinner.setEnabled(false);
        OrientablePanel pnlWebControls = new OrientablePanel();
        pnlWebControls.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.anchor = 23;
        c.insets = DEFAULT_INSETS;
        c.weighty = 1.0;
        c.gridx = 0;
        pnlWebControls.add((Component)this.cbRefreshWebPage, c);
        ++c.gridx;
        pnlWebControls.add((Component)this.spnWebPageRefreshSpinner, c);
        ++c.gridx;
        c.weightx = 1.0;
        pnlWebControls.add((Component)lbMinutes, c);
        this.pnlDisplaySettings.setLayout(new CardLayout());
        this.pnlDisplaySettings.add((Component)pnlGeneral, "general");
        this.pnlDisplaySettings.add((Component)pnlWebControls, "web");
    }

    private void buildFilterPanel() {
        this.pnlFilter = new OrientablePanel();
        this.btnChangeFilter = new OrientableButton(new ActionChangeFilter());
        this.updateFilterEnablement();
        this.lbEmptyFilterDescription = new OrientableLabel('<' + StringResources.NO_FILTER + '>');
        this.taFilterDescription = new OrientableTextArea();
        this.taFilterDescription.setLineWrap(true);
        this.taFilterDescription.setEditable(false);
        this.taFilterDescription.setBackground(this.pnlFilter.getBackground());
        ColoredScrollPane scrollPane = new ColoredScrollPane(this.taFilterDescription);
        this.pnlFilterDescription = new MinimumSizeKeepingPanel(new CardLayout());
        this.pnlFilterDescription.setMinimalHeight(this.taFilterDescription.getFont().getSize() * 4);
        OrientablePanel pnlEmptyFilter = new OrientablePanel(new BorderLayout(0, 0));
        pnlEmptyFilter.add((Component)this.lbEmptyFilterDescription, "First");
        this.pnlFilterDescription.add((Component)pnlEmptyFilter, "label");
        this.pnlFilterDescription.add((Component)scrollPane, "scroll pane");
        this.updateFilterDescription();
        this.pnlFilter.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, CreatePanelTemplateDialog.DEFAULT_INSETS.left, 0, CreatePanelTemplateDialog.DEFAULT_INSETS.right);
        c.insets.top = 0;
        c.insets.bottom = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 23;
        c.fill = 0;
        c.weightx = 0.0;
        this.pnlFilter.add((Component)this.btnChangeFilter, c);
        c.anchor = 10;
        c.insets.right = 0;
        c.gridx = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.pnlFilter.add((Component)this.pnlFilterDescription, c);
    }

    private void updateViewByTypes() {
        Integer[] newValues;
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.cmbViewBy.getModel();
        int selectedItem = model.getSelectedItem() != null && model.getSelectedItem() instanceof Integer ? (Integer)model.getSelectedItem() : 1;
        switch (this.mode) {
            case FOLDER: {
                newValues = CreatePanelTemplateDialog.getViewByTypes(this.folder);
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected mode: " + (Object)((Object)this.mode)));
            }
        }
        model.removeAllElements();
        for (Integer value : newValues) {
            model.addElement(value);
            if (value != selectedItem) continue;
            model.setSelectedItem(value);
        }
    }

    private static Integer[] getViewByTypes(AbstractFolder folder) {
        assert (folder != null) : "folder is null";
        ArrayList<Integer> results = new ArrayList<Integer>();
        if (ControlsUtils.isViewByCalendarSupported(folder, true)) {
            results.add(6);
        }
        if (ControlsUtils.isViewByCheckListSupported(folder, true)) {
            results.add(7);
        }
        if (ControlsUtils.isViewByConversationSupported(folder, true)) {
            results.add(5);
        }
        if (ControlsUtils.isViewByDetailsSupported(folder, true) || ControlsUtils.isViewByContactDetailsSupported(folder, true)) {
            results.add(1);
        }
        return results.toArray(new Integer[results.size()]);
    }

    private void handleSelectedFolderChange(AbstractFolder theFolder) {
        if (this.folder.isContactsFolder() != theFolder.isContactsFolder()) {
            IDataStore currentDataStore = EngineCommandManager.getInstance(GWDialog.getUserGuidFromParentFrame(this)).getCurrentDataStore();
            this.displaySettings = APIWrapperManager.createPanelDisplaySettings(currentDataStore, theFolder.isContactsFolder());
        }
        this.folder = theFolder;
        this.lbSelectedFolder.setText(this.folder.getName());
        if (this.isContactFolder != this.folder.isContactsFolder()) {
            this.clearFilter();
        }
        this.updateFilterDescription();
        this.updateViewByTypes();
    }

    private void clearFilter() {
        this.isContactFolder = this.folder.isContactsFolder();
        if (this.isContactFolder) {
            boolean isSystem = ABUtils.isSystemABAbstractFolder(this.folder);
            this.filter = new ContactFilter(isSystem);
        } else {
            this.filter = new CustomFilter();
        }
    }

    private void handleSwitchToWebPage() {
        this.mode = DisplaySettingsMode.WEB_PAGE;
        this.updateFilterEnablement();
        this.actionChangeFolder.setEnabled(false);
        this.txtWebPage.setEnabled(true);
        this.addressBook = null;
        this.updateFilterDescription();
        this.updateDisplaySettingsPanel();
    }

    private void handleSwitchToFolder() {
        this.mode = DisplaySettingsMode.FOLDER;
        this.updateFilterEnablement();
        this.actionChangeFolder.setEnabled(true);
        this.txtWebPage.setEnabled(false);
        this.addressBook = null;
        this.handleSelectedFolderChange(this.folder);
        this.updateDisplaySettingsPanel();
    }

    private void updateFilterEnablement() {
        switch (this.mode) {
            case FOLDER: {
                this.btnChangeFilter.setEnabled(true);
                break;
            }
            default: {
                this.btnChangeFilter.setEnabled(false);
            }
        }
    }

    private void updateDisplaySettingsPanel() {
        CardLayout cardLayout = (CardLayout)this.pnlDisplaySettings.getLayout();
        switch (this.mode) {
            case FOLDER: {
                cardLayout.first(this.pnlDisplaySettings);
                break;
            }
            default: {
                cardLayout.last(this.pnlDisplaySettings);
            }
        }
    }

    private void updateFilterDescription() {
        CardLayout cardLayout = (CardLayout)this.pnlFilterDescription.getLayout();
        if (this.filter == null) {
            this.clearFilter();
        }
        if (this.mode == DisplaySettingsMode.FOLDER && (!this.isContactFolder && !this.filter.isEmpty() || this.isContactFolder && this.contactFilter != null && !this.contactFilter.isEmpty())) {
            IDataStore dataStore = EngineCommandManager.getInstance(GWDialog.getUserGuidFromParentFrame(this)).getCurrentDataStore();
            Filter nativeFilter = this.isContactFolder ? new Filter(dataStore.getNativeDataStore(), this.contactFilter.getItemListFilter(), false) : new Filter(dataStore.getNativeDataStore(), this.filter.getItemListFilter(), false);
            String description = nativeFilter.generateDescription();
            this.taFilterDescription.setText(description);
            cardLayout.last(this.pnlFilterDescription);
        } else {
            cardLayout.first(this.pnlFilterDescription);
        }
    }

    private void readDisplayOptions() {
        logger.debug((Object)"reading display options");
        this.cmbViewBy.setSelectedItem(this.displaySettings.getViewMode());
    }

    private void writeDisplayOptions() {
        logger.debug((Object)"writing display options........");
        logger.debug((Object)("mode = " + (Object)((Object)this.mode)));
        logger.debug((Object)("name = " + this.txtPanelName.getText()));
        logger.debug((Object)("folder = " + (this.folder == null ? "null" : this.folder.getName())));
        logger.debug((Object)("view mode = " + this.cmbViewBy.getSelectedItem()));
        logger.debug((Object)("address book = " + this.addressBook));
        this.displaySettings.setName(this.txtPanelName.getText());
        this.displaySettings.setPanelName(this.txtPanelName.getText());
        if (this.mode == DisplaySettingsMode.FOLDER) {
            this.displaySettings.setPanelFolder(this.folder.getNativeFolder());
            this.displaySettings.setViewMode((Integer)this.cmbViewBy.getSelectedItem());
        } else {
            this.displaySettings.setPanelWebPage(this.txtWebPage.getText());
            if (this.cbRefreshWebPage.isSelected()) {
                this.displaySettings.setPanelRefreshInterval((Integer)this.spnWebPageRefreshSpinner.getModel().getValue());
            }
        }
        if (this.mode == DisplaySettingsMode.FOLDER && !this.filter.isEmpty()) {
            if (this.isContactFolder) {
                if (this.contactFilter != null && !this.contactFilter.isEmpty()) {
                    this.displaySettings.setPanelFilter(this.contactFilter.getItemListFilter());
                    logger.debug((Object)"contact filter set");
                }
            } else if (!this.filter.isEmpty()) {
                this.displaySettings.setPanelFilter(this.filter.getItemListFilter());
                logger.debug((Object)"filter set");
            }
        } else {
            logger.debug((Object)"no filter set");
        }
        logger.debug((Object)"........ display options written");
    }

    private boolean checkSettings() {
        String templateName = this.txtPanelName.getText().trim();
        if (templateName.length() == 0) {
            JOptionPane.showMessageDialog(this, StringResources.PLEASE_ENTER_A_PANEL_NAME, StringResources.NOVELL_GROUPWISE, 1);
            return false;
        }
        List<String> names = GWCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController())).getPanelTemplateNames();
        if (names.contains(templateName)) {
            JOptionPane.showMessageDialog(this, StringResources.formatString(StringResources.THE_NAME_HAS_BEEN_ALREADY_USED, templateName) + '\n' + StringResources.PLEASE_ENTER_A_UNIQUE_PANEL_NAME, StringResources.NOVELL_GROUPWISE, 1);
            return false;
        }
        if (this.mode == DisplaySettingsMode.WEB_PAGE && this.txtWebPage.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, StringResources.PLEASE_ENTER_A_WEB_PAGE_ADDRESS, StringResources.NOVELL_GROUPWISE, 1);
            return false;
        }
        return true;
    }

    private com.novell.gw.jclient.bl.om.filter.Filter changeFolderContactFilter(com.novell.gw.jclient.bl.om.filter.Filter filter) {
        com.novell.gw.jclient.bl.om.filter.Filter changedFilter = filter;
        ContactFilterDialog filterDialog = new ContactFilterDialog(this, (MVCController)this.getController(), filter);
        filterDialog.setVisible(true);
        if (filterDialog.isOkActionProcessed()) {
            changedFilter = ((FilterDialog)filterDialog).getFilter();
        }
        return changedFilter;
    }

    private com.novell.gw.jclient.bl.om.filter.Filter changeFolderFilter(com.novell.gw.jclient.bl.om.filter.Filter filter) {
        com.novell.gw.jclient.bl.om.filter.Filter changedFilter = filter;
        FilterDialog filterDialog = new FilterDialog(this, (MVCController)this.getController(), filter);
        filterDialog.setVisible(true);
        if (filterDialog.isOkActionProcessed()) {
            changedFilter = filterDialog.getFilter();
        }
        return changedFilter;
    }

    private class AutoRefreshItemListener
    implements ItemListener {
        private AutoRefreshItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            CreatePanelTemplateDialog.this.spnWebPageRefreshSpinner.setEnabled(e.getStateChange() == 1);
        }
    }

    private class WebPageFocusListener
    extends FocusAdapter {
        private WebPageFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            if (INITIAL_WEB_PAGE.equals(CreatePanelTemplateDialog.this.txtWebPage.getText())) {
                CreatePanelTemplateDialog.this.txtWebPage.setText("");
            }
        }
    }

    private static class ViewByListCellRenderer
    extends WrappedNativeListCellRenderer {
        protected ViewByListCellRenderer(ListCellRenderer renderer) {
            super(renderer);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String localizedText;
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("value class is incorrect. Should be java.lang.Integer, but is " + (value == null ? "null" : value.getClass().getName()));
            }
            switch ((Integer)value) {
                case 6: {
                    localizedText = StringResources.CALENDAR;
                    break;
                }
                case 7: {
                    localizedText = StringResources.TASKLIST;
                    break;
                }
                case 1: {
                    localizedText = StringResources.DETAILS;
                    break;
                }
                case 5: {
                    localizedText = StringResources.DISCUSSION_THREAD;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + value);
                }
            }
            Component rendererComponent = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (rendererComponent instanceof JLabel) {
                ((JLabel)rendererComponent).setText(localizedText);
            }
            return rendererComponent;
        }
    }

    private class ActionMoreDisplaySettings
    extends AbstractAction {
        public ActionMoreDisplaySettings() {
            super(StringResources.MORE_DISPLAY_SETTINGS_D);
        }

        public void actionPerformed(ActionEvent e) {
            CreatePanelTemplateDialog.this.displaySettings.setViewMode((Integer)CreatePanelTemplateDialog.this.cmbViewBy.getSelectedItem());
            DisplaySettingsManager displaySettingsManager = DisplaySettingsManager.getInstance();
            FolderDisplaySettings folderDisplaySettings = displaySettingsManager.createFolderDisplaySettings(CreatePanelTemplateDialog.this.displaySettings);
            folderDisplaySettings.setSettingsMode(CreatePanelTemplateDialog.this.mode);
            MoreDisplaySettingsDialog dialog = new MoreDisplaySettingsDialog((Dialog)CreatePanelTemplateDialog.this, ControlsUtils.getUserGuid(CreatePanelTemplateDialog.this.getController()), CreatePanelTemplateDialog.this.folder.getNativeFolder(), (IFolderDisplaySettings)((Object)CreatePanelTemplateDialog.this.displaySettings));
            dialog.setLocationRelativeTo(dialog.getParent());
            dialog.setVisible(true);
            CreatePanelTemplateDialog.this.readDisplayOptions();
        }
    }

    private class ActionChangeFilter
    extends AbstractAction {
        public ActionChangeFilter() {
            super(StringResources.FILTER_D);
        }

        public void actionPerformed(ActionEvent e) {
            CreatePanelTemplateDialog thisDialog = CreatePanelTemplateDialog.this;
            switch (thisDialog.mode) {
                case FOLDER: {
                    if (CreatePanelTemplateDialog.this.isContactFolder) {
                        thisDialog.contactFilter = CreatePanelTemplateDialog.this.changeFolderContactFilter(thisDialog.contactFilter);
                        break;
                    }
                    thisDialog.filter = CreatePanelTemplateDialog.this.changeFolderFilter(thisDialog.filter);
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected mode: " + (Object)((Object)CreatePanelTemplateDialog.this.mode));
                }
            }
            CreatePanelTemplateDialog.this.updateFilterDescription();
        }
    }

    private class ActionChangeFolder
    extends AbstractAction {
        public ActionChangeFolder() {
            super(StringResources.CHANGE_FOLDER_D);
        }

        public void actionPerformed(ActionEvent e) {
            FoldersDialog foldersDialog = new FoldersDialog(CreatePanelTemplateDialog.this, (MVCController)CreatePanelTemplateDialog.this.getController(), CreatePanelTemplateDialog.this.folder, StringResources.SELECT_THE_FOLDER_BELOW);
            foldersDialog.pack();
            foldersDialog.setLocationRelativeTo(null);
            foldersDialog.setVisible(true);
            if (foldersDialog.isOkActionProcessed()) {
                AbstractFolder selectedFolder = foldersDialog.getSelectedFolder();
                CreatePanelTemplateDialog.this.handleSelectedFolderChange(selectedFolder);
            }
        }
    }
}

