/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.novell.gw.jclient.api.enums.FolderType;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.IColumnAndSortInfo;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IFolderDisplaySettings;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.controls.WrappedNativeListCellRenderer;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.propertymanager.GWPropertyChangeEvent;
import com.novell.gw.jclient.application.controls.propertymanager.GWPropertyChangeListener;
import com.novell.gw.jclient.application.dialogs.folderproperties.DisplaySettingsSaveAsDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.DisplaySettingsSaver;
import com.novell.gw.jclient.application.dialogs.folderproperties.SavablePanel;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewBySettings;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.displaysettings.DisplaySettingsManager;
import com.novell.gw.jclient.bl.eng_impl.utils.APIUtils;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class DisplayPanel
extends SavablePanel
implements GWPropertyChangeListener {
    private static final Logger logger = Logger.getLogger(DisplayPanel.class);
    private JComboBox cmbDisplaySettings = new OrientableComboBox();
    private JButton btnSaveAs = new OrientableButton(new SaveAsAction());
    private JButton btnRestoreDefaults = new OrientableButton(new RestoreDefaultsAction());
    private JButton btnDelete = new OrientableButton(new DeleteAction());
    private JTextArea taDescription = new GWTextArea(4, 20);
    private JCheckBox cbRememberFolderList = new OrientableCheckBox(StringResources.REMEMBER_FOLDER_LIST_OPTIONS);
    private JCheckBox cbDisplayFolderList = new OrientableCheckBox(StringResources.DISPLAY_FOLDER_LIST);
    private JCheckBox cbRemberQuickViewer = new OrientableCheckBox(StringResources.REMEMBER_QUICKVIEWER_VISIBILITY);
    private JCheckBox cbShowQuickViewer = new OrientableCheckBox(StringResources.DISPLAY_QUICKVIEWER);
    private ViewBySettings viewBySettings;
    private boolean adjusting = false;
    private IFolder folder;
    private IFolderDisplaySettings folderDisplaySettings;
    private IFolderDisplaySettings selectedDisplaySettings;
    private Comparator<IFolderDisplaySettings> comparator = new DisplaySettingsComparator();
    private String userGuid;

    public DisplayPanel(IFolder folder, String userGuid) {
        this.folder = folder;
        this.folderDisplaySettings = folder.getDisplaySettings();
        this.userGuid = userGuid;
        this.init();
        this.buildUI();
        this.loadProperties();
    }

    private void init() {
        this.viewBySettings = new ViewBySettings(this.userGuid, this.folder);
        this.cmbDisplaySettings.setRenderer(new DisplaySettingsRenderer(this.cmbDisplaySettings.getRenderer()));
        this.cmbDisplaySettings.addActionListener(new DisplaySettingSelectionListener());
        this.cbRememberFolderList.addChangeListener(new RefreshStateChangeListener(this.cbRememberFolderList, this.cbDisplayFolderList));
        this.cbRemberQuickViewer.addChangeListener(new RefreshStateChangeListener(this.cbRemberQuickViewer, this.cbShowQuickViewer));
        this.loadListOfDisplaySettings();
        this.propertyManager.addPropertyView(this.cbRememberFolderList);
        this.propertyManager.addPropertyView(this.cbDisplayFolderList);
        this.propertyManager.addPropertyView(this.cbRemberQuickViewer);
        this.propertyManager.addPropertyView(this.cbShowQuickViewer);
        this.propertyManager.addPropertyView(this.taDescription);
    }

    private void loadListOfDisplaySettings() {
        ArrayList<IFolderDisplaySettings> list = new ArrayList<IFolderDisplaySettings>();
        list.add(this.folderDisplaySettings);
        IFolderDisplaySettings customDisplaySettings = this.folder.getCustomDisplaySettings();
        if (customDisplaySettings == null) {
            this.btnRestoreDefaults.setEnabled(false);
        } else if (!list.contains(customDisplaySettings)) {
            list.add(customDisplaySettings);
        }
        boolean isHomeFolder = this.folder.getType() == FolderType.USER;
        Enumeration systemDisplaySettings = APIUtils.getDisplaySettingsEnumeration(this.folder.isContactsFolder(), this.userGuid);
        while (systemDisplaySettings.hasMoreElements()) {
            IFolderDisplaySettings displaySettings = (IFolderDisplaySettings)systemDisplaySettings.nextElement();
            if (list.contains(displaySettings)) continue;
            if (isHomeFolder) {
                if (displaySettings.getViewMode() != 8) continue;
                list.add(displaySettings);
                continue;
            }
            list.add(displaySettings);
        }
        Collections.sort(list, this.comparator);
        this.cmbDisplaySettings.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
    }

    public boolean loadProperties() {
        this.cmbDisplaySettings.setSelectedItem(this.folderDisplaySettings);
        this.viewBySettings.setGWPropertyChangeListener(this);
        this.propertyManager.addGWPropertyChangeListener(this);
        return super.loadProperties();
    }

    private void selectDisplaySettings(IFolderDisplaySettings displaySettings) {
        logger.debug((Object)("displaySettings: " + displaySettings));
        if (!(displaySettings instanceof DisplaySettingsSaver)) {
            displaySettings = new DisplaySettingsSaver(displaySettings);
        }
        this.selectedDisplaySettings = displaySettings;
        this.taDescription.setText(displaySettings.getDescription());
        this.viewBySettings.setFolderDisplaySettings(displaySettings);
        this.cbRememberFolderList.setSelected(displaySettings.getFolderTreeApplyPerFolder());
        this.cbDisplayFolderList.setSelected(displaySettings.isFolderTreeVisible());
        this.cbRemberQuickViewer.setSelected(displaySettings.isQuickViewerApplyPerFolder());
        this.cbShowQuickViewer.setSelected(displaySettings.isQuickViewerVisible());
    }

    public boolean isChangedProperties() {
        return this.viewBySettings.isChangedProperties() || super.isChangedProperties();
    }

    public boolean saveProperties() {
        IFolderDisplaySettings displaySettings = this.saveAsProperties();
        boolean result = displaySettings != null && this.folder.linkTo(displaySettings);
        logger.debug((Object)("result: " + result));
        return result;
    }

    private void saveFolderListSettings() {
        boolean changed;
        boolean bl = changed = this.propertyManager.hasChangedProperties(this.cbDisplayFolderList) || this.propertyManager.hasChangedProperties(this.cbRememberFolderList);
        if (changed) {
            this.selectedDisplaySettings.setFolderTreeVisible(this.cbDisplayFolderList.isSelected());
            this.selectedDisplaySettings.setFolderTreeApplyPerFolder(this.cbRememberFolderList.isSelected());
            GWMainAppFrame mainFrame = (GWMainAppFrame)SwingUtilities.getAncestorOfClass(GWMainAppFrame.class, this);
            if (mainFrame != null) {
                boolean isFolderTreeVisible = EngineCommandManager.getInstance(this.userGuid).getAppearanceSettings().isFolderTreeVisible();
                if (mainFrame.getFolder().getNativeFolder().getId() == this.folder.getId() && this.selectedDisplaySettings.getFolderTreeApplyPerFolder()) {
                    mainFrame.setFolderListVisible(isFolderTreeVisible);
                } else if (mainFrame.isVisibleFolderListTree() != isFolderTreeVisible) {
                    mainFrame.setFolderListVisible(isFolderTreeVisible);
                }
            }
        }
    }

    private void saveQuickViewerSettings() {
        boolean changed;
        boolean bl = changed = this.propertyManager.hasChangedProperties(this.cbShowQuickViewer) || this.propertyManager.hasChangedProperties(this.cbRemberQuickViewer);
        if (changed) {
            this.selectedDisplaySettings.setQuickViewerVisible(this.cbShowQuickViewer.isSelected());
            this.selectedDisplaySettings.setQuickViewerApplyPerFolder(this.cbRemberQuickViewer.isSelected());
            GWMainAppFrame mainFrame = (GWMainAppFrame)SwingUtilities.getAncestorOfClass(GWMainAppFrame.class, this);
            if (mainFrame != null) {
                boolean isQuickViewerVisible = EngineCommandManager.getInstance(this.userGuid).getAppearanceSettings().isQuickViewerVisible();
                if (mainFrame.getFolder().getNativeFolder().getId() == this.folder.getId() && this.selectedDisplaySettings.isQuickViewerApplyPerFolder()) {
                    mainFrame.setQuickViewerVisible(this.selectedDisplaySettings.isQuickViewerVisible());
                    mainFrame.showToolbar();
                } else if (mainFrame.isShowQuickViewer() != isQuickViewerVisible) {
                    mainFrame.setQuickViewerVisible(isQuickViewerVisible);
                    mainFrame.showToolbar();
                }
            }
        }
    }

    private IFolderDisplaySettings saveAsProperties() {
        IFolderDisplaySettings newFolderDisplaySettings;
        DisplaySettingsSaveAsDialog dialog = null;
        Window window = SwingUtilities.getWindowAncestor(this);
        String name = this.selectedDisplaySettings.getName();
        String description = this.taDescription.getText();
        if (window instanceof Dialog) {
            dialog = new DisplaySettingsSaveAsDialog((Dialog)window, name, description);
        } else if (window instanceof Frame) {
            dialog = new DisplaySettingsSaveAsDialog((Frame)window, name, description);
        }
        if (dialog != null) {
            dialog.setLocationRelativeTo(window);
            dialog.setVisible(true);
            if (dialog.isOkActionProcessed()) {
                name = dialog.getDisplaySettingsName();
                description = dialog.getDisplaySettingsDescription();
                this.taDescription.setText(description);
            } else {
                return null;
            }
        }
        boolean result = super.saveProperties();
        this.saveQuickViewerSettings();
        this.saveFolderListSettings();
        result = result && this.selectedDisplaySettings.setDescription(description);
        boolean bl = result = result && this.viewBySettings.saveProperties();
        if (this.findDisplaySettingsByName(name) == null) {
            IDataStore currentDataStore = GWCommandManager.getInstance(this.userGuid).getCurrentDataStore();
            IViewDisplaySettings viewDisplaySettings = this.selectedDisplaySettings.asViewDisplaySettings();
            IColumnAndSortInfo columnAndSortInfo = viewDisplaySettings.getColumnAndSortInfo();
            newFolderDisplaySettings = this.folder.isContactsFolder() ? APIWrapperManager.createFolderDisplaySettings(currentDataStore, name, description, this.selectedDisplaySettings.getContactType(), columnAndSortInfo.getVisibleColumns(), columnAndSortInfo.getSortField()) : APIWrapperManager.createFolderDisplaySettings(currentDataStore, name, description, this.selectedDisplaySettings.asViewDisplaySettings().getItemType(), columnAndSortInfo.getVisibleColumns(), columnAndSortInfo.getSortField(), this.selectedDisplaySettings.getBoxType(), this.selectedDisplaySettings.getViewMode());
        } else {
            newFolderDisplaySettings = this.selectedDisplaySettings instanceof DisplaySettingsSaver ? ((DisplaySettingsSaver)this.selectedDisplaySettings).getFolderDisplaySettings() : this.selectedDisplaySettings;
        }
        if (this.selectedDisplaySettings instanceof DisplaySettingsSaver) {
            ((DisplaySettingsSaver)this.selectedDisplaySettings).saveChangedSettings(newFolderDisplaySettings);
        }
        IDataStore dataStore = GWCommandManager.getInstance(this.userGuid).getCurrentDataStore();
        dataStore.writeMemoryCachedData();
        logger.debug((Object)("result: " + result));
        this.propertyManager.readInitialProperties();
        return result ? newFolderDisplaySettings : null;
    }

    private IFolderDisplaySettings findDisplaySettingsByName(String name) {
        int size = this.cmbDisplaySettings.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            IFolderDisplaySettings displaySettings = (IFolderDisplaySettings)this.cmbDisplaySettings.getModel().getElementAt(i);
            if (displaySettings == null || !displaySettings.getName().equals(name)) continue;
            return displaySettings;
        }
        return null;
    }

    private int indexOf(IFolderDisplaySettings displaySettings) {
        ComboBoxModel model = this.cmbDisplaySettings.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!model.getElementAt(i).equals(displaySettings) && !model.getElementAt(i).toString().equals(displaySettings.getName())) continue;
            return i;
        }
        return -1;
    }

    private void restoreDisplaySettings() {
        IFolderDisplaySettings newSettings;
        String folderName = this.folder.getNativeFolder().getName();
        StringBuilder builder = new StringBuilder();
        builder.append(StringResources.formatString(StringResources.DO_Y_WANT_T_RESTORE_T_DEFAULT_SETTINGS_F_T, folderName));
        builder.append("\n");
        IFolderDisplaySettings oldSettings = this.folder.getDisplaySettings();
        builder.append(StringResources.formatString(StringResources.THIS_WILL_REPLACE, oldSettings.getName()));
        int result = JOptionPane.showConfirmDialog(this, builder.toString(), StringResources.CONFIRM_DISPLAY_SETTINGS_RESTORATION, 0);
        if (result == 0 && (newSettings = this.folder.resetCustomDisplaySettings()) != null) {
            int index;
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.cmbDisplaySettings.getModel();
            if (oldSettings.equals(newSettings)) {
                model.removeElement(oldSettings);
            }
            if ((index = this.indexOf(newSettings)) == -1) {
                model.addElement(newSettings);
                this.cmbDisplaySettings.setSelectedItem(newSettings);
            } else {
                this.cmbDisplaySettings.setSelectedIndex(index);
            }
        }
    }

    private void buildUI() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 23;
        constraints.fill = 2;
        constraints.gridwidth = 2;
        this.add((Component)new OrientableLabel(StringResources.SETTING_NAME_C), constraints);
        ++constraints.gridy;
        constraints.gridwidth = 1;
        this.add((Component)this.cmbDisplaySettings, constraints);
        ++constraints.gridx;
        constraints.gridheight = 2;
        constraints.insets.left = 10;
        this.add((Component)this.createSaveDeleteButtonsPanel(), constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(10, 0, 0, 0);
        constraints.fill = 1;
        this.add((Component)this.createDescriptionPanel(), constraints);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        this.add((Component)new OrientableLabel(StringResources.VIEW_BY_C), constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.viewBySettings.getLeftPanel(), constraints);
        ++constraints.gridx;
        constraints.insets.left = 10;
        constraints.gridheight = 3;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.add((Component)this.viewBySettings.getRightPanel(), constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridheight = 1;
        constraints.insets = new Insets(10, 0, 0, 0);
        constraints.fill = 2;
        this.add((Component)this.createFolderListSettingsPanel(), constraints);
        ++constraints.gridy;
        this.add((Component)this.createQuickViewerSettingsPanel(), constraints);
    }

    private JPanel createFolderListSettingsPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 23;
        panel.add((Component)this.cbRememberFolderList, constraints);
        ++constraints.gridy;
        constraints.insets.left = 20;
        panel.add((Component)this.cbDisplayFolderList, constraints);
        return panel;
    }

    private JPanel createQuickViewerSettingsPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 23;
        panel.add((Component)this.cbRemberQuickViewer, constraints);
        ++constraints.gridy;
        constraints.insets.left = 20;
        panel.add((Component)this.cbShowQuickViewer, constraints);
        return panel;
    }

    private JPanel createDescriptionPanel() {
        OrientablePanel panel = new OrientablePanel(new BorderLayout());
        panel.add((Component)new OrientableLabel(StringResources.DESCRIPTION_C), "First");
        panel.add((Component)new OrientableScrollPane(this.taDescription, 20, 31), "Center");
        return panel;
    }

    private JPanel createSaveDeleteButtonsPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 23;
        constraints.fill = 2;
        panel.add((Component)this.btnSaveAs, constraints);
        ++constraints.gridx;
        constraints.insets = new Insets(0, 5, 5, 0);
        panel.add((Component)this.btnDelete, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 2;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.btnRestoreDefaults, constraints);
        return panel;
    }

    public void propertyChanged(GWPropertyChangeEvent event) {
        if (!this.adjusting) {
            if (this.isChangedProperties()) {
                this.cmbDisplaySettings.setSelectedItem(null);
            } else {
                this.cmbDisplaySettings.setSelectedItem(this.folderDisplaySettings);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DisplaySettingsComparator
    implements Comparator<IFolderDisplaySettings> {
        private DisplaySettingsComparator() {
        }

        @Override
        public int compare(IFolderDisplaySettings o1, IFolderDisplaySettings o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(StringResources.DELETE);
        }

        public void actionPerformed(ActionEvent e) {
            IFolderDisplaySettings customDisplaySettings = DisplayPanel.this.folder.getCustomDisplaySettings();
            if (customDisplaySettings != null && DisplayPanel.this.selectedDisplaySettings.equals(DisplaySettingsManager.getInstance().createFolderDisplaySettings(customDisplaySettings))) {
                DisplayPanel.this.restoreDisplaySettings();
            } else {
                DisplayPanel.this.selectedDisplaySettings.deleteSettings();
                DefaultComboBoxModel model = (DefaultComboBoxModel)DisplayPanel.this.cmbDisplaySettings.getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    if (!model.getElementAt(i).toString().equals(DisplayPanel.this.selectedDisplaySettings.getName())) continue;
                    model.removeElementAt(i);
                    break;
                }
            }
        }
    }

    private class RestoreDefaultsAction
    extends AbstractAction {
        private RestoreDefaultsAction() {
            super(StringResources.RESTORE_DEFAULTS);
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.restoreDisplaySettings();
        }
    }

    private class SaveAsAction
    extends AbstractAction {
        private SaveAsAction() {
            super(StringResources.SAVE_AS_D);
        }

        public void actionPerformed(ActionEvent e) {
            IFolderDisplaySettings displaySettings = DisplayPanel.this.saveAsProperties();
            if (displaySettings != null) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)DisplayPanel.this.cmbDisplaySettings.getModel();
                if (DisplayPanel.this.indexOf(displaySettings) == -1) {
                    model.addElement(displaySettings);
                }
                DisplayPanel.this.cmbDisplaySettings.setSelectedItem(displaySettings);
            }
        }
    }

    private class DisplaySettingsRenderer
    extends WrappedNativeListCellRenderer {
        protected DisplaySettingsRenderer(ListCellRenderer renderer) {
            super(renderer);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component rendererComponent = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            IFolderDisplaySettings displaySettings = (IFolderDisplaySettings)value;
            if (displaySettings != null && DisplayPanel.this.folderDisplaySettings.equals(displaySettings)) {
                rendererComponent.setFont(rendererComponent.getFont().deriveFont(1));
            }
            return rendererComponent;
        }
    }

    private class DisplaySettingSelectionListener
    implements ActionListener {
        private DisplaySettingSelectionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.adjusting = true;
            Object o = DisplayPanel.this.cmbDisplaySettings.getSelectedItem();
            if (o instanceof IFolderDisplaySettings) {
                DisplayPanel.this.selectDisplaySettings((IFolderDisplaySettings)o);
            }
            DisplayPanel.this.adjusting = false;
        }
    }

    private class RefreshStateChangeListener
    implements ChangeListener {
        private final JCheckBox stateProvider;
        private final JCheckBox stateUpdateTo;

        private RefreshStateChangeListener(JCheckBox stateProvider, JCheckBox stateUpdateTo) {
            this.stateProvider = stateProvider;
            this.stateUpdateTo = stateUpdateTo;
            this.stateChanged(null);
        }

        public void stateChanged(ChangeEvent e) {
            this.stateUpdateTo.setEnabled(this.stateProvider.isSelected());
        }
    }
}

