/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class SettingsNamePane
extends JComponent {
    private static Logger logger = Logger.getLogger(SettingsNamePane.class);
    private static final String BUTTON_PRESSED_PROPERTY = "buttonPressed";
    private AbstractItem item;
    private Options selectedOptions = null;
    private JTextField tfName;
    private JTextArea taDescription;
    private JButton btnOK;
    private JButton btnCancel;
    private boolean nameChanged = false;

    public static Options showSettingsNamePane(Component theComponent, String theDefaultName, String theDefaultDescription) {
        SettingsNamePane pane = new SettingsNamePane(theDefaultName, theDefaultDescription);
        JDialog dialog = pane.createDialog(theComponent, StringResources.DISPLAY_SETTINGS_SAVE_AS);
        dialog.show();
        dialog.dispose();
        return pane.selectedOptions;
    }

    private JDialog createDialog(Component parentComponent, String title) {
        final BasicDialog dialog = parentComponent instanceof JFrame ? new BasicDialog((Frame)((JFrame)parentComponent), true) : (parentComponent instanceof JDialog ? new BasicDialog((Dialog)((JDialog)parentComponent), true) : new BasicDialog((Frame)null, true));
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        dialog.setTitle(title);
        dialog.setDefaultButton(this.btnOK);
        dialog.setCancelButton(this.btnCancel);
        dialog.pack();
        dialog.setModal(true);
        dialog.setLocationRelativeTo(parentComponent);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                dialog.setVisible(false);
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (dialog.isVisible() && event.getSource() == SettingsNamePane.this && event.getPropertyName().equals(SettingsNamePane.BUTTON_PRESSED_PROPERTY) && event.getNewValue() != null) {
                    dialog.setVisible(false);
                }
            }
        });
        return dialog;
    }

    private SettingsNamePane(String theDefaultName, String theDefaultDescription) throws HeadlessException {
        this.buildUI(theDefaultName, theDefaultDescription);
    }

    private void buildUI(String theDefaultName, String theDefaultDescription) {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tfName = new GWTextField(theDefaultName);
        this.tfName.getDocument().addDocumentListener(new DisplayNameChangeListener());
        this.taDescription = new GWTextArea(3, 10);
        this.taDescription.setText(theDefaultDescription);
        OrientableScrollPane scroll = new OrientableScrollPane(this.taDescription);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 23;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)new JMnemonicLabel(StringResources.DISPLAY_SETTINGS_NAME, this.tfName), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.tfName, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)new OrientableLabel(StringResources.DISPLAY_SETTINGS_DESCRIPTION), constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)scroll, constraints);
        constraints.anchor = 20;
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add(this.createButtonsPanel(), constraints);
        this.tfName.requestFocus();
        this.tfName.setCaretPosition(this.tfName.getDocument().getLength());
    }

    private Component createButtonsPanel() {
        this.btnOK = new JButton(new OKButtonAction());
        this.btnCancel = new JButton(new CancelButtonAction());
        OrientablePanel pnlButtons = new OrientablePanel();
        pnlButtons.setLayout(new GridLayout(0, 2, 7, 0));
        OS.addButtons(pnlButtons, this.btnOK, this.btnCancel);
        OrientablePanel pnlBottom = new OrientablePanel();
        pnlBottom.setLayout(new BorderLayout());
        pnlBottom.add((Component)pnlButtons, "After");
        return pnlBottom;
    }

    private Options getSelectedOptions() {
        return this.selectedOptions;
    }

    private void setSelectedOptions(Options selectedOptions) {
        this.selectedOptions = selectedOptions;
    }

    private void fireButtonPressed(Object theButton) {
        this.firePropertyChange(BUTTON_PRESSED_PROPERTY, null, theButton);
    }

    private Options createSelectedOptins() {
        return new Options(this.tfName.getText(), this.taDescription.getText());
    }

    public void processNameChanged() {
        if (!this.nameChanged) {
            this.nameChanged = true;
            this.taDescription.setText("");
        }
        this.btnOK.setEnabled(this.tfName.getText().length() != 0);
    }

    public static class Options {
        private String name;
        private String description;

        public Options() {
            this("", "");
        }

        public Options(String name, String description) {
            this.description = description;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String toString() {
            return "[name=" + this.name + ", " + "description=" + this.description + ", " + ']';
        }
    }

    private class DisplayNameChangeListener
    implements DocumentListener {
        private DisplayNameChangeListener() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            SettingsNamePane.this.processNameChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            SettingsNamePane.this.processNameChanged();
        }
    }

    private class CancelButtonAction
    extends AbstractAction {
        public CancelButtonAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent e) {
            SettingsNamePane.this.fireButtonPressed(e.getSource());
        }
    }

    private class OKButtonAction
    extends AbstractAction {
        public OKButtonAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent e) {
            SettingsNamePane form = SettingsNamePane.this;
            form.setSelectedOptions(form.createSelectedOptins());
            SettingsNamePane.this.fireButtonPressed(e.getSource());
        }
    }
}

