/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.fontchooser;

import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.OkCancelDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooserDialog
extends OkCancelDialog {
    private JLabel lbPreview;
    private JList listFonts;
    private JList listFontStyles;
    private JList listSizes;
    private String[] fontNamesArray = UIUtils.getSystemFonts();
    private String[] fontStylesArray = new String[]{StringResources.PLAIN, StringResources.BOLD, StringResources.ITALIC, StringResources.BOLD_ITALIC};
    private String[] sizesArray = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "30"};
    private Font font;
    private FontListSelectionListener selectionListener;
    private static final int PREVIEW_LABEL_HEIGHT = 60;

    public FontChooserDialog(Dialog owner) {
        super(owner);
        this.build();
    }

    public FontChooserDialog(Frame owner) {
        super(owner);
        this.build();
    }

    protected void build() {
        this.setTitle(StringResources.SELECT_FONT);
        this.createButtonPanel();
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.insets = new Insets(10, 10, 0, 10);
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        cp.add((Component)this.createMainPanel(), c);
        c.gridy = 1;
        c.insets = new Insets(5, 10, 5, 11);
        c.weighty = 0.0;
        cp.add((Component)this.createButtonPanel(), c);
    }

    private JPanel createMainPanel() {
        int bs = 10;
        this.lbPreview = new OrientableLabel(StringResources.PREVIEW_FONT_AA_BB_CC, 0);
        this.lbPreview.setBackground(Color.white);
        this.lbPreview.setForeground(Color.black);
        this.lbPreview.setOpaque(true);
        this.lbPreview.setBorder(new LineBorder(Color.black));
        int previewLabelWidth = (int)this.lbPreview.getPreferredSize().getWidth();
        this.lbPreview.setMinimumSize(new Dimension(previewLabelWidth, 60));
        this.lbPreview.setPreferredSize(new Dimension(previewLabelWidth, 60));
        this.selectionListener = new FontListSelectionListener();
        this.listFonts = new OrientableList(this.fontNamesArray);
        this.listFonts.setSelectedIndex(0);
        this.listFontStyles = new OrientableList(this.fontStylesArray);
        this.listFontStyles.setSelectedIndex(0);
        this.listSizes = new OrientableList(this.sizesArray);
        this.listSizes.setSelectedIndex(this.sizesArray.length / 2);
        OrientablePanel content = new OrientablePanel(new GridBagLayout());
        content.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(7, 10, 3, 10);
        c.weightx = 0.0;
        c.weighty = 0.0;
        content.add((Component)new OrientableLabel(StringResources.FONT), c);
        ++c.gridx;
        content.add((Component)new OrientableLabel(StringResources.FONT_STYLE), c);
        ++c.gridx;
        content.add((Component)new OrientableLabel(StringResources.SIZE), c);
        c.insets = new Insets(0, bs, bs, 0);
        c.fill = 1;
        c.gridy = 1;
        c.gridx = 0;
        c.weightx = 4.0;
        c.weighty = 1.0;
        c.ipadx = 10;
        content.add((Component)new OrientableScrollPane(this.listFonts), c);
        ++c.gridx;
        c.weightx = 2.0;
        content.add((Component)new OrientableScrollPane(this.listFontStyles), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.insets = new Insets(0, bs, bs, bs);
        content.add((Component)new OrientableScrollPane(this.listSizes), c);
        c.gridy = 2;
        c.gridx = 0;
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        c.insets = new Insets(0, bs, bs, bs);
        c.anchor = 10;
        content.add((Component)this.lbPreview, c);
        return content;
    }

    private JPanel createButtonPanel() {
        OrientablePanel content = new OrientablePanel();
        OS.addButtons(content, this.getBtnOk(), this.getBtnCancel());
        return content;
    }

    public Font getChoosenFont() {
        return this.font;
    }

    public void setFont(Font theFont, String[] theSizes) {
        this.sizesArray = new String[theSizes.length];
        System.arraycopy(theSizes, 0, this.sizesArray, 0, theSizes.length);
        this.listSizes.removeListSelectionListener(this.selectionListener);
        this.listSizes.setModel(new AbstractListModel(){

            public int getSize() {
                return FontChooserDialog.this.sizesArray.length;
            }

            public Object getElementAt(int i) {
                return FontChooserDialog.this.sizesArray[i];
            }
        });
        this.setFont(theFont);
    }

    public void setFont(Font theFont) {
        this.removeListeners();
        if (theFont == null) {
            this.addListeners();
            return;
        }
        super.setFont(theFont);
        for (int i = 0; i < this.fontNamesArray.length; ++i) {
            if (!this.fontNamesArray[i].equals(theFont.getName())) continue;
            this.listFonts.setSelectedIndex(i);
            break;
        }
        int style = theFont.getStyle();
        int index = 0;
        if ((style & 0) != 0) {
            index = 0;
        }
        if ((style & 1) != 0) {
            index = 1;
        }
        if ((style & 2) != 0) {
            index = 2;
        }
        if ((style & 2) != 0 && (style & 1) != 0) {
            index = 3;
        }
        this.listFontStyles.setSelectedIndex(index);
        String s = String.valueOf(theFont.getSize());
        this.listSizes.setSelectedValue(s, true);
        this.font = theFont;
        this.updateView();
        this.addListeners();
    }

    private void addListeners() {
        this.listFonts.addListSelectionListener(this.selectionListener);
        this.listFontStyles.addListSelectionListener(this.selectionListener);
        this.listSizes.addListSelectionListener(this.selectionListener);
    }

    private void removeListeners() {
        this.listFonts.removeListSelectionListener(this.selectionListener);
        this.listFontStyles.removeListSelectionListener(this.selectionListener);
        this.listSizes.removeListSelectionListener(this.selectionListener);
    }

    public void updateView() {
        this.lbPreview.setFont(this.font);
        this.lbPreview.repaint();
        this.listFonts.ensureIndexIsVisible(this.listFonts.getSelectedIndex());
        this.listFontStyles.ensureIndexIsVisible(this.listFontStyles.getSelectedIndex());
        this.listSizes.ensureIndexIsVisible(this.listSizes.getSelectedIndex());
    }

    public void readSelectedFont() {
        String name = (String)this.listFonts.getSelectedValue();
        String sz = (String)this.listSizes.getSelectedValue();
        int index = this.listFontStyles.getSelectedIndex();
        if (name != null && sz != null && index >= 0) {
            int style = 0;
            switch (index) {
                case 0: {
                    style = 0;
                    break;
                }
                case 1: {
                    style = 1;
                    break;
                }
                case 2: {
                    style = 2;
                    break;
                }
                case 3: {
                    style = 3;
                }
            }
            int size = Integer.valueOf(sz);
            this.font = new Font(name, style, size);
            this.updateView();
        }
    }

    protected void processCancelAction(ActionEvent event) {
        super.processCancelAction(event);
        this.font = null;
        this.dispose();
    }

    protected void processOkAction(ActionEvent event) {
        super.processOkAction(event);
        this.dispose();
    }

    protected void processCloseAction(WindowEvent event) {
        super.processCloseAction(event);
        this.dispose();
    }

    public class FontListSelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            FontChooserDialog.this.readSelectedFont();
        }
    }
}

