/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.junkmail;

import com.appframework.utils.OS;
import com.novell.gw.engine.JunkMailList;
import com.novell.gw.jclient.application.GWTable;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTableCellRenderer;
import com.novell.gw.jclient.application.dialogs.junkmail.AddNewEntryDialog;
import com.novell.gw.jclient.application.dialogs.junkmail.HTMLLabel;
import com.novell.gw.jclient.application.dialogs.junkmail.JunkTableModel;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;

abstract class AddressesListPane
extends OrientablePanel {
    private static Logger logger = Logger.getLogger(AddressesListPane.class);
    private JCheckBox cbAddresses = new OrientableCheckBox(StringResources.ADDRESSES);
    private JCheckBox cbDomains = new OrientableCheckBox(StringResources.DOMAINS);
    private JButton btnNew;
    private JButton btnEdit;
    private JButton btnDelete;
    private JButton btnTop;
    private JButton btnBottom;
    private JTable tableEntries;
    private JunkTableModel model;
    private JLabel lbCount = new OrientableLabel("0");
    private JunkMailList junkMailList;
    private int rowSelected = 0;

    public AddressesListPane(JunkMailList junkMailList) {
        this.junkMailList = junkMailList;
        this.model = new JunkTableModel(this.junkMailList);
        this.buildUI();
        this.updateCount();
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                AddressesListPane.this.updateTableSelection();
            }
        });
    }

    private void buildUI() {
        this.setBorder(new EmptyBorder(5, 10, 10, 10));
        ActionListener filter = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddressesListPane.this.applyFilter();
            }
        };
        this.cbAddresses.addActionListener(filter);
        this.cbDomains.addActionListener(filter);
        this.cbAddresses.setSelected(true);
        this.cbDomains.setSelected(true);
        this.btnNew = new JButton(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AddressesListPane.this.addNewEntry();
            }
        });
        this.btnEdit = new JButton(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AddressesListPane.this.editSelectedEntry();
            }
        });
        this.btnDelete = new JButton(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AddressesListPane.this.deleteEntry();
            }
        });
        this.btnNew.setText(StringResources.NEW_D);
        this.btnEdit.setText(StringResources.EDIT_D);
        this.btnDelete.setText(StringResources.DELETE);
        if (!OS.isMacOS()) {
            this.btnNew.setMnemonic(StringResources.getMnemonic(StringResources.NEW_D));
            this.btnEdit.setMnemonic(StringResources.getMnemonic(StringResources.EDIT_D));
            this.btnDelete.setMnemonic(StringResources.getMnemonic(StringResources.DELETE));
        }
        this.btnTop = new JButton(this.createTopMoveAction());
        this.btnBottom = new JButton(this.createBottomMoveAction());
        this.btnEdit.setEnabled(false);
        this.btnDelete.setEnabled(false);
        this.btnTop.setEnabled(false);
        this.btnBottom.setEnabled(false);
        this.createTable();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 0;
        c.gridy = 0;
        c.insets.top = 5;
        c.insets.right = 7;
        this.add((Component)new OrientableLabel(StringResources.SHOW_C), c);
        c.anchor = 21;
        c.insets.right = 10;
        c.weightx = 0.0;
        this.add((Component)this.createChecksPanel(), c);
        c.anchor = 23;
        c.insets.right = 10;
        c.weightx = 0.0;
        this.add((Component)this.btnNew, c);
        this.add((Component)this.btnEdit, c);
        this.add((Component)this.btnDelete, c);
        c.insets.right = 0;
        c.weightx = 1.0;
        this.add((Component)this.createMoveButtonsPanel(), c);
        c.anchor = 21;
        c.fill = 1;
        c.gridwidth = 0;
        ++c.gridy;
        c.insets.top = 10;
        c.insets.bottom = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        OrientableScrollPane scroll = new OrientableScrollPane(this.tableEntries);
        scroll.getViewport().setBackground(Color.WHITE);
        this.add((Component)scroll, c);
        c.anchor = 21;
        c.fill = 2;
        ++c.gridy;
        c.insets.top = 0;
        c.insets.bottom = 0;
        c.weighty = 0.0;
        this.add((Component)this.createStatusPanel(), c);
    }

    private void createTable() {
        this.tableEntries = new GWTable(this.model);
        this.tableEntries.setModel(this.model);
        this.model.setTableHeader(this.tableEntries.getTableHeader());
        this.tableEntries.setDefaultRenderer(Object.class, new OrientableTableCellRenderer());
        this.tableEntries.setSelectionMode(0);
        this.tableEntries.setShowGrid(false);
        JTableHeader tableHeader = this.tableEntries.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        this.tableEntries.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                boolean selection = AddressesListPane.this.tableEntries.getSelectedRow() > -1;
                AddressesListPane.this.btnEdit.setEnabled(selection);
                AddressesListPane.this.btnDelete.setEnabled(selection);
                AddressesListPane.this.btnTop.setEnabled(selection);
                AddressesListPane.this.btnBottom.setEnabled(selection);
                int rowIndex = AddressesListPane.this.tableEntries.getSelectedRow();
                if (rowIndex != -1) {
                    AddressesListPane.this.rowSelected = rowIndex;
                }
            }
        });
        if (OS.isMacOS()) {
            Dimension size = new Dimension(20, PLAFChanger.getFontSize() + 10);
            tableHeader.setSize(size);
            tableHeader.setPreferredSize(size);
            tableHeader.setMinimumSize(size);
        }
        tableHeader.getColumnModel().getColumn(0).setCellRenderer(new IconRenderer());
        TableColumnModel columnModel = this.tableEntries.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setMaxWidth(22);
        column.setMinWidth(22);
        column.setResizable(false);
        column = columnModel.getColumn(3);
        column.setMaxWidth(100);
        column.setMinWidth(50);
        this.tableEntries.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (OS.isDoubleClick(e)) {
                    AddressesListPane.this.editSelectedEntry();
                }
            }
        });
        this.updateTableSelection();
    }

    private JPanel createChecksPanel() {
        OrientablePanel content = new OrientablePanel();
        content.setLayout(new GridLayout(-1, 1, 0, 0));
        content.add(this.cbAddresses);
        content.add(this.cbDomains);
        return content;
    }

    private JPanel createMoveButtonsPanel() {
        OrientablePanel content = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        content.add((Component)this.btnTop, c);
        content.add((Component)this.btnBottom, c);
        return content;
    }

    private JPanel createStatusPanel() {
        OrientablePanel content = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridx = 0;
        c.gridy = 0;
        content.add(new OrientableLabel(StringResources.TOTAL));
        c.anchor = 22;
        c.gridx = 0;
        c.gridy = 1;
        content.add((Component)this.lbCount, c);
        OrientablePanel panel = new OrientablePanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        Dimension size = new Dimension(2, 40);
        panel.setPreferredSize(size);
        panel.setMinimumSize(size);
        panel.setMaximumSize(size);
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 2;
        c.insets.left = 10;
        c.insets.right = 10;
        c.weighty = 1.0;
        content.add((Component)panel, c);
        c.fill = 2;
        c.gridx = 2;
        c.gridheight = 1;
        c.insets.left = 0;
        c.insets.right = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        content.add((Component)new HTMLLabel(this.getPaneComment()), c);
        return content;
    }

    private void addNewEntry() {
        int result;
        String value = AddNewEntryDialog.show(this, "");
        if (value != null && (result = this.junkMailList.addItem(value)) != -1) {
            this.updateTableSelection();
        }
    }

    private void editSelectedEntry() {
        int row = this.tableEntries.getSelectedRow();
        String entry = this.junkMailList.getItemAddress(row);
        String result = entry.indexOf(64) == -1 ? AddNewEntryDialog.show((Component)this, entry, 2) : AddNewEntryDialog.show((Component)this, entry, 1);
        if (result != null) {
            boolean b = this.junkMailList.deleteItem(row);
            this.junkMailList.addItem(result);
            this.tableEntries.invalidate();
        }
    }

    private void deleteEntry() {
        this.junkMailList.deleteItem(this.tableEntries.getSelectedRow());
        this.updateTableSelection();
    }

    private void applyFilter() {
        int addressTypeFilter = 0;
        addressTypeFilter = this.cbAddresses.isSelected() && this.cbDomains.isSelected() ? 0 : (this.cbDomains.isSelected() ? 2 : (this.cbAddresses.isSelected() ? 1 : 8));
        logger.debug((Object)("addressTypeFilter: " + addressTypeFilter));
        this.junkMailList.setAddressTypeFilter(addressTypeFilter);
        this.updateTableSelection();
    }

    public void updateTableSelection() {
        ((AbstractTableModel)this.tableEntries.getModel()).fireTableDataChanged();
        int rowIndex = this.tableEntries.getSelectedRow();
        int rowCount = this.tableEntries.getRowCount();
        if (rowCount != 0 && rowIndex == -1) {
            rowIndex = this.rowSelected >= rowCount ? rowCount - 1 : this.rowSelected;
            this.tableEntries.setRowSelectionInterval(rowIndex, rowIndex);
        }
    }

    private void selectNearestRow(int theIndex) {
        if (theIndex >= this.junkMailList.getSize()) {
            --theIndex;
        }
        if (theIndex >= 0) {
            this.tableEntries.setRowSelectionInterval(theIndex, theIndex);
        }
    }

    private void updateCount() {
        this.lbCount.setText(String.valueOf(this.tableEntries.getRowCount()));
    }

    protected abstract AbstractAction createTopMoveAction();

    protected abstract AbstractAction createBottomMoveAction();

    protected abstract String getPaneComment();

    private static class IconRenderer
    extends OrientableLabel
    implements TableCellRenderer {
        public IconRenderer() {
            this.setBorder(new EmptyBorder(0, 5, 0, 3));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    protected final class MoveToTrustAction
    extends MoveEntryAction {
        public MoveToTrustAction() {
            super(1, StringResources.MOVE_TO_TRUST);
        }
    }

    protected final class MoveToBlockAction
    extends MoveEntryAction {
        public MoveToBlockAction() {
            super(2, StringResources.MOVE_TO_BLOCK);
        }
    }

    protected final class MoveToJunkAction
    extends MoveEntryAction {
        public MoveToJunkAction() {
            super(3, StringResources.MOVE_TO_JUNK);
        }
    }

    private abstract class MoveEntryAction
    extends AbstractAction {
        private int type;

        public MoveEntryAction(int type, String name) {
            super(name);
            this.type = type;
        }

        public void actionPerformed(ActionEvent e) {
            int selectedRow = AddressesListPane.this.tableEntries.getSelectedRow();
            AddressesListPane.this.junkMailList.moveItem(selectedRow, this.type);
            AddressesListPane.this.updateTableSelection();
        }
    }
}

