/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.passworddialog;

import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.passworddialog.PasswordPanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class PasswordChangeDialog
extends GWDialog {
    private PasswordPanel passwordPanel;
    private boolean changeOnlineFromCaching = false;
    private boolean performChange = true;
    private boolean disableOldPass = false;
    private String userGuid;

    public PasswordChangeDialog(JDialog parent, String theTitle, boolean changeOnlineFromCaching) {
        super(parent, true);
        this.userGuid = EngineCommandManager.getUserGuid();
        this.changeOnlineFromCaching = changeOnlineFromCaching;
        this.performChange = true;
        this.init();
        this.build();
        this.setTitle(theTitle);
        this.pack();
        this.validateSize();
    }

    public PasswordChangeDialog(JFrame parent, String theTitle, boolean performChange, boolean disableOldPass) {
        super(parent);
        this.changeOnlineFromCaching = false;
        this.performChange = performChange;
        this.disableOldPass = disableOldPass;
        this.userGuid = EngineCommandManager.getUserGuid();
        this.build();
        this.setTitle(theTitle);
        this.pack();
        this.validateSize();
    }

    public PasswordChangeDialog(JDialog parentDialog, String userGuid) {
        super(parentDialog);
        this.userGuid = userGuid;
        this.init();
        this.build();
    }

    private void init() {
        if (!this.changeOnlineFromCaching) {
            DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
            this.disableOldPass = !dataStoreSettings.isPasswordSet();
        }
    }

    private void build() {
        EngineMode mode = EngineCommandManager.getCurrentMode();
        if (mode == EngineMode.ONLINE) {
            this.setTitle(StringResources.CHANGE_ONLINE_MAILBOX_PASSWORD);
        } else if (mode == EngineMode.CACHING) {
            this.setTitle(StringResources.CHANGE_CACHING_MAILBOX_PASSWORD);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.passwordPanel = new PasswordPanel(this.changeOnlineFromCaching, this.performChange, this.disableOldPass, this.userGuid);
        this.getContentPane().add((Component)this.passwordPanel, "Center");
    }

    public String getOldPass() {
        return this.passwordPanel.getOldPassword();
    }

    public String getNewPass() {
        return this.passwordPanel.getNewPassword();
    }

    private void validateSize() {
        Dimension size = this.getSize();
        if (size.width < 50) {
            this.setSize(400, 200);
        }
    }

    public boolean wasCancelled() {
        return this.passwordPanel.wasCancelled();
    }
}

