/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.passworddialog;

import com.appframework.utils.OS;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.application.controls.AbstractPasswordChangePanel;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class PasswordPanel
extends AbstractPasswordChangePanel {
    private static Logger logger = Logger.getLogger(PasswordPanel.class);
    private JPanel pnlButtons;
    private JButton btnOK;
    private JButton btnCancel;
    private boolean cancelled = true;

    public PasswordPanel(boolean changeOnline, boolean performChange, boolean disableOldPass, String userGuid) {
        super(changeOnline, performChange, disableOldPass, userGuid);
    }

    protected void buildComponents() {
        super.buildComponents();
        this.pnlButtons = new OrientablePanel();
        this.btnOK = new JButton(new ActionOk());
        this.btnCancel = new JButton(new ActionCancel());
        this.btnOK.setEnabled(false);
        OS.addButtons(this.pnlButtons, this.btnOK, this.btnCancel);
        this.btnCancel.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PasswordPanel.this.btnCancel.getAction().actionPerformed(e);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    protected void layoutComponents() {
        super.layoutComponents();
        this.constraints.gridx = 0;
        this.constraints.gridwidth = 2;
        ++this.constraints.gridy;
        this.constraints.fill = 0;
        this.constraints.weightx = 0.0;
        this.constraints.anchor = 10;
        this.add((Component)this.pnlButtons, this.constraints);
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    protected void handleNewPasswordDontMatch() {
        super.handleNewPasswordDontMatch();
        this.btnOK.setEnabled(false);
        this.getRootPane().setDefaultButton(this.btnCancel);
    }

    protected void handleNewPasswordMatch() {
        super.handleNewPasswordMatch();
        this.btnOK.setEnabled(true);
        this.getRootPane().setDefaultButton(this.btnOK);
    }

    private void changePassword() {
        block6: {
            if (this.performChange) {
                try {
                    if (EngineCommandManager.getCurrentMode() == EngineMode.CACHING && this.changeOnline) {
                        EngineCommandManager.setOnlinePassword(this.getOldPassword(), this.getNewPassword());
                        ControlsUtils.getWindowForComponent(this).dispose();
                        break block6;
                    }
                    if (!GWCommandManager.getInstance(this.userGuid).setSecurityPasswordOptions(this.getOldPassword(), this.getNewPassword(), null, null)) {
                        JOptionPane.showMessageDialog(this, StringResources.PASSWORD_WAS_NOT_CHANGED, StringResources.ERROR, 0);
                        return;
                    }
                    ControlsUtils.getWindowForComponent(this).dispose();
                }
                catch (GWCommandException ee) {
                    logger.error((Object)ee, (Throwable)ee);
                    ErrorDialog.processGWException(ee, this);
                    this.clearFields();
                }
            } else {
                ControlsUtils.getWindowForComponent(this).dispose();
            }
        }
    }

    private class ActionCancel
    extends AbstractAction {
        public ActionCancel() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent e) {
            PasswordPanel.this.cancelled = true;
            ControlsUtils.getWindowForComponent(PasswordPanel.this).dispose();
        }
    }

    private class ActionOk
    extends AbstractAction {
        public ActionOk() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent e) {
            PasswordPanel.this.cancelled = false;
            PasswordPanel.this.changePassword();
        }
    }
}

