/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.appframework.utils.UIUtils;
import com.novell.gw.engine.Filter;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.dialogs.rules.CategoryConditionField;
import com.novell.gw.jclient.application.dialogs.rules.ConstantListConditionField;
import com.novell.gw.jclient.application.dialogs.rules.DateConditionField;
import com.novell.gw.jclient.application.dialogs.rules.RowPaneInfo;
import com.novell.gw.jclient.application.dialogs.rules.TextConditionField;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.apache.log4j.Logger;

public abstract class AbstractConditionField {
    private static Logger logger = Logger.getLogger(AbstractConditionField.class);
    private String name;
    protected ConditionButton btnCondition = new ConditionButton();
    protected JPopupMenu popupCondition = new GWPopupMenu();
    protected Filter.RowInfo rowInfo;
    protected Filter.FilterData fieldData;
    protected Filter filter;

    public AbstractConditionField(Filter.FilterData fieldData, Filter theFilter) {
        this.name = fieldData.getDisplayText();
        this.fieldData = fieldData;
        this.filter = theFilter;
        this.btnCondition.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JButton btnEvent = (JButton)e.getSource();
                AbstractConditionField.this.popupCondition.show(btnEvent, 0, 0);
            }
        });
        this.btnCondition.setIcon(ImageResources.ADV_FILTER_UP_DOWN);
        this.btnCondition.setHorizontalTextPosition(10);
        UIUtils.setButtonPreferedSize(this.btnCondition, new String[]{">= "});
        this.btnCondition.setOperator(this.filter.getValidOperators(this.fieldData.getId())[0]);
    }

    protected Filter.ValidValueType getValidValueType() {
        return this.filter.getValidValueType(this.fieldData.getId(), this.btnCondition.getOperator().getId());
    }

    protected ValidValueWrapper[] getValidValues() {
        Filter.FilterData[] validValues = this.getValidValueType().getValidValues();
        ValidValueWrapper[] result = new ValidValueWrapper[validValues.length];
        for (int i = 0; i < validValues.length; ++i) {
            result[i] = new ValidValueWrapper(validValues[i]);
        }
        return result;
    }

    public abstract Container getConditionPane();

    protected ValidValueWrapper getSelectedValue() {
        Filter.FilterValue value = this.rowInfo.getValue().getValue();
        Filter filter = this.filter;
        filter.getClass();
        Filter.FilterData filterData = new Filter.FilterData(filter, value.getId(), value.getStringValue());
        ValidValueWrapper selectedValue = new ValidValueWrapper(filterData);
        return selectedValue;
    }

    public String toString() {
        return this.name;
    }

    protected void updateRowInfo() {
        int id = this.rowInfo.getOperator().getId();
        MenuElement[] subElements = this.popupCondition.getSubElements();
        for (int i = 0; i < subElements.length; ++i) {
            ConditionAction action;
            JMenuItem menuItem;
            MenuElement subElement = subElements[i];
            if (!(subElement instanceof JMenuItem) || !((menuItem = (JMenuItem)subElement).getAction() instanceof ConditionAction) || (action = (ConditionAction)menuItem.getAction()).getOperator().getId() != id) continue;
            menuItem.doClick();
        }
    }

    public void setRowInfo(Filter.RowInfo rowInfo) {
        this.rowInfo = rowInfo;
    }

    public RowPaneInfo getRowInfo() {
        RowPaneInfo rowInfo = new RowPaneInfo();
        rowInfo.setOperatorID(this.btnCondition.getOperator().getId());
        rowInfo.setFieldID(this.fieldData.getId());
        return rowInfo;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractConditionField)) {
            return false;
        }
        AbstractConditionField value = (AbstractConditionField)obj;
        return value.fieldData.getId() == this.fieldData.getId();
    }

    protected void buildPopup() {
        ButtonGroup group = new ButtonGroup();
        Filter.FilterData[] validOperators = this.filter.getValidOperators(this.fieldData.getId());
        for (int i = 0; i < validOperators.length; ++i) {
            JMenuItem menuItem = MenuItemFactory.createCkeckBoxMenuItem(new ConditionAction(validOperators[i], null));
            if (i == 0) {
                menuItem.doClick();
            }
            this.popupCondition.add(menuItem);
            group.add(menuItem);
        }
        if (this.rowInfo != null) {
            this.updateRowInfo();
        }
    }

    protected void operatorChanged(Filter.FilterData operator) {
    }

    public static AbstractConditionField createConditionField(Filter.FilterData fieldData, Filter theFilter, String userGuid) {
        Filter.ValidValueType validValueType = theFilter.getValidValueType(fieldData.getId(), theFilter.getValidOperators(fieldData.getId())[0].getId());
        if (validValueType.getType() == 2) {
            return new TextConditionField(fieldData, theFilter);
        }
        if (validValueType.getType() == 1) {
            return new ConstantListConditionField(fieldData, theFilter);
        }
        if (validValueType.getType() == 7) {
            return new CategoryConditionField(fieldData, theFilter, userGuid);
        }
        return new DateConditionField(fieldData, theFilter);
    }

    protected static class ValidValueWrapper {
        Filter.FilterData validValue;

        public ValidValueWrapper(Filter.FilterData validValue) {
            this.validValue = validValue;
        }

        public String toString() {
            return this.validValue.getDisplayText();
        }

        public Filter.FilterData getValue() {
            return this.validValue;
        }

        public int getValueId() {
            return this.validValue.getId();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ValidValueWrapper)) {
                return false;
            }
            ValidValueWrapper o = (ValidValueWrapper)obj;
            return this.getValueId() == o.getValueId();
        }
    }

    protected static class ConditionButton
    extends OrientableButton {
        private Filter.FilterData operator;

        public Filter.FilterData getOperator() {
            return this.operator;
        }

        public void setOperator(Filter.FilterData operator) {
            this.operator = operator;
        }
    }

    protected class ConditionAction
    extends AbstractAction {
        private Filter.FilterData operator;

        ConditionAction(String name, Icon icon) {
            super(name, icon);
        }

        ConditionAction(Filter.FilterData operator, Icon icon) {
            super(operator.getDisplayText(), icon);
            this.operator = operator;
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            String text = menuItem.getText();
            int index = text.indexOf(9);
            if (index == -1) {
                index = text.indexOf("\\t");
            }
            if (index != -1) {
                text = text.substring(0, index);
            }
            AbstractConditionField.this.btnCondition.setText(text);
            AbstractConditionField.this.btnCondition.setOperator(this.operator);
            AbstractConditionField.this.operatorChanged(this.operator);
        }

        public Filter.FilterData getOperator() {
            return this.operator;
        }
    }
}

