/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.appframework.utils.OS;
import com.novell.gw.engine.Filter;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;

public class AllFilterFieldsDialog
extends GWDialog {
    private Filter filter;
    private JList listFields = new OrientableList();

    public AllFilterFieldsDialog(JDialog theDialog, Filter filter) {
        super(theDialog, true);
        this.filter = filter;
        this.setTitle(StringResources.All_FILTER_FIELDS);
        this.buildUI();
    }

    private void buildUI() {
        Filter.FilterData[] allValidFields = this.filter.getAllValidFields();
        FieldWrapper[] fieldWrapper = new FieldWrapper[allValidFields.length];
        for (int i = 0; i < allValidFields.length; ++i) {
            fieldWrapper[i] = new FieldWrapper(allValidFields[i]);
        }
        this.listFields.setListData(fieldWrapper);
        this.listFields.setVisibleRowCount(0);
        this.listFields.setSelectedIndex(0);
        this.listFields.setLayoutOrientation(1);
        this.listFields.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (OS.isDoubleClick(e)) {
                    AllFilterFieldsDialog.this.setActionCompleteSuccessfully(true);
                    AllFilterFieldsDialog.this.dispose();
                }
            }
        });
        JPanel pnlContent = (JPanel)this.getContentPane();
        pnlContent.setLayout(new BorderLayout(10, 0));
        OrientablePanel pnlTitle = new OrientablePanel(new FlowLayout(3));
        pnlTitle.add(new OrientableLabel(StringResources.FIELDS_D));
        pnlContent.add((Component)pnlTitle, "North");
        pnlContent.add((Component)new OrientableScrollPane(this.listFields), "Center");
        OrientablePanel buttonPanel = new OrientablePanel(new FlowLayout(4));
        OS.addButtons(buttonPanel, this.btnOK, this.btnCancel);
        pnlContent.add((Component)buttonPanel, "South");
        pnlContent.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        pnlContent.setPreferredSize(new Dimension(400, 300));
    }

    public void showMe() {
        this.toFront();
        super.showMe();
        this.toFront();
    }

    public Filter.FilterData getSelectedField() {
        return ((FieldWrapper)this.listFields.getSelectedValue()).filterData;
    }

    private static class FieldWrapper {
        private Filter.FilterData filterData;

        public FieldWrapper(Filter.FilterData filterData) {
            this.filterData = filterData;
        }

        public String toString() {
            return this.filterData.getDisplayText();
        }
    }
}

