/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.novell.gw.engine.Filter;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.SingleDateSelector;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.dialogs.rules.AbstractConditionField;
import com.novell.gw.jclient.application.dialogs.rules.RowPaneInfo;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Calendar;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;

class DateConditionField
extends AbstractConditionField {
    private JPanel pnlCondition;
    private JPanel pnlContent = new OrientablePanel(new BorderLayout(5, 0));
    private JComboBox cbDate = new OrientableComboBox();
    private JSpinner spDate = new OrientableSpinner();
    private SingleDateSelector singleDateSelector = new SingleDateSelector();

    public DateConditionField(Filter.FilterData filterData, Filter theFilter) {
        super(filterData, theFilter);
        ((JSpinner.DefaultEditor)this.spDate.getEditor()).getTextField().setColumns(3);
        this.singleDateSelector.setIcon(ImageResources.ICON_ACT_VIEW_CALENDAR);
    }

    public Container getConditionPane() {
        if (this.pnlCondition == null) {
            this.pnlCondition = new OrientablePanel(new BorderLayout(5, 0));
            this.buildUI();
            if (this.rowInfo != null) {
                this.updateRowInfo();
            }
        }
        return this.pnlContent;
    }

    protected void updateRowInfo() {
        super.updateRowInfo();
        if (this.getValidValueType().getType() == 3) {
            Calendar today = GWCalendarUtils.getToday();
            today.setTime(this.rowInfo.getValue().getValue().getDate());
            this.singleDateSelector.setDate(today);
        } else {
            this.spDate.setValue(new Integer(this.rowInfo.getValue().getValue().getDateOffset()));
            this.cbDate.setSelectedItem(this.getSelectedValue());
        }
    }

    private void buildUI() {
        this.buildPopup();
        this.rebuildContent(this.getValidValueType().getType());
        this.pnlContent.add((Component)this.btnCondition, "Before");
    }

    protected void operatorChanged(Filter.FilterData operator) {
        this.rebuildContent(this.getValidValueType().getType());
    }

    private void rebuildContent(int contentType) {
        this.pnlContent.remove(this.pnlCondition);
        this.pnlCondition.removeAll();
        this.cbDate.removeAllItems();
        this.singleDateSelector.setDate(GWCalendarUtils.getToday());
        switch (contentType) {
            case 4: {
                this.spDate.setValue(new Integer(1));
                this.pnlCondition.add((Component)this.spDate, "Before");
                this.cbDate.setModel(new DefaultComboBoxModel<AbstractConditionField.ValidValueWrapper>(this.getValidValues()));
                this.pnlCondition.add((Component)this.cbDate, "Center");
                break;
            }
            case 5: {
                this.spDate.setValue(new Integer(0));
                this.pnlCondition.add((Component)this.spDate, "Before");
                this.cbDate.setModel(new DefaultComboBoxModel<AbstractConditionField.ValidValueWrapper>(this.getValidValues()));
                this.pnlCondition.add((Component)this.cbDate, "Center");
                break;
            }
            case 3: {
                this.pnlCondition.add((Component)this.singleDateSelector, "Center");
            }
        }
        this.pnlContent.add((Component)this.pnlCondition, "Center");
        this.pnlContent.updateUI();
    }

    public RowPaneInfo getRowInfo() {
        RowPaneInfo rowInfo = super.getRowInfo();
        int valueType = this.getValidValueType().getType();
        rowInfo.setValueType(valueType);
        Filter.FilterValue filterValue = new Filter.FilterValue(this.filter);
        if (valueType == 3) {
            filterValue.setDate(this.singleDateSelector.getDate().getTime());
        } else {
            AbstractConditionField.ValidValueWrapper selectedItem = (AbstractConditionField.ValidValueWrapper)this.cbDate.getSelectedItem();
            Integer value = (Integer)this.spDate.getValue();
            filterValue.setDateOffset(value.intValue());
            filterValue.setStringValue(selectedItem.toString());
            filterValue.setId(selectedItem.getValueId());
        }
        rowInfo.setValue(filterValue);
        return rowInfo;
    }
}

