/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.rules.OperatorButton;
import com.novell.gw.jclient.application.dialogs.rules.RowPane;
import com.novell.gw.jclient.application.dialogs.rules.RowPaneInfo;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

class GroupPane
extends OrientablePanel {
    private boolean isFirstGroup;
    private JPanel pnlRows = new OrientablePanel(new GridLayout(0, 1, 0, 10));
    private JPopupMenu popupAddGroup = new GWPopupMenu();
    private OperatorButton btnAddGroup = new OperatorButton();

    private GroupPane(boolean firstGroup) {
        super(new BorderLayout(0, 5));
        this.pnlRows.setBorder(BorderFactory.createEtchedBorder());
        this.isFirstGroup = firstGroup;
        this.buildUI();
    }

    public GroupPane(boolean firstGroup, List theRows) {
        this(firstGroup);
        int nSize = theRows.size();
        for (int i = 0; i < nSize; ++i) {
            this.pnlRows.add((RowPane)theRows.get(i));
        }
        this.pnlRows.updateUI();
    }

    public void setGroupOperator(int groupOperator) {
        this.btnAddGroup.setOperator(groupOperator);
    }

    public int getGroupOperator() {
        return this.btnAddGroup.getOperator();
    }

    private void buildUI() {
        if (!this.isFirstGroup) {
            OrientablePanel pnlButton = new OrientablePanel(new FlowLayout(1));
            ButtonGroup group = new ButtonGroup();
            JMenuItem menuItem = MenuItemFactory.createCkeckBoxMenuItem(new AndOrAction(0));
            menuItem.setText(StringResources.AND);
            this.popupAddGroup.add(menuItem);
            group.add(menuItem);
            menuItem.setSelected(true);
            menuItem = MenuItemFactory.createCkeckBoxMenuItem(new AndOrAction(1));
            menuItem.setText(StringResources.OR);
            this.popupAddGroup.add(menuItem);
            group.add(menuItem);
            this.btnAddGroup.setAction(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    GroupPane.this.popupAddGroup.show((JComponent)e.getSource(), 0, 0);
                }
            });
            this.btnAddGroup.setHorizontalTextPosition(10);
            this.btnAddGroup.setOperator(0);
            this.btnAddGroup.setIcon(ImageResources.ADV_FILTER_UP_DOWN);
            pnlButton.add(this.btnAddGroup);
            this.add((Component)pnlButton, "North");
        }
        this.add((Component)this.pnlRows, "Center");
    }

    public boolean isFirstGroup() {
        return this.isFirstGroup;
    }

    public void deleteRow(RowPane theComponent) {
        if (this.pnlRows.getComponentCount() == 1) {
            this.removeAll();
        } else {
            this.pnlRows.remove(theComponent);
        }
        this.updateUI();
    }

    public void insertRow(RowPane after, RowPane theRow) {
        this.pnlRows.add((Component)theRow, this.getRowIndex(after) + 1);
        this.pnlRows.updateUI();
    }

    public int getRowIndex(RowPane theRow) {
        int result = 0;
        int n = this.pnlRows.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (!this.pnlRows.getComponent(i).equals(theRow)) continue;
            result = i;
            break;
        }
        return result;
    }

    public RowPane getLastRowPane() {
        return (RowPane)this.pnlRows.getComponent(this.getRowCount() - 1);
    }

    public int getRowCount() {
        return this.pnlRows.getComponentCount();
    }

    public RowPaneInfo[] getRowPanesInfo() {
        ArrayList<RowPaneInfo> result = new ArrayList<RowPaneInfo>();
        int nCount = this.getRowCount();
        for (int i = 0; i < nCount; ++i) {
            RowPane rowPane = (RowPane)this.pnlRows.getComponent(i);
            RowPaneInfo rowPaneInfo = rowPane.getRowPaneInfo();
            if (rowPaneInfo == null) continue;
            result.add(rowPaneInfo);
        }
        return result.toArray(new RowPaneInfo[0]);
    }

    public RowPane[] removeRowsAfter(RowPane pnlRow) {
        int rowIndex = this.getRowIndex(pnlRow) + 1;
        int count = this.pnlRows.getComponentCount() - rowIndex;
        RowPane[] result = new RowPane[count];
        int nLen = result.length;
        for (int i = 0; i < nLen; ++i) {
            result[i] = (RowPane)this.pnlRows.getComponent(rowIndex);
            this.pnlRows.remove(result[i]);
        }
        this.updateUI();
        return result;
    }

    private class AndOrAction
    extends AbstractAction {
        int operator;

        public AndOrAction(int operator) {
            this.operator = operator;
        }

        public void actionPerformed(ActionEvent e) {
            GroupPane.this.btnAddGroup.setOperator(this.operator);
        }
    }
}

