/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.appframework.mvc.Command;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.application.GWTable;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.dialogs.rules.CreateRuleDialog;
import com.novell.gw.jclient.application.dialogs.rules.RulesTableController;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.rules.Rule;
import com.novell.gw.rules.RuleList;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class RulesTable
extends GWTable
implements MVCView {
    private static Logger logger = Logger.getLogger(RulesTable.class);
    private RulesTableController controller;
    private RuleList ruleList;
    private AbstractButton btnEnableRule;
    private IItem[] items;
    private AbstractFolder folder;
    private String userGuid;

    public RulesTable(MVCController parentController, JButton theBtnEnableRule, AbstractFolder theFolder, IItem[] items, String userGuid) {
        this.userGuid = userGuid;
        this.controller = new RulesTableController(this, parentController);
        this.ruleList = GWCommandManager.getInstance(this.userGuid).getRuleList();
        this.btnEnableRule = theBtnEnableRule;
        this.folder = theFolder;
        this.items = items;
        this.setModel(new RulesTableModel());
        this.getSelectionModel().setSelectionMode(0);
        this.tableHeader.setReorderingAllowed(false);
        if (OS.isMacOS()) {
            Dimension size = new Dimension(20, 22);
            this.tableHeader.setSize(size);
            this.tableHeader.setPreferredSize(size);
            this.tableHeader.setMinimumSize(size);
        }
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.addListSelectionListener(new RulesTableListSelectionListener());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (OS.isDoubleClick(e)) {
                    RulesTable.this.editRule();
                }
            }
        });
        if (this.getColumnModel().getColumnCount() > 0) {
            this.getColumnModel().getColumn(0).setPreferredWidth(20);
            this.getColumnModel().getColumn(0).setMaxWidth(20);
            this.getColumnModel().getColumn(0).setMinWidth(20);
            this.getColumnModel().getColumn(0).setResizable(false);
        }
    }

    public void editRule() {
        this.showCreateRuleDialog(this.getSelectedRule());
    }

    public void copyRule() {
        Rule copiedRule = this.ruleList.copyRule(this.getSelectedRow());
        this.showCreateRuleDialog(copiedRule);
    }

    private void showCreateRuleDialog(Rule rule) {
        Window window = ControlsUtils.getWindowForComponent(this);
        CreateRuleDialog dialog = new CreateRuleDialog((JDialog)window, (MVCController)((MVCView)((Object)window)).getController(), rule, this.userGuid);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public void refresh() {
        MessageUtils.showBusyCursor(true);
        this.ruleList.refresh(GWCommandManager.getInstance(this.userGuid).getCurrentDataStore().getNativeDataStore());
    }

    public void moveUp() {
        int selectedRow = this.getSelectedRow();
        this.ruleList.moveRule(selectedRow--, selectedRow);
        this.ruleList = GWCommandManager.getInstance(this.userGuid).getRuleList();
        this.updateTable(selectedRow);
    }

    public void refreshTable() {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.ruleList = GWCommandManager.getInstance(this.userGuid).getRuleList();
        this.updateTable(0);
        MessageUtils.showBusyCursor(false);
    }

    private void updateTable(int selectedRow) {
        ((AbstractTableModel)this.getModel()).fireTableDataChanged();
        this.selectNearestRow(selectedRow);
    }

    public void moveDown() {
        int selectedRow = this.getSelectedRow();
        this.ruleList.moveRule(this.getSelectedRule(), selectedRow + 2);
        this.ruleList = GWCommandManager.getInstance(this.userGuid).getRuleList();
        this.updateTable(++selectedRow);
    }

    private Rule getSelectedRule() {
        int selectedRow = this.getSelectedRow();
        Rule rule = this.ruleList.getRuleAt(selectedRow);
        return rule;
    }

    public void selectRow(int theIndex) {
        if (this.ruleList.getSize() > 0) {
            this.setRowSelectionInterval(theIndex, theIndex);
        }
    }

    public void setController(MVCController theController) {
        if (theController instanceof RulesTableController) {
            this.controller = (RulesTableController)theController;
        }
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
    }

    public void refreshModel() {
        int index = this.getSelectedRow();
        if (this.ruleList != null) {
            this.ruleList.disable();
        }
        this.ruleList = GWCommandManager.getInstance(this.userGuid).getRuleList();
        this.updateTable(index);
    }

    public Object getMVCModel() {
        return null;
    }

    public void setSelectedRuleEnabled() {
        this.toggleRuleStatus(this.getSelectedRow());
    }

    public void deleteSelectedRule() {
        int index = this.getSelectedRow();
        boolean b = this.ruleList.deleteRule(index);
        if (b) {
            IDataStore dataStore;
            if (this.ruleList != null) {
                this.ruleList.disable();
            }
            this.ruleList = GWCommandManager.getInstance(this.userGuid).getRuleList();
            this.updateTable(index);
            if (this.ruleList.getSize() == 0) {
                Command command = new Command(320);
                this.getController().processCommand(command);
            }
            if ((dataStore = GWCommandManager.getInstance(this.userGuid).getCurrentDataStore()) != null && dataStore.getVacationRuleInfo() == null) {
                GlobalCommand command = new GlobalCommand(335);
                this.getController().processCommand(command);
            }
        }
    }

    private void selectNearestRow(int theIndex) {
        if (theIndex >= this.ruleList.getSize()) {
            --theIndex;
        }
        if (theIndex >= 0) {
            this.setRowSelectionInterval(theIndex, theIndex);
        }
    }

    private void setRuleEnabledAt(int index, boolean b) {
        Rule rule = this.ruleList.getRuleAt(index);
        if (rule.isEnabled() != b) {
            this.toggleRuleStatus(index);
        }
    }

    private void toggleRuleStatus(int index) {
        Rule rule = this.ruleList.getRuleAt(index);
        this.ruleList.toggleRuleStatus(index);
        this.repaint();
        String text = rule.isEnabled() ? StringResources.DISABLE : StringResources.ENABLE;
        this.btnEnableRule.setText(text);
    }

    public void executeRule() {
        if (this.folder != null) {
            this.ruleList.executeRule(this.getSelectedRow(), this.folder.getNativeFolder().getNativeFolder());
        } else if (this.items != null && this.items.length > 0) {
            this.ruleList.executeRule(this.getSelectedRow(), APIWrapperManager.getNativeItemArray(this.items));
        } else {
            this.ruleList.executeRule(this.getSelectedRow());
        }
    }

    protected class RulesTableListSelectionListener
    implements ListSelectionListener {
        protected RulesTableListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            int index = RulesTable.this.getSelectedRow();
            if (index != -1) {
                Command command = new Command(310, RulesTable.this.ruleList.getRuleAt(index));
                RulesTable.this.getController().processCommand(command);
            } else {
                Command command = new Command(320);
                RulesTable.this.getController().processCommand(command);
            }
        }
    }

    protected class RulesTableModel
    extends AbstractTableModel {
        private String[] columns = new String[]{"", StringResources.RULE_NAME, StringResources.EVENT};

        protected RulesTableModel() {
        }

        public int getRowCount() {
            return RulesTable.this.ruleList.getSize();
        }

        public int getColumnCount() {
            return this.columns.length;
        }

        public String getColumnName(int column) {
            return this.columns[column];
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue instanceof Boolean) {
                RulesTable.this.setRuleEnabledAt(rowIndex, (Boolean)aValue);
            }
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        private String getEventType(Rule theRule) {
            switch (theRule.getEventExecutionType()) {
                case 5: {
                    return StringResources.NEW_ITEM;
                }
                case 10: {
                    return StringResources.FILED_ITEM;
                }
                case 19: {
                    return StringResources.COMPLETED_ITEM;
                }
                case 4: {
                    return StringResources.OPEN_FOLDER;
                }
                case 3: {
                    return StringResources.CLOSE_FOLDER;
                }
                case 1: {
                    return StringResources.STARTUP;
                }
                case 2: {
                    return StringResources.EXIT;
                }
                case 9: {
                    return StringResources.USER_ACTIVATED;
                }
            }
            return "";
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return RulesTable.this.ruleList.getRuleAt(rowIndex).isEnabled();
                }
                case 1: {
                    return RulesTable.this.ruleList.getRuleAt(rowIndex).getName();
                }
                case 2: {
                    return this.getEventType(RulesTable.this.ruleList.getRuleAt(rowIndex));
                }
            }
            return "";
        }
    }
}

