/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.timedifference;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public abstract class TimeDocument
extends PlainDocument {
    private static Logger logger = Logger.getLogger(TimeDocument.class);

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (offs > 1 || str.length() > 2) {
            return;
        }
        String string = this.getTotalString(offs, str);
        if (!TimeDocument.isDigit(string)) {
            return;
        }
        int time = 0;
        try {
            time = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            logger.debug((Object)e);
        }
        if (!this.isPossibleTime(time)) {
            return;
        }
        super.insertString(offs, str, a);
    }

    public abstract boolean isPossibleTime(int var1);

    private String getTotalString(int offs, String theString) {
        StringBuffer sb = new StringBuffer("");
        try {
            String str = this.getText(0, this.getLength());
            sb = new StringBuffer(str);
        }
        catch (BadLocationException e) {
            logger.debug((Object)e);
        }
        sb.insert(offs, theString);
        return sb.toString();
    }

    public static boolean isDigit(String theString) {
        if (theString == null || theString.length() == 0) {
            return false;
        }
        char[] c = theString.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (Character.isDigit(c[i])) continue;
            return false;
        }
        return true;
    }
}

