/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames;

import com.appframework.ApplicationFrame;
import com.appframework.components.htmleditor.GWMozillaBrowserCanvas;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class WindowFocusOwnerChangeListener
implements PropertyChangeListener {
    private static final String PROPERTY_NAME = "focusOwner";
    private static final String WEBRENDERER_PACKAGE_PREFIX = "com.webrenderer";
    private MVCView parentWindow = null;
    private Component currentExternalBrowser = null;

    public WindowFocusOwnerChangeListener(ApplicationFrame parentFrame) {
        if (parentFrame == null) {
            throw new IllegalArgumentException("parentFrame is null");
        }
        this.parentWindow = parentFrame;
    }

    public WindowFocusOwnerChangeListener(GWDialog parentDialog) {
        if (parentDialog == null) {
            throw new IllegalArgumentException("parentDialog is null");
        }
        this.parentWindow = parentDialog;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!PROPERTY_NAME.equals(evt.getPropertyName())) {
            return;
        }
        Object focusOwner = evt.getNewValue();
        if (focusOwner instanceof Component) {
            Window parent = SwingUtilities.getWindowAncestor((Component)focusOwner);
            if (this.parentWindow != parent) {
                return;
            }
        } else {
            return;
        }
        assert (focusOwner instanceof Component);
        if (focusOwner.getClass().getName().startsWith(WEBRENDERER_PACKAGE_PREFIX)) {
            this.handleBrowserFocusGained((Component)focusOwner);
        } else {
            this.handleBrowserFocusLost((Component)focusOwner);
        }
    }

    private void handleBrowserFocusLost(Component focusOwner) {
        if (!this.isExternalBrowserFocused()) {
            return;
        }
        if (focusOwner instanceof JRootPane) {
            return;
        }
        this.currentExternalBrowser = null;
        ((MVCController)this.parentWindow.getController()).processCommand(new Command(1330, null));
    }

    private void handleBrowserFocusGained(Component focusOwner) {
        Component browser = null;
        Component component = focusOwner;
        do {
            if (component instanceof GWMozillaBrowserCanvas) {
                browser = component;
                break;
            }
            if (!((component = component.getParent()) instanceof Window)) continue;
            throw new IllegalStateException("Window reached, bug GWMozillaBrowserCanvas not found: " + focusOwner);
        } while (component != null);
        if (browser == null) {
            throw new IllegalStateException("focusOwner has NULL as its top parent: " + focusOwner);
        }
        if (browser == this.currentExternalBrowser) {
            return;
        }
        this.currentExternalBrowser = browser;
        ((MVCController)this.parentWindow.getController()).processCommand(new Command(1330, browser));
    }

    private boolean isExternalBrowserFocused() {
        return this.currentExternalBrowser != null;
    }
}

