/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.compose;

import com.appframework.Application;
import com.appframework.ApplicationFrameActionList;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.ActionComplete;
import com.novell.gw.jclient.application.actions.send.ActionPost;
import com.novell.gw.jclient.application.controls.itemedit.AppointmentEditPanel;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.controls.itemedit.MailEditPanel;
import com.novell.gw.jclient.application.controls.itemedit.PhoneEditPanel;
import com.novell.gw.jclient.application.controls.itemedit.PostedEditPanel;
import com.novell.gw.jclient.application.controls.itemedit.ReminderNoteEditPanel;
import com.novell.gw.jclient.application.controls.itemedit.TaskEditPanel;
import com.novell.gw.jclient.application.controls.menus.FrameComposePostedMenuBar;
import com.novell.gw.jclient.application.controls.toolbars.FrameComposePostedToolBar;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBarPanel;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.frames.compose.FrameComposeActionList;
import com.novell.gw.jclient.application.impl.SelectedItemsInfoImpl;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.MailItem;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import com.novell.gw.jclient.bl.om.items.sendoptions.AppSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.ComposeItemSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.MailSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.NoteSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.TaskSendOptions;
import com.novell.gw.jclient.bl.om.options.ItemSendOptions;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class FrameComposePostedItem
extends FrameCompose {
    private static Logger logger = Logger.getLogger(FrameComposePostedItem.class);
    private boolean isModify = false;
    private MVCController parentMainFrameController;
    private JCheckBox cbCompleted;

    public FrameComposePostedItem(AbstractItem theNewItem, boolean isModify, ComposeMode composeMode, String userGuid) {
        super("", false, FrameComposePostedItem.getFrameName(theNewItem), FrameComposePostedItem.getToolBarName(theNewItem), userGuid);
        this.isModify = isModify;
        ActionPost action = (ActionPost)((FrameComposeActionList)this.getController()).getAction(ActionKey.POST_ITEM);
        action.setModify(isModify);
        this.buildUI(theNewItem, composeMode);
        this.parentMainFrameController = Application.getGWMainAppFrame().getController();
        Command command = new Command(1070, this.parentMainFrameController);
        ((FrameComposeActionList)this.getController()).processCommand(command);
        this.setGWMenuBar(new FrameComposePostedMenuBar((ApplicationFrameActionList)this.getController(), isModify, theNewItem.getType()));
        this.itemEdit.setMVCModel(theNewItem);
        this.setFocusTraversalPolicy(this.itemEdit.getFocusPolicy());
        this.showToolbar();
        try {
            theNewItem.markOpen();
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
        }
        command = new Command(20, new SelectedItemsInfoImpl(null, theNewItem));
        ((FrameComposeActionList)this.getController()).processCommand(command);
    }

    protected void buildUI(AbstractItem theNewItem, ComposeMode composeMode) {
        GWToolBarPanel toolBarPanel = new GWToolBarPanel();
        this.toolbar = new FrameComposePostedToolBar((ApplicationFrameActionList)this.getController(), this.isModify, theNewItem.getType());
        toolBarPanel.add((Component)this.toolbar, "Center");
        this.setToolBarPanel(toolBarPanel, "North");
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setMinimumSize(new Dimension(720, 550));
        contentPane.setPreferredSize(new Dimension(720, 550));
        ItemSendOptions iso = OptionManager.getInstance().getSendOptions(this.getUserGuid()).getItemSendOptions();
        if (theNewItem instanceof MailItem) {
            this.itemEdit = new MailEditPanel(this.getController(), composeMode, this.isModify);
            this.setIconImage(ImageResources.ICON_ACT_NEW_MAIL.getImage());
            this.setTitle(StringResources.POSTED_MAIL);
            MailSendOptions sendOptions = new MailSendOptions(iso, true);
            this.itemEdit.setSendOptions(theNewItem.getComposeItemSendOptions(sendOptions));
        } else if (theNewItem instanceof AppointmentItem) {
            this.itemEdit = new AppointmentEditPanel(this.getController(), composeMode, this.isModify);
            this.setIconImage(ImageResources.ICON_ACT_NEW_APPOINTMENT.getImage());
            this.setTitle(StringResources.POSTED_APPOINTMENT);
            AppSendOptions sendOptions = new AppSendOptions(iso, true);
            this.itemEdit.setSendOptions(theNewItem.getComposeItemSendOptions(sendOptions));
        } else if (theNewItem instanceof TaskItem) {
            this.itemEdit = new TaskEditPanel(this.getController(), true, composeMode, this.isModify);
            this.setIconImage(ImageResources.ICON_ACT_NEW_TASK.getImage());
            this.setTitle(StringResources.POSTED_TASK);
            TaskSendOptions sendOptions = new TaskSendOptions(iso, true);
            this.itemEdit.setSendOptions(theNewItem.getComposeItemSendOptions(sendOptions));
            ActionComplete actionComplete = (ActionComplete)((FrameComposeActionList)this.getController()).getActionList().getAction(ActionKey.COMPLETE);
            this.cbCompleted = new JCheckBox(actionComplete);
            actionComplete.getGroup().add(this.cbCompleted);
            this.cbCompleted.setText(StringResources.COMPLETED);
            this.cbCompleted.setSelected(theNewItem.isStatusCompleted());
            this.panStatusPanel.add(this.cbCompleted);
        } else if (theNewItem instanceof ReminderNote) {
            this.itemEdit = new ReminderNoteEditPanel(this.getController(), composeMode, this.isModify);
            this.setIconImage(ImageResources.ICON_ACT_NEW_REMINDERNOTE.getImage());
            this.setTitle(StringResources.POSTED_REMINDER_NOTE);
            NoteSendOptions sendOptions = new NoteSendOptions(iso, true);
            this.itemEdit.setSendOptions(theNewItem.getComposeItemSendOptions(sendOptions));
        } else if (theNewItem instanceof PhoneItem) {
            this.itemEdit = new PhoneEditPanel(this.getController(), composeMode, this.isModify);
            this.setIconImage(ImageResources.ICON_ACT_NEW_PHONEMESSAGE.getImage());
            this.setTitle(StringResources.POSTED_PHONE);
            MailSendOptions sendOptions = new MailSendOptions(iso, true);
            this.itemEdit.setSendOptions(theNewItem.getComposeItemSendOptions(sendOptions));
        } else {
            throw new IllegalArgumentException("Posted item type [" + theNewItem.getClass().getName() + "] not supported");
        }
        this.itemEdit.setFrom(theNewItem.getNativeItem().getFromText());
        this.centeredContentPanel.add((Component)new PostedEditPanel(this.itemEdit), "Center");
    }

    public MVCController getParentMainFrameController() {
        return this.parentMainFrameController;
    }

    public ComposeItemSendOptions getItemSendOptions() {
        return null;
    }

    public void updateTitle(String string) {
    }

    private static String getFrameName(AbstractItem item) {
        if (item instanceof MailItem) {
            return "POST_MAIL_FRAME";
        }
        if (item instanceof AppointmentItem) {
            return "POST_APPOINTMENT_FRAME";
        }
        if (item instanceof TaskItem) {
            return "POST_TASK_FRAME";
        }
        if (item instanceof ReminderNote) {
            return "POST_REMINDER_NOTE_FRAME";
        }
        if (item instanceof PhoneItem) {
            return "COMPOSE_PHONE_FRAME";
        }
        throw new IllegalArgumentException("Not allowed item type");
    }

    private static String getToolBarName(AbstractItem item) {
        if (item instanceof MailItem) {
            return "POSTED_MAIL_ITEM_TOOLBAR_VISIBLE";
        }
        if (item instanceof AppointmentItem) {
            return "POSTED_APPOINTMENT_ITEM_TOOLBAR_VISIBLE";
        }
        if (item instanceof TaskItem) {
            return "POSTED_TASK_ITEM_TOOLBAR_VISIBLE";
        }
        if (item instanceof ReminderNote) {
            return "POSTED_REMINDER_NOTE_ITEM_TOOLBAR_VISIBLE";
        }
        if (item instanceof PhoneItem) {
            return "POSTED_PHONE_ITEM_TOOLBAR_VISIBLE";
        }
        throw new IllegalArgumentException("Unknown item type");
    }

    public boolean isModify() {
        return this.isModify;
    }
}

