/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.dateAndTime;

import com.appframework.mvc.MVCController;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.dateAndTime.TimePickerPanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;

public class BusySearchOptionsPanel
extends AbstractOptionPanel {
    private JCheckBox cbMonday;
    private JCheckBox cbTuesday;
    private JCheckBox cbWednesday;
    private JCheckBox cbThursday;
    private JCheckBox cbFriday;
    private JCheckBox cbSaturday;
    private JCheckBox cbSunday;
    private JCheckBox cbPublishingBusySearch;
    private HashMap<Integer, JCheckBox> buttons;
    private JButton btnSendBusySearch;
    private TimePickerPanel pnlTimePicker;
    private JSpinner spnSearchRange;
    private JLabel lblPublishLocation;

    public BusySearchOptionsPanel(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
    }

    private void init() {
        this.spnSearchRange = new OrientableSpinner(new SpinnerNumberModel(7, 7, 99, 1));
        this.spnSearchRange.addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
        this.pnlTimePicker = new TimePickerPanel(this.changesListener, this.controller, true);
        this.cbMonday = new JMnemonicCheckBox(StringResources.MONDAY);
        this.cbMonday.addItemListener(this.itemListener);
        this.cbTuesday = new JMnemonicCheckBox(StringResources.TUESDAY);
        this.cbTuesday.addItemListener(this.itemListener);
        this.cbWednesday = new JMnemonicCheckBox(StringResources.WEDNESDAY);
        this.cbWednesday.addItemListener(this.itemListener);
        this.cbThursday = new JMnemonicCheckBox(StringResources.THURSDAY);
        this.cbThursday.addItemListener(this.itemListener);
        this.cbFriday = new JMnemonicCheckBox(StringResources.FRIDAY);
        this.cbFriday.addItemListener(this.itemListener);
        this.cbSaturday = new JMnemonicCheckBox(StringResources.SATURDAY);
        this.cbSaturday.addItemListener(this.itemListener);
        this.cbSunday = new JMnemonicCheckBox(StringResources.SUNDAY);
        this.cbSunday.addItemListener(this.itemListener);
        this.cbPublishingBusySearch = new JMnemonicCheckBox(StringResources.PUBLISHING_BUSY_SEARCH);
        this.cbPublishingBusySearch.addItemListener(this.itemListener);
        this.btnSendBusySearch = new OrientableButton(StringResources.SEND_BUSY_SEARCH_PUBLISH_LOCATION_D);
        this.btnSendBusySearch.addItemListener(this.itemListener);
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        String url = dataStoreSettings.getBusySearchPublishFreebusyURL().getValue().toString();
        this.lblPublishLocation = new OrientableLabel(url.equals("") ? "                      " : " " + url + " ");
        int m = 1;
        this.buttons = new HashMap();
        this.buttons.put(m, this.cbSunday);
        this.buttons.put(m *= 2, this.cbMonday);
        this.buttons.put(m *= 2, this.cbTuesday);
        this.buttons.put(m *= 2, this.cbWednesday);
        this.buttons.put(m *= 2, this.cbThursday);
        this.buttons.put(m *= 2, this.cbFriday);
        this.buttons.put(m *= 2, this.cbSaturday);
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 23;
        constraints.fill = 1;
        this.add((Component)this.createRangeAndTimePanel(), constraints);
        constraints.gridx = 1;
        constraints.fill = 2;
        this.add((Component)this.createDaysToSearchPanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.weighty = 1.0;
        this.add((Component)this.createPublishPanel(), constraints);
    }

    protected void build() {
        this.init();
        this.buildUI();
    }

    public void collectValues() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        dataStoreSettings.setBusySearchRange(((Integer)this.spnSearchRange.getValue()).intValue());
        dataStoreSettings.setBusySearchStartMinutes(this.pnlTimePicker.getStartTime());
        dataStoreSettings.setBusySearchEndMinutes(this.pnlTimePicker.getEndTime());
        int m = 1;
        int mask = 0;
        for (int i = 0; i < 7; ++i) {
            if (this.buttons.get(m).isSelected()) {
                mask += m;
            }
            m *= 2;
        }
        dataStoreSettings.setBusySearchDays(mask);
        dataStoreSettings.setBusySearchPublishFreebusy(this.cbPublishingBusySearch.isSelected());
    }

    public void fireOptionsChanged() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        this.spnSearchRange.setEnabled(!dataStoreSettings.getBusySearchRange().isLocked());
        this.spnSearchRange.getModel().setValue(dataStoreSettings.getBusySearchRange().getValue());
        this.pnlTimePicker.setEnabled(!dataStoreSettings.getBusySearchStartMinutes().isLocked());
        this.pnlTimePicker.setStartTime((Integer)dataStoreSettings.getBusySearchStartMinutes().getValue());
        this.pnlTimePicker.setEndTime((Integer)dataStoreSettings.getBusySearchEndMinutes().getValue());
        int mask = (Integer)dataStoreSettings.getBusySearchDays().getValue();
        boolean isLocked = dataStoreSettings.getBusySearchDays().isLocked();
        int m = 64;
        for (int i = 0; i < 7; ++i) {
            if (mask / m == 1) {
                mask -= m;
                this.buttons.get(m).setSelected(true);
            }
            this.buttons.get(m).setEnabled(!isLocked);
            m /= 2;
        }
        this.cbPublishingBusySearch.setEnabled(!dataStoreSettings.getBusySearchPublishFreebusy().isLocked());
        this.cbPublishingBusySearch.setSelected((Boolean)dataStoreSettings.getBusySearchPublishFreebusy().getValue());
        this.lblPublishLocation.setBorder(new LineBorder(Color.RED));
        this.btnSendBusySearch.setBackground(Color.RED);
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
    }

    private JPanel createRangeAndTimePanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(StringResources.RANGE_AND_TIME_TO_SEARCH));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(10, 10, 5, 0);
        constraints.anchor = 23;
        panel.add((Component)new JMnemonicLabel(StringResources.SEARCH_RANGE_C, this.spnSearchRange), constraints);
        ++constraints.gridx;
        panel.add((Component)this.spnSearchRange, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(10, 5, 5, 10);
        panel.add((Component)new OrientableLabel(StringResources.L_DAYS), constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 3;
        constraints.insets = new Insets(10, 10, 10, 10);
        constraints.weighty = 1.0;
        panel.add((Component)this.createTimePanel(), constraints);
        return panel;
    }

    private JPanel createDaysToSearchPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(StringResources.DAYS_TO_SEARCH));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 10, 0, 10);
        panel.add((Component)this.cbMonday, constraints);
        ++constraints.gridy;
        constraints.insets.top = 0;
        panel.add((Component)this.cbTuesday, constraints);
        ++constraints.gridy;
        panel.add((Component)this.cbWednesday, constraints);
        ++constraints.gridy;
        panel.add((Component)this.cbThursday, constraints);
        ++constraints.gridy;
        panel.add((Component)this.cbFriday, constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        panel.add((Component)this.cbSaturday, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(0, 10, 10, 10);
        constraints.weightx = 1.0;
        panel.add((Component)this.cbSunday, constraints);
        return panel;
    }

    private JPanel createPublishPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(StringResources.PUBLISH));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)this.cbPublishingBusySearch, constraints);
        ++constraints.gridy;
        panel.add((Component)new OrientableLabel(StringResources.PUBLISH_LOCATION_C), constraints);
        ++constraints.gridy;
        constraints.insets.top = 5;
        this.lblPublishLocation.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        this.lblPublishLocation.setOpaque(false);
        panel.add((Component)this.lblPublishLocation, constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(5, 10, 10, 10);
        panel.add((Component)this.btnSendBusySearch, constraints);
        return new JPanel();
    }

    private JPanel createTimePanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 2, 10);
        constraints.anchor = 21;
        panel.add((Component)new JMnemonicLabel(StringResources.FROM_TIME_C, this.pnlTimePicker), constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 0;
        panel.add((Component)new JMnemonicLabel(StringResources.TO_TIME_C, this.pnlTimePicker), constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridheight = 2;
        panel.add((Component)this.pnlTimePicker, constraints);
        return panel;
    }
}

