/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.dateAndTime;

import com.appframework.mvc.MVCController;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import javax.swing.JCheckBox;

public class DaySelectionPanel
extends AbstractOptionPanel {
    private HashMap<Integer, JCheckBox> buttons;
    private HashMap<Integer, String> titles;

    public DaySelectionPanel(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
        this.init();
        this.buildUI();
    }

    private void init() {
        this.buttons = new HashMap();
        this.titles = new HashMap();
        this.put(1, StringResources.SUNDAY_SHORTEST);
        this.put(2, StringResources.MONDAY_SHORTEST);
        this.put(4, StringResources.TUESDAY_SHORTEST);
        this.put(8, StringResources.WEDNESDAY_SHORTEST);
        this.put(16, StringResources.THURSDAY_SHORTEST);
        this.put(32, StringResources.FRIDAY_SHORTEST);
        this.put(64, StringResources.SATURDAY_SHORTEST);
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets.right = 5;
        this.add((Component)new JMnemonicLabel(StringResources.WORK_DAYS_C, this), constraints);
        int m = 1;
        for (int i = 0; i < 7; ++i) {
            ++constraints.gridx;
            constraints.gridy = 0;
            this.add((Component)new OrientableLabel(this.titles.get(m)), constraints);
            constraints.gridy = 1;
            this.add((Component)this.buttons.get(m), constraints);
            m *= 2;
        }
    }

    public void setSelected() {
        int m = 1;
        for (int i = 0; i < 7; ++i) {
            this.buttons.get(m).setSelected(true);
            m *= 2;
        }
    }

    private void put(Integer name, String title) {
        JCheckBox checkBox = new JCheckBox();
        checkBox.addItemListener(this.itemListener);
        this.buttons.put(name, checkBox);
        this.titles.put(name, title);
    }

    protected void build() {
    }

    public void collectValues() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        int mask = 0;
        int m = 1;
        for (int i = 0; i < 7; ++i) {
            if (this.buttons.get(m).isSelected()) {
                mask += m;
            }
            m *= 2;
        }
        dataStoreSettings.setCalendarWorkDays(mask);
    }

    public void fireOptionsChanged() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        int mask = (Integer)dataStoreSettings.getCalendarWorkDays().getValue();
        int m = 64;
        for (int i = 0; i < 7; ++i) {
            if (mask / m == 1) {
                mask -= m;
                this.buttons.get(m).setSelected(true);
            }
            m /= 2;
        }
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
    }
}

